#include  "defns.i"
#include  "extern.i"


Boolean ProposeDeterminateLiteral(R, A, LitBits, FreeVars)
/*      -------------------------  */
    Relation R;
    Vars A;
    float LitBits;
    int FreeVars;
{
    int MaxSoFar, PreviousMax, This, i, j;
    Var V;
    Literal L;
    static int Variables;
    Boolean SensibleBinding = false;

    if ( ! NDeterminate ) Variables = MaxVar;

    This = NLit + NDeterminate;

    if ( Variables + FreeVars >= MAXARITY ) return false;

    /*  See whether have something effectively the same, or whether this
	determinate literal's bound variables were all bound by determinate
	literals on the same relation  */

    ForEach(j, 1, R->Arity)
    {
	SensibleBinding |= ( A[j] <= Target->Arity );
    }

    MaxSoFar = Target->Arity;
    ForEach(i, 0, NLit+NDeterminate-1)
    {
	if ( ! NewClause[i]->Sign ) continue;

	if ( NewClause[i]->Rel == R &&
	     Unifiable(R->Arity, NewClause[i]->Args, MaxVar, A, MaxVar) )
	{
            VERBOSE(2)
	    {
		printf("\tunifiable with ");
		PrintLiteral(R, true, NewClause[i]->Args);
		printf("\n");
	    }
	    return false;
	}

	if ( i >= NLit ) continue;

	PreviousMax = MaxSoFar;
	ForEach(j, 1, NewClause[i]->Rel->Arity)
	{
	    if ( (V = NewClause[i]->Args[j]) > MaxSoFar ) MaxSoFar = V;
	}

	if ( NewClause[i]->Rel != R || NewClause[i]->Sign != 2 )
	{
	    ForEach(j, 1, R->Arity)
	    {
		SensibleBinding |= ( A[j] <= MaxSoFar && A[j] > PreviousMax );
	    }
	}
    }

    if ( ! SensibleBinding )
    {
	VERBOSE(2)
	{
	    printf("\tall variables bound by determinate lits on same");
	    printf("relation\n");
	}
	return false;
    }

    /*  Record this determinate literal  */

    L = NewClause[This] = (Literal) pmalloc(sizeof(struct _lit_rec));

    if((This+1)%100==0)
    {
        NewClause=(Clause)prealloc(NewClause,(This+101)*sizeof(Literal));
    }

    L->Rel  = R;
    L->Sign = 2;
    L->Bits = LitBits;
    L->Args = (Vars) pmalloc(R->Arity+1);
    memcpy(L->Args, A, R->Arity+1);

    L->FloatingDet = true;

    NDeterminate++;
    Variables += FreeVars;

    return true;
}



	/*  See whether two arg lists can be unified.  "Free"
	    variables in A1 are those with values above Bound1;
	    similarly for A2  */

Boolean Unifiable(N, A1, Bound1, A2, Bound2)
/*      ---------  */
    int N, Bound1, Bound2;
    Vars A1, A2;
{
    int X1[MAXARITY+1], X2[MAXARITY+1], i, V, T;

    /*  Make all free variables > 1000  */

    ForEach(i, 1, N)
    {
	X1[i] = A1[i];
	X2[i] = (A2[i] > Bound2 ? 2000 + A2[i]-Bound2 : A2[i]);
    }

    ForEach(i, 1, N)
    {
	if ( X1[i] == X2[i] ) continue;

	if ( X1[i] > 1000 )
	{
	    V = X1[i];
	    T = X2[i];
	}
	else
	if ( X2[i] > 1000 )
	{
	    V = X2[i];
	    T = X1[i];
	}
	else return false;

	Substitute(V, T, X1, i, N);
	Substitute(V, T, X2, i, N);
    }

    return true;
}


    Substitute(V, T, X, i, N)
/*  ----------  */
    int V, T, X[], i, N;
{
    for ( ; i <= N ; i++ )
    {
	if ( X[i] == V ) X[i] = T;
    }
}


    ProcessDeterminateLiterals()
/*  --------------------------  */
{
    int SaveWeakLiterals, SaveMaxVar, i, j, l, ll;
    Literal L;
    Var V;
    Boolean Unique, SameVar();

    SaveWeakLiterals = WeakLiterals;
    OldMaxVar = MaxVar;

    VERBOSE(1) printf("\nDeterminate literals\n");

    ForEach(l, 1, NDeterminate)
    {
	L = NewClause[NLit++];

	/*  Rename free variables  */

	ForEach(i, 1, L->Rel->Arity)
	{
	    if ( L->Args[i] > OldMaxVar ) L->Args[i] += MaxVar - OldMaxVar;
	}

	/* Recursive Literal Consistency Check */
	if(L->Rel==Target)
	{
	    DiscoverPartialOrders();
	    if(!RecursiveCallOK(L->Args))
	    {
	        VERBOSE(1)
		{
		    putchar('\t');
		    PrintLiteral(L->Rel, L->Sign, L->Args);
		    printf(" --- fails recursion check\n");
		}

		NLit--;
		ForEach(ll, 1, NDeterminate-l)
		{
		    NewClause[NLit+ll-1] = NewClause[NLit+ll];
		}
		continue;
	    }
	}

	SaveMaxVar = MaxVar;
	NewSize = 0;
        FormNewTrainingSet(L->Rel, true, L->Args);

	/*  Verify that new variables don't replicate existing variables  */

	for ( i = SaveMaxVar+1 ; i <= NewMaxVar ; )
	{
	    Unique = true;

	    for ( j = 1 ; Unique && j <= SaveMaxVar ; j++ )
	    {
		Unique = ! SameVar(i, j);
	    }

	    if ( Unique )
	    {
		i++;
	    }
	    else
	    {
		j--;

		VERBOSE(1)
		{
		    printf("\t\t\t!!! %s = %s\n", Variable[i]->Name, 
                                                  Variable[j]->Name);
		}

		ShiftVarsDown(i);

		ForEach(V, 1, L->Rel->Arity)
		{
		    if ( L->Args[V] == i ) L->Args[V] = j;
		    else
		    if ( L->Args[V] >  i ) L->Args[V]--;
		}
	    }
	}

	VERBOSE(1)
	{
	    putchar('\t');
	    PrintLiteral(L->Rel, L->Sign, L->Args);
	    printf(" (%.1f bits)", L->Bits);
	}

	/*  If no variables remain, delete this literal  */

	if ( SaveMaxVar == NewMaxVar )
	{
	    VERBOSE(1) printf(" -- no remaining variables\n");
	
	    NLit--;

	    ForEach(ll, 1, NDeterminate-l)
	    {
		NewClause[NLit+ll-1] = NewClause[NLit+ll];
	    }

	    Discard(NewTS, true);
	}
	else
	{
	    /* This Determinate Literal is being kept in the clause */

	    VERBOSE(1) newline;

	    NewVariableDependencies(L);

	    AcceptNewTrainingSet(L->Rel, true, L->Args);

	    if(L->Rel==Target) AddOrderingsDueTo(L);
	}
    }
    WeakLiterals = SaveWeakLiterals + 1;
}



/*  See whether variable a is always the same as variable b in
    all positive tuples  */

Boolean SameVar(a, b)
/*      -------  */
    int a, b;
{
    Tuple *TSP, Case;

    for ( TSP = NewTS ; Case = *TSP++; )
    {
	if ( Positive(Case) && Case[a] != Case[b] ) return false;
    }

    /*  If same, delete any negative tuples where different  */

    for ( TSP = NewTS ; Case = *TSP; )
    {
	if ( ! Positive(Case) && Case[a] != Case[b] )
	{
	    *TSP = NewTS[NewTot-1];
	    NewTot--;
	    NewTS[NewTot] = Nil;
	}
	else
	{
	    TSP++;
	}
    }

    return true;
}



    ShiftVarsDown(s)
/*  -------------  */
    int s;
{
    Tuple *TSP, Case;
    Var V;

    NewMaxVar--;

    for ( TSP = NewTS ; Case = *TSP++ ; )
    {
	ForEach(V, s, NewMaxVar)
	{
	    Case[V] = Case[V+1];
	}
    }

    ForEach(V, s, NewMaxVar)
    {
	Variable[V]->Type = Variable[V+1]->Type;
        Variable[V]->TypeRef = Variable[V+1]->TypeRef;
	Variable[V]->DetDeps = Variable[V+1]->DetDeps;

	Variable[V]->DetLits = (int*)Resize(Variable[V]->DetLits,
				 10*(Variable[V]->DetDeps/10+1)*sizeof(int));
	memcpy(Variable[V]->DetLits,Variable[V+1]->DetLits,
                                           Variable[V]->DetDeps*sizeof(int));
	Variable[V]->NonDetOccurs = Variable[V+1]->NonDetOccurs;
    }
}

/*****************************************************************************/
/*                                                                           */
/*  NewVariableDependencies(L) - Set up the info for the new variables to    */
/*                               record their dependency upon this literal   */
/*                               and the determinate literals which          */
/*                               introduced the other variables in this      */
/*                               clause, and the dependencies of the other   */
/*                               variables in those clauses                  */
/*                                                                           */
/*****************************************************************************/

    NewVariableDependencies(L)
/*  -----------------------   */

Literal L;

{
    int i, j, k, DetDepsTmp=0, *DetLitsTmp=Nil, t, V;
    Boolean NotYetThere;
    int OldDetDepsTmp, *OldDetLitsTmp, u;

    ForEach(i,1,L->Rel->Arity)
    {
        V = L->Args[i];
	if(V<=OldMaxVar &&Variable[V]->DetDeps && !(Variable[V]->NonDetOccurs))
	/* This variable was introduced by an earlier Determinate
	   Literal and has not yet been used by a literal put in the
	   clause on the basis of gain */
	{
	    /* Add any new determinate literal dependencies -
	       done by repeated merging */

	    OldDetLitsTmp = DetLitsTmp;
	    DetLitsTmp = Nil;
	    OldDetDepsTmp = DetDepsTmp;
	    DetDepsTmp = 0;
	    j = k = 0;

	    while( (j<Variable[V]->DetDeps) && (k<OldDetDepsTmp) )
	    {
	        if(DetDepsTmp%10==0)
		    DetLitsTmp = (int*) Resize(DetLitsTmp, 
					       (DetDepsTmp + 10)*sizeof(int));

		t = Variable[V]->DetLits[j];
		u = OldDetLitsTmp[k];

		if(t<u)
		{
		    DetLitsTmp[DetDepsTmp++] = t;
		    j++;
		}
		else if(t==u)
		{
		    DetLitsTmp[DetDepsTmp++] = t;
		    j++;
		    k++;
		}
		else /* t > u */
		{
		    DetLitsTmp[DetDepsTmp++] = u;
		    k++;
		}
	    }

	    for( ; j<Variable[V]->DetDeps ; j++ )
	    {
                if(DetDepsTmp%10==0)
                    DetLitsTmp = (int*) Resize(DetLitsTmp,
                                               (DetDepsTmp + 10)*sizeof(int));
		DetLitsTmp[DetDepsTmp++] = Variable[V]->DetLits[j];
	    }

	    for( ; k<OldDetDepsTmp ; k++ )
	    {
                if(DetDepsTmp%10==0)
                    DetLitsTmp = (int*) Resize(DetLitsTmp,
                                               (DetDepsTmp + 10)*sizeof(int));
                DetLitsTmp[DetDepsTmp++] = OldDetLitsTmp[k];
	    }
	    if(OldDetLitsTmp) free(OldDetLitsTmp);
	}
    }

    if(DetDepsTmp%10==0)
        DetLitsTmp = (int*) Resize(DetLitsTmp, (DetDepsTmp + 10)*sizeof(int));

    DetLitsTmp[DetDepsTmp++] = NLit - 1 ;

    ForEach(i,1,L->Rel->Arity)
    {
	V = L->Args[i];
	if(V>OldMaxVar) 
	/* New variable introduced this round of Determinate Literals */
	{
            if(V>MaxVar) /* Introduced by this Literal */
	    {
                Variable[V]->DetDeps = DetDepsTmp;
		Variable[V]->NonDetOccurs = 0; 
		if(Variable[V]->DetLits) free(Variable[V]->DetLits);
		Variable[V]->DetLits = (int*)pmalloc(
					10*(DetDepsTmp/10+1)*sizeof(int));
		memcpy(Variable[V]->DetLits,DetLitsTmp,DetDepsTmp*sizeof(int));
	    }
	    else
	    {
                if(Variable[V]->DetDeps%10==0)
		    Variable[V]->DetLits = (int*) Resize(Variable[V]->DetLits,
                                   (Variable[V]->DetDeps + 10)*sizeof(int));
		Variable[V]->DetLits[Variable[V]->DetDeps++] = NLit - 1;
	    }
	}
    }
    if(DetLitsTmp) free(DetLitsTmp); 
}
