#include <ctype.h>
#include <math.h>
#include <stdio.h>

#define  MAXARITY	104	/* Maximum number of variables */

#define  PATIENCE	  3
#define  FINISH	   10000000	/* a large constant used as a terminator */

#define  MISSING_DISC     1     /* The missing value "?" is the first discrete
				   constant */

#define  MISSING_FP 262145.0    /* An arbitrary number used as the floating
				   point equivalent of MISSING_DISC - if
				   it clashes with a genuine data value, just
				   change this */

#define ExtraUnboundVars 1

#define Resize(P,N) 	( ((int) P) ? prealloc(P,N) : pmalloc(N) )

#define ungetchar(A)	ungetc(A, stdin)

typedef	char	Var,
		*Vars,
		Boolean,
		Ordering;	/* Valid instances are <,=,>,# */



				/*  A tuple is stored as an array of integers.
				    T[0] = tuple number (plus tuples), 
                                           0 otherwise.
				    T[i] = constant number, or floating point
					   value

				    NB: If continuous (fp) values are used,
				        the size of Const etc and ConstFP etc
					must be the same - change the following
					declarations to achieve this if
					required (eg int -> long) */

typedef  int	Const,
		*Tuple,
		**Tuples;

typedef  float	ConstFP,
		*TupleFP,
		**TuplesFP;

typedef  int	***Index;	/*  Relations are indexed by a 3D array.
				    I[i][j][k] = index of kth tuple 
                                    with T[j] = i
				    Last one is followed by FINISH  */



typedef  struct _rel_rec	*Relation;

typedef	 struct _type_rec	*TypeInfo;

typedef  struct _lit_rec	*Literal,
				**Clause;      /* clause is array of literals*/

typedef	 struct _poss_lit_rec	*PossibleLiteral;

typedef  struct _backup_rec	*Alternative;

typedef  struct _var_rec        *VarInfo;

typedef  struct _const_rec      *TCInfo;

typedef  struct _lit_rec
	{	Boolean		Sign;		/* false = negated, 2 = Det */
		Relation	Rel;
		Vars		Args;
		float		Bits;
		Ordering	*RefOrderedArg;
		Ordering	*OrderedArg;	/* recursive literals only */
		int		OrderedArgs;
		Boolean		FloatingDet;    /* True if determinate literal
        which introduced new variable not yet used by a literal put in the
	clause on the basis of gain */
	};

typedef  struct _rel_rec
	{	char		*Name;
		int		Arity,
				*Type,
				NKeys,
				*Key;
		Tuples		Pos,
				Neg,
				Opt;
		Index		PosIndex,
				OptIndex,
				NegIndex;
		Clause		*Def;	   /* Definition is array of clauses */
                Boolean         BinSym;         /* True if relation is
                                                    Binary and Symmetric */
                TypeInfo        *TypeRef; /* Array of pointers to types*/
		Boolean		ConstantCmp; /* 1 if relation is comparison
                                                 against a theory constant
						2 if threshold */
		ConstFP		TheConstant; /* Threshold if applicable */
		Boolean		**PosOrder,  /* Argument order info for R() */
				**NegOrder;  /*    "       "    "    " ~R() */
		Boolean		PossibleTarget;
	};

typedef	 struct _type_rec
	{	char		*Name;
		Boolean		Continuous;
		int		NValues;
		Const		*Value;
		int		*CollSeq;
		Boolean		FixedPolarity;
		Boolean		Ordered;
	};

typedef  struct _poss_lit_rec
	{
		float		Gain;
		Relation	Rel;
		Boolean		Sign;
		Vars		Args;
		float		Bits;
		int		NewSize,
				TotCov,
				PosCov;
	};
	
typedef  struct _backup_rec
	{
		float		Value;
		Clause		UpToHere;
	};

typedef  struct _var_rec
        {
                char            *Name;
                Const           Type,
                                Depth;
		TypeInfo        TypeRef;

		int		OriginalVar; /* First equivalent variable,
                                                must be zero if nonesuch */

                int             DetDeps, /* The number of determinate 
                                    literals in which this variable occurred
				    prior to occurring in a literal put in the
                                    clause on the basis of gain */
                                *DetLits,  /* The positions in the clause of 
                                    those determinate literals and any prior
				    floating determinate literals upon which 
				    the variables depend */
                                NonDetOccurs; /* The number of literals
                                    chosen on the basis of gain in which the
                                    variable occurs */
		Boolean		Continuous; /* Is variable continuous, if so
					       following exist */
		Tuples		TupleOrder;  /* Tuples ordered by value */
		int		Tot,	     /* Number of above */
				Pos,	     /* Number of above positive */
				PossValues;  /* Number of different values */
        }; 

typedef  struct _const_rec
        {
                char            *Name;        /* The constant's name */
                int             Type;         /* The constant's type */
        };

#define	 VERBOSE(x)		if(Verbosity>=x)
#define  SAMEVAR		Reln[0]
#define  CONTGT			Reln[1]

#define  Log2(x)		(log((float) x)/0.693147)
#define  LogComb(n,r)		(LogFact[n] - LogFact[r] - LogFact[(n)-(r)])
#define  Except(n,e)		((n) ? (1.1*(Log2(n) + LogComb(n, e))) : 0.0)
#define	 CostOfLit(NR,NA,NL) 	(1 + Log2(NR) + Log2(NA) - Log2(NL+1))

#define OrderCheck(T,N,X,Y) 	(T[N*(X-1)+(Y-1)]) /* For PO Checks */

#define OrderBetween(X,Y)((PartialOrder[X][Y]=='<')||(PartialOrder[X][Y]=='>'))
/* True if rhs variable X is ordered wrt lhs variable Y */

#define  Nil			0               /*null pointer*/
#define  false			0 
#define  true			1 
#define  Max(a,b)               ( (a)>(b) ? a : b ) 
#define  Min(a,b)               ( (a)<(b) ? a : b ) 
#define  Abs(x)			((x) > 0 ? x : -(x))
#define  Round(x)		((int) (x+0.5))

#define  ForEach(Var,First,Last) for(Var=First;Var<=Last;++Var) 

#define  Mask			 077777777
#define  PosMark		0100000000
#define  Positive(T)		((T)[0]&PosMark)

#define  TrueBit		02
#define  FalseBit		01
#define  SetBit(A,B)		Bits[A] |= B
#define	 TestBit(A,B)		(Bits[A] & B)
#define  ClearBits		memset(Bits,0,InitialTot)

#define  BestLitGain		(NPossible ? Possible[1]->Gain : 0.0)

#define  Plural(n)		((n) > 1 ? "s" : "")
#define  newline		putchar('\n')
#define	 ReadToEOLN		while ( getchar() != '\n' )

Boolean
	CheckRHS(),
	CommonValue(),
	IllegalKey(),
	Interpret(),
	Join(),
	JunkLiteral(),
	PossibleGain(),
	ProposeDeterminateLiteral(),
	Recover(),
	Unifiable(),
	CheckForOrder(),
	**CreateOrderArray(),
	ElementOrderCheck(),
	CanExtend(),
	CheckNext(),
	StillConsistent(),
	RecursiveCallOK(),
	PossibleOrder(),
	MissingValue();

Const
	FindConstant();

Literal
	FindLiteral(),
	MakeLiteral(),
	SelectLiteral();

Clause
	FindClause();

Tuple
	ReadTuple(),
	*ReadTuples(),
	NextConstTuple(),
	Extend(),
	RandomTuple();

Index
	MakeIndex();

Relation
	ReadRelation(),
	ThresholdRelation();
float
	ComputeGain(),
	Info(),
	Worth();

int
	FindType(),
	Number(),
	NumberArgLists(),
        SuperfluousEquality(),
        HackLiterals();

char
	ReadName(),
	*pcalloc(),
	*prealloc(),
        *pmalloc(),
	*CopyString();

/*void
	CheckCover(),
	CheckRelation(),
	CheckSameVar(),
	CheckSize(),
	ClearTables(),
	ConstructOptionalTuples(),
	Discard(),
	ExtractPartialOrders(),
	FindDefinition(),
	FindPartialOrders(),
	FindRelationOrder(),
	GreedyArgs(),
	InitialiseTrainingSet(),
	InitialiseValues(),
	InspectCase(),
	NewTrainingSet(),
	PrintClause(),
	PrintDefinition(),
	PrintLiteral(),
	PrintTuple(),
	PrintTuples(),
	ProposeLiteral(),
	PruneClause(),
	RecordPartialOrders(),
	RecoverTrainingSet(),
	Remember(),
	RenameVariables(),
	SiftClauses(),
	TryArgs(),
	TryArgs(),
	main(); */

char	*malloc(), *realloc(), *calloc(), *memcpy(), *memset();
void	free();
