#include  "defns.i"
#include  "extern.i"

extern Boolean CheckOrders;	/* for interpret */



	/*  See whether literals can be dropped from a clause  */

    PruneClause(C, Lits)
/*  -----------  */
    Clause C;
    int Lits;
{
    Boolean JunkLiteral();
    int i, Errs;

    Errs = OrigTotCov - OrigPosCov;

    VERBOSE(1)
	printf("\n\tAttempting to prune clause %d (%d initial errors)\n", NCl,
                                                                        Errs);

    /*  Allocate stuff for checking partial order restrictions  */

    ForEach(i, 0, Lits-1)
    {
	if ( C[i]->Rel == Target )
	{
	    C[i]->OrderedArg = (Ordering *) pmalloc(Target->Arity+1);
	}
    }

    CheckOrders = true;

    if ( JunkLiteral(C, Lits, Errs) )
    {
	RenameVariables(C, Target->Arity);

	VERBOSE(1)
	{
	    printf("\tRevised clause: ");
	    PrintClause(Target, C);
	    newline;
	}

	RecoverTrainingSet(C);
	CheckOriginalCaseCover();

    }

    CheckOrders = false;
}



	/*  Omit the first unnecessary literal  */

	/*  This version prunes from the end of the clause; if a literal
	    can't be dropped when it is examined, it will always be
	    needed, since dropping earlier literals can only increase
	    the number of minus tuples getting through to this literal  */


Boolean JunkLiteral(C, Lits, ErrsNow)
/*      -----------  */
    Clause C;
    int Lits, ErrsNow;
{
    int i, j, k, l, Errs, Less;
    Boolean Needed = true, Pruned = false, RecursiveLits,
	CheckRHS(), EssentialBinding();
    Tuple *TSP;
    Literal *Try;

    /*  First eliminate any equality relations except those between the
	variables of the target relation - this is done prior to the main
	literal checking loop to save computation associated with the
	superfluous equality relations */

    Less = SuperfluousEquality(C);
    Lits -= Less;
    Pruned = Less;

    /*  Then try eliminating all determinate literals not required to
        introduce variables for later non-determinate literals */

    Less = HackLiterals(C,Lits,ErrsNow);
    Lits -= Less;
    Pruned += Less;

    /*  Check for the last literal, omitting which would not increase
	the number of errors.  */

    for ( i = Lits-1 ; i >= 0 ; i-- )
    {
	/*  Can't omit a literal that is needed to bind a variable appearing in
	    a later negated literal  */

	if ( C[i]->Sign && EssentialBinding(i, C, Lits) ) continue;

	Needed = RecursiveLits = false;
	Errs = 0;

	k = 0;
        Try = (Literal *) pmalloc(10*sizeof(Literal));
	ForEach(j, 0, Lits-1)
	{
	    if ( j != i )
	    {
		Try[k++] = C[j];
                if(k%10==0) 
		{
                    Try = (Literal *)prealloc(Try,(k+10)*sizeof(Literal));
		}
		/*  Check for recursive literals and clear part order stuff  */

		if ( C[j]->Rel == Target )
		{
		    RecursiveLits = true;
		    C[j]->OrderedArgs = 0;
		    ForEach(l,1,Target->Arity)
		    {
		        C[j]->OrderedArg[l] = C[j]->RefOrderedArg[l];
			if( (C[j]->OrderedArg[l]=='<')
			  ||(C[j]->OrderedArg[l]=='>'))
			    C[j]->OrderedArgs++;
		    }
		}
	    }
	}
	Try[k] = Nil;

	for ( TSP = CopyTrainingSet ; *TSP && ! Needed ; TSP++ )
	{
	    if ( ! Positive(*TSP) )  /* a minus tuple */
	    {
		InitialiseValues(*TSP, Target->Arity);
		if ( CheckRHS(Try) )
		{
		    if ( Needed = ++Errs > ErrsNow )
		    {
			VERBOSE(2)
			{
			    printf("\t\t");
			    PrintLiteral(C[i]->Rel, C[i]->Sign, C[i]->Args);
			    printf(" needed for ");
			    PrintTuple(*TSP, Target->Arity);
			    newline;
			}
		    }
		}

		if ( ! RecursiveLits ) continue;

		ForEach(j, i, Lits-2)
		{
		    if ( Try[j]->Rel == Target && ! Try[j]->OrderedArgs )
		    {
			Needed = true;

			VERBOSE(2)
			{
			    printf("\t\t");
			    PrintLiteral(C[i]->Rel, C[i]->Sign, C[i]->Args);
			    printf(" needed for partial order on ");
			    PrintLiteral(Try[j]->Rel, Try[j]->Sign, 
					 Try[j]->Args);
			    newline;
			}
		    }
		}
	    }
	}

	if ( !Needed )
	{
	    VERBOSE(1)
	    {
		printf("\t\t");
		PrintLiteral(C[i]->Rel, C[i]->Sign, C[i]->Args);
		printf(" removed\n");
	    }

	    Lits--;
	    ForEach(j, i, Lits)
	    {
		C[j] = C[j+1];
	    }

	    Pruned = true;
	}
    }

    free(Try);

    return Pruned;
}



	/*  Can't omit a literal that is needed to bind a variable appearing in
	    a later negated literal, or whose omission would leave a later
	    literal containing all new variables  */

Boolean EssentialBinding(n, C, Lits)
/*      ----------------  */
    Clause C;
    int n, Lits;
{
    int i, j, jj, TimesBound[MAXARITY+1], LastBound[MAXARITY+1], V;
    Boolean FoundBound, Duplicate;

    memset(TimesBound, 0, (MAXARITY+1) * sizeof(int));

    ForEach(i, 0, Lits-1)
    {
	/*  Check that at least one variable is bound  */

	if ( i > n )
	{
	    FoundBound = false;
	    for ( j = 1 ; ! FoundBound && j <= C[i]->Rel->Arity ; j++ )
	    {
		V = C[i]->Args[j];
		FoundBound = V <= Target->Arity ||
			     TimesBound[V] &&
			     ( TimesBound[V] > 1 || LastBound[V] != n );
	    }

	    if ( ! FoundBound )
	    {
		VERBOSE(2)
		{
		    printf("\t\t");
		    PrintLiteral(C[n]->Rel, C[n]->Sign, C[n]->Args);
		    printf(" needed for binding ");
		    PrintLiteral(C[i]->Rel, C[i]->Sign, C[i]->Args);
		    newline;
		}

		return true;
	    }
	}

	if ( C[i]->Sign )
	{
	    ForEach(j, 1, C[i]->Rel->Arity)
	    {
		V = C[i]->Args[j];
		Duplicate = false;
		for ( jj = 1 ; ! Duplicate && jj < j ; jj++ )
		{
		    Duplicate = C[i]->Args[jj] == V;
		}
		if ( ! Duplicate )
		{
		    TimesBound[V]++;
		    LastBound[V] = i;
		}
	    }
	}
	else
	if ( i > n )
	{
	    ForEach(j, 1, C[i]->Rel->Arity)
	    {
		if ( TimesBound[V = C[i]->Args[j]] == 1 && V > Target->Arity &&
		     LastBound[V] == n )
		{
		    VERBOSE(2)
		    {
			printf("\t\t");
			PrintLiteral(C[n]->Rel, C[n]->Sign, C[n]->Args);
			printf(" needed for binding on ");
			PrintLiteral(C[i]->Rel, C[i]->Sign, C[i]->Args);
			newline;
		    }
		    return true;
		}
	    }
	}
    }

    return false;
}



    RenameVariables(C, N)
/*  ---------------  */
    Clause C;
    int N;
{
    char i, Map[MAXARITY+1], Next, SaveNext, Lit;
    int V;
    Literal L;
    Relation R;

    memset(Map, 0, MAXARITY+1);
    Next = N + 1;

    for ( Lit = 0 ; (L = C[Lit]) ; Lit++ )
    {
	SaveNext = Next;

	R = L->Rel;
	ForEach(i, 1, R->Arity)
	{
	    V = L->Args[i];

	    if ( V > N )
	    {
		if ( ! Map[V] ) Map[V] = Next++;

		L->Args[i] = Map[V];
	    }
	}

	/*  Restore next variable after negative literal  */

	if ( ! L->Sign )
	{
	    Next = SaveNext;

	    ForEach(V, 1, MAXARITY)
	    if ( Map[V] >= Next ) Map[V] = 0;
	}
    }
}

/*****************************************************************************/
/*                                                                           */
/*  OrderClauses() - order clauses so that any non-recursive clause precedes */
/*                   any recursive one.                                      */
/*                                                                           */
/*****************************************************************************/

    OrderClauses()
/*  ------------  */
{
    Clause *CP, C, *CPtmp, Ctmp, Cswap;
    Literal L;

    Clause *DefTmp;
    int i;
    Boolean ReorderRequired = false;

    DefTmp = (Clause*)pmalloc(100*(NCl/100+1)*sizeof(Clause));
    i = 0;
    CP = Target->Def;
    while ( C = *CP++ )
    {
        while( (L = *C++) && (L->Rel!=Target) );
        if (!L)  /* This clause has no recursive literal */
	{
	    DefTmp[i++] = *(CP-1);
	    if(!ReorderRequired&&(i!=(int)(CP-Target->Def)))
	         ReorderRequired++;
	}
    }

    if(!ReorderRequired)
    {
        free(DefTmp);
	return;
    }
    else /* Put recursive literals after non-recursive ones */
    {
        VERBOSE(1) printf("\nClause reordering\n\n");
        CP = Target->Def;
	while ( C = *CP++ )
	{
	    while( (L = *C++) && (L->Rel!=Target) );
	    if (L)  /* This clause has a recursive literal */
	    {
	        DefTmp[i++] = *(CP-1);
	    }
	}
    }
    DefTmp[NCl] = Nil;
    
    free(Target->Def);
    Target->Def = DefTmp;
    return;
}



	/*  See whether some clauses can be dispensed with  */

    SiftClauses()
/*  -----------  */
{
    int i, Covers, Last, Remaining, Retain = 0;
    Tuple *TSP;
    Boolean *Need, *Delete;

    Delete = (Boolean *) pmalloc(NCl*sizeof(Boolean));
    Need = (Boolean *) pmalloc(NCl*sizeof(Boolean));

    memset(Delete, false, NCl);
    memset(Need, false, NCl);
    Remaining = NCl;

    while ( true )
    {
	for ( TSP = InitialTrainingSet ; *TSP && Retain < Remaining ; TSP++)
	{
	    if ( ! Positive(*TSP) ) continue;

	    Covers = 0;
	    for ( i = 0 ; i < NCl && Covers <= 1 ; i++ )
	    {
		if ( Delete[i] ) continue;

		InitialiseValues(*TSP, Target->Arity);

		if ( CheckRHS(Target->Def[i]) )
		{
		    Covers++;
		    Last = i;
		}
	    }

	    if ( Covers == 1 && ! Need[Last] )
	    {
		VERBOSE(2)
		{
		    printf("Clause %d needed for ", Last);
		    PrintTuple(*TSP, Target->Arity);
		    newline;
		}

		Need[Last] = true;
		Retain++;
	    }
	}

	Last = -1;
	ForEach(i, 0, NCl-1)
	{
	    if ( ! Need[i] && ! Delete[i] ) Last = i;
	}

	if ( Last >= 0 )
	{
	    Delete[Last] = true;
	    Remaining--;
	}
	else
	{
	    break;
	}
    }

    if ( Retain < NCl )
    {
	VERBOSE(1) printf("\nDelete clause%s\n", Plural(NCl - Retain));

	Retain = 0;

	ForEach(i, 0, NCl-1)
	{
	    if ( Delete[i] )
	    {
		VERBOSE(1)
		{
		    printf("\t");
		    PrintClause(Target, Target->Def[i]);
		}
	    }
	    else
	    {
		Target->Def[Retain++] = Target->Def[i];
	    }
	}
	Target->Def[Retain] = Nil;
    }
}

/*****************************************************************************/
/*                                                                           */
/*      SuperfluousEquality(C) - eliminate any equality relations except ones*/
/*                               between target relation's variables.        */
/*                                                                           */
/*****************************************************************************/

int     SuperfluousEquality(C)
/*      -------------------   */

Clause C;

{
    Literal L;
    VarInfo V;
    int i, j, less = 0;


    /* Substitute equal variables using info built up with the clause / scrap 
       equalities where second variable is not in target relation */

    i = 0 ;
    while(L=C[i++])
    {
	if ( L->Sign && (L->Rel == SAMEVAR) && (L->Args[2] > Target->Arity) )
	/* Delete literal */
	{
            less++;
	    j = --i;
	    while (C[j++]) C[j-1]=C[j];
	}
        else
	{
            ForEach(j,1,(L->Rel)->Arity)
	    {
                V = Variable[L->Args[j]];
		if( V->OriginalVar && ( L->Args[j] > Target->Arity ) ) 
                    L->Args[j] = V->OriginalVar;
	    }
	}
    }

    return less;
}
        
/*****************************************************************************/
/*                                                                           */
/*  HackLiterals(C, Lits, Errsnow) - this function tries to cut out the      */
/*                                   determinate literals not required to    */
/*                                   introduce variables used by literals    */
/*                                   introduced on the basis of gain. The    */
/*                                   resulting clause is tested for validity */
/*                                   so the pruning may be rejected.         */
/*                                                                           */
/*****************************************************************************/

int     HackLiterals(C, Lits, ErrsNow)
/*      ------------  */

    Clause C;
    int Lits, ErrsNow;

{
    int i, j, l, Errs=0, NewLits;
    Boolean Needed = false, RecursiveLits=false, CheckRHS();
    Tuple *TSP;
    Literal *Try;

    NewLits = 0;
    Try = (Literal *) pmalloc(10*sizeof(Literal));

    ForEach(i, 0, Lits-1)
    {
	if ( ! C[i]->FloatingDet )
        /* This is not a floating determinate literal - put in trial clause */
	{
	    Try[NewLits++] = C[i];
            if(NewLits%10==0) 
	    {
                Try = (Literal *)prealloc(Try,(NewLits+10)*sizeof(Literal));
	    }

	    /*  Check for recursive literals and clear part order stuff  */

	    if ( C[i]->Rel == Target )
	    {
		RecursiveLits = true;
		C[i]->OrderedArgs = 0;
		ForEach(l,1,Target->Arity)
		{
		    C[i]->OrderedArg[l] = C[i]->RefOrderedArg[l];
		    if((C[i]->OrderedArg[l]=='<')||(C[i]->OrderedArg[l]=='>'))
		        C[i]->OrderedArgs++;
		}
	    }
	}
    }
    Try[NewLits] = Nil;

    if(NewLits==Lits)
    {
        VERBOSE(2) printf("\n\tNo determinate literals quick pruned \n\n");
	free(Try);
	return 0;
    }

    if(!NewLits)
    {
        VERBOSE(2) printf("\n\tWould have quick pruned all literals \n\n");
	free(Try);
	return 0;
    }

    VERBOSE(2)
    {
        printf("\n\tClause quick pruned to: ");
	PrintClause(Target, Try);
	printf("\n");
    }

    for ( TSP = CopyTrainingSet ; *TSP && ! Needed ; TSP++ )
    {
	if ( ! Positive(*TSP) )  /* a minus tuple */
	{
	    InitialiseValues(*TSP, Target->Arity);
	    if ( CheckRHS(Try) )
	    {
	        if (++Errs > ErrsNow) Needed = true;
	    }
	    if ( ! RecursiveLits ) continue;

	    ForEach(j, 0, NewLits-1)
	    {
		if( (Try[j]->Rel == Target) && ! Try[j]->OrderedArgs )
		    Needed = true;
	    }
	}
    }

    if(Needed)
    {
        VERBOSE(2) printf("\tBut hacked off literal required\n\n");
        free(Try);
	return 0;
    }
    else
    {
	for(i = 0 ; i < NewLits ; i++) C[i] = Try[i];
	C[NewLits]=Nil;
	free(Try);
	return Lits-NewLits;
    }

}
