#include  "defns.i"
#include  "extern.i"

extern int FoundSize;


    main(Argc, Argv)
/*  ----  */
    int Argc;
    char *Argv[];
{
    int o;
    extern char *optarg;
    extern int optind;

    Boolean FirstTime = true;
    int i, a, MaxInitTrainSet = 0, InitTrainSet, Cases, Errors, *Case, TI;
    Relation TestRel, ReadRelation();
    Index MakeIndex();
    char PlusOrMinus, Line[200];
    long clock();

    /*  Process options  */

    printf("FOIL v4.1   [May 1993]\n---------\n");

    while ( (o = getopt(Argc, Argv, "a:f:l:m:t:v:d:g:rznp:")) != EOF )
    {
	if ( FirstTime )
	{
	    printf("\n    Options:\n");
	    FirstTime = false;
	}

	switch (o)
	{
	    case 'a':	MINACCURACY = atof(optarg);
			printf("\tminimum clause accuracy %g%%\n",MINACCURACY);
			MINACCURACY /= 100;
			break;
	    case 'f':	MINALTFRAC = atof(optarg);
			printf("\tbacked-up literals have %g%% of best gain\n",
                                                                  MINALTFRAC);
			MINALTFRAC /= 100;
			break;
	    case 'l':	MAXPOSSLIT = atoi(optarg);
			printf("\tmaximum %d backups from one literal\n", 
                                                                  MAXPOSSLIT);
			break;
	    case 'm':   MAXTUPLES = atoi(optarg);
                        printf("\tmaximum %d tuples \n", MAXTUPLES);
	                break;
	    case 't':	MAXALTS = atoi(optarg);
			printf("\tmaximum %d total backups\n", MAXALTS);
			break;
	    case 'v':	Verbosity = atoi(optarg);
			printf("\tverbosity level %d\n", Verbosity);
			break;
	    case 'd':	MAXVARDEPTH = atoi(optarg);
			printf("\tmaximum variable depth %d\n", MAXVARDEPTH);
			break;
	    case 'g':	i = atoi(optarg);
			printf("\tuse determinate literals when gain <= ");
	                printf("%d%% possible\n", i);
			DETERMINATE = i / 100.0;
			break;
	    case 'r':   RECURSIVEINTERP = true;
                        printf("\trecursive checking of test data\n");
                        break;
            case 'z':   FASTFORWARD = true;
                        printf("\tinitialise clauses with determinate ");
                        printf("literals known from prior clause\n");
                        break;
	    case 'n':	NEGLITERALS = false;
			printf("\tno negative literals\n");
			break;
	    case 'p':	SAMPLE = atof(optarg);
			printf("\tsample %g%% of negative tuples\n", SAMPLE);
			SAMPLE /= 100;
			break;
	    case '?':	printf("unrecognised option\n");
			exit(1);
	}
    }

    clock();
    while ( clock() < 1 ) ;

    InitialiseVars();

    Found = (Tuples) pmalloc((FoundSize+1) * sizeof(Tuple));

    ToBeTried = (Alternative *) pmalloc((MAXALTS+1) * sizeof(Alternative));
    ForEach(i, 1, MAXALTS)
    {
	ToBeTried[i] = (Alternative) pmalloc(sizeof(struct _backup_rec));
	ToBeTried[i]->UpToHere = Nil;
    }

    Possible = (PossibleLiteral *) pmalloc((MAXPOSSLIT+1) 
					   * sizeof(PossibleLiteral));
    ForEach(i, 1, MAXPOSSLIT)
    {
	Possible[i] = (PossibleLiteral) pmalloc(sizeof(struct _poss_lit_rec));
	Possible[i]->Args = (Vars) pmalloc(MAXARITY+1);
    }

    /*  Nominal allocations  */

    ConstName = (char **) pmalloc(sizeof(char *));
    SortedConst= (Const *) pmalloc(sizeof(Const));
    ReadTypes();
    SetUpRelations();

    /*  Determine order to try relations  */

    FindRelationOrder();

    /*  Make indices */

    ForEach(i, 0, MaxRel)
    {
	Reln[i]->PosIndex = MakeIndex(Reln[i]->Pos, Reln[i]->Arity);

	if ( Reln[i]->Neg )
	{
	    InitTrainSet = Number(Reln[i]->Pos) + Number(Reln[i]->Neg);
	    Reln[i]->NegIndex = MakeIndex(Reln[i]->Neg, Reln[i]->Arity);
	}
	else
	{
	    InitTrainSet = 1;
	    ForEach(a, 1, Reln[i]->Arity)
	    {
		if ( (TI = Reln[i]->Type[a]) )
		{
		    InitTrainSet *= Type[TI]->NValues;
		}
	    }
	}

	if ( Reln[i]->PossibleTarget )
	{
	    MaxInitTrainSet = Max(InitTrainSet, MaxInitTrainSet);
	}

    }

    MaxInitTrainSet = Min(MAXTUPLES,MaxInitTrainSet);

    /*  Determine type compatibilities  */

    Compatible = (Boolean **) pmalloc((MaxType+1) * sizeof(Boolean *));
    ExtCompatible = (Boolean **) pmalloc((MaxType+1) * sizeof(Boolean *));
    ForEach(i, 1, MaxType)
    {
	Compatible[i] = (Boolean *) pmalloc(MaxType+1);
	ExtCompatible[i] = (Boolean *) pmalloc(MaxType+1);
    }

    CheckTypeCompatibility();
    Bits = malloc(1);

    LogFact = (float *) pmalloc((MaxInitTrainSet+2) * sizeof(float));
    LogFact[0] = LogFact[1] = 0;
    ForEach(i, 2, MaxInitTrainSet+1)
    {
	LogFact[i] = LogFact[i-1] + Log2(i);
    }

    /* Check for possible partial orders in the relation arguments */

    VERBOSE(2) printf("\nTime %.1f secs\n", clock() / 1.0E6);
    OrderTheConstants();
    VERBOSE(2) printf("\nTime %.1f secs\n", clock() / 1.0E6);

    /* Set up type order arrays */

    TypeOrderCl = (Boolean **) pmalloc((MaxType+1) * sizeof(Boolean *));
    TypeOrderDef = (Boolean **) pmalloc((MaxType+1) * sizeof(Boolean *));
    ForEach(i, 1, MaxType)
    {
	TypeOrderCl[i] = (Boolean *) pmalloc(2);
	TypeOrderDef[i] = (Boolean *) pmalloc(2);
    }

    /* Find Definitions */

    ForEach(i, 1, MaxRel)
    {
	if ( Reln[i]->PossibleTarget )
	{
	    FindDefinition(Reln[i]);
	}
    }

    printf("\nTime %.1f secs\n", clock() / 1.0E6);

    /*  Test definitions  */

    MaxVar = MAXARITY;
    RecursChecking = RECURSIVEINTERP;

    while ( gets(Line) )
    {
	TestRel = Nil;
	for ( i = 0 ; i <= MaxRel && ! TestRel ; i++ )
	{
	    if ( ! strcmp(Reln[i]->Name, Line) ) TestRel = Reln[i];
	}

	if ( ! TestRel )
	{
	    printf("\nUnknown relation %s\n", Line);
	    exit();
	}
	else
	{
	    printf("\nTest relation %s\n", Line);
	}

	Cases = Errors = 0;

	while ( Case = ReadTuple(TestRel) )
	{
	    while ( (PlusOrMinus = getchar()) == ' ' || PlusOrMinus == '\t' )
		;
	    ReadToEOLN;

	    Cases++;

	    if ( Interpret(TestRel, Case) != ( PlusOrMinus == '+' ) )
	    {
		VERBOSE(1)
		{
		    printf("\terror on ");
		    PrintTuple(Case, TestRel->Arity);
		    printf(" (should be %c)\n", PlusOrMinus);
		}
		Errors++;
	    }
	}

	printf("Summary: %d errors in %d trials\n", Errors, Cases);
    }
    return 0;
}



    FindRelationOrder()
/*  -----------------  */
{
    Boolean *Waiting;
    int Best, Next = 0, i;

    Waiting = (Boolean *) pmalloc((MaxRel+1)*sizeof(Boolean));
    RelnOrder = (Relation *) pmalloc((MaxRel+1)*sizeof(Relation));

    ForEach(i, 0, MaxRel)
    {
	Waiting[i] = true;
    }

    ForEach(Next, 0, MaxRel)
    {
	Best = -1;

	ForEach(i, 0, MaxRel)
	{
	    if ( Waiting[i] &&
		 ( Best < 0 ||
		   Reln[i]->Arity < Reln[Best]->Arity ||
		   Reln[i]->Arity == Reln[Best]->Arity
		   && Best > 0
		   && Number(Reln[i]->Pos) > Number(Reln[Best]->Pos) ) )
	    {
		Best = i;
	    }
	}

	RelnOrder[Next] = Reln[Best];
	Waiting[Best] = false;
    }
    free(Waiting);
}
	/*  Check whether different types are compatible, i.e.
	    share at least one common value  */

    CheckTypeCompatibility()
/*  ----------------------  */
{
    int T1, T2;

    VERBOSE(2) newline;

    ForEach(T1, 1, MaxType)
    {
	Compatible[T1][T1] = true;

	ForEach(T2, T1+1, MaxType)
	{
	    Compatible[T1][T2] = Compatible[T2][T1] =
		CommonValue(Type[T1]->NValues, Type[T1]->Value,
		            Type[T2]->NValues, Type[T2]->Value);

	    VERBOSE(2)
	    {
		printf("Types %s and %s %s compatible\n",
			Type[T1]->Name, Type[T2]->Name,
			Compatible[T1][T2] ? "are" : "are not");
	    }
	}
    }
}


Boolean CommonValue(N1, V1, N2, V2)
/*      -----------  */
    Const N1, *V1, N2, *V2;
{
    int i,j;

    for(i = 0 ; i < N1 ; i++)
    {
        for(j = 0 ; j < N2 ; j++)
	{
	    if(V1[i]==V2[j]) 
	    {
		return true;
	    }
	}
    }
    return false;
}
