#include  "defns.i"
#include  "extern.i"


	/*  Construct the index for a set of tuples  */

Index MakeIndex(T, N)
/*    ---------  */
    Tuple *T;
    int N;
{
    Index IX;
    Tuple Case, *Scan;
    int **Next, Arg, Val, No = 0;

    /*  Allocate storage  */

    IX = (int ***) pmalloc((N+1) * sizeof(int **));
    Next = (int **) pmalloc((N+1) * sizeof(int *));

    ForEach(Arg, 1, N)
    {
	IX[Arg] = (int **) pmalloc((MaxConst+1) * sizeof(int *));
	Next[Arg] = (int *) pcalloc(MaxConst+1, sizeof(int));
    }

    for ( Scan = T ; Case = *Scan++ ; )
    {
	ForEach(Arg, 1, N)
	{
	    Next[Arg][Case[Arg]]++;
	}
    }

    ForEach(Arg, 1, N)
    {
	ForEach(Val, 1, MaxConst)
	{
	    IX[Arg][Val] = Next[Arg][Val] ? 
	              (int *) pmalloc((Next[Arg][Val]+1) * sizeof(int)) : Nil;
	    Next[Arg][Val] = 0;
	}
    }

    /*  Construct the index  */

    for ( Scan = T ; *Scan ; Scan++ )
    {
	ForEach(Arg, 1, N)
	{
	    Val = (*Scan)[Arg];
	    IX[Arg][Val][Next[Arg][Val]++] = No;
	}

	No++;
    }

    /*  Terminate index and free Next  */

    ForEach(Arg, 1, N)
    {
	ForEach(Val, 1, MaxConst)
	{
	    if ( IX[Arg][Val] )
	    {
		IX[Arg][Val][Next[Arg][Val]] = FINISH;
	    }
	}
	free(Next[Arg]);
    }
    free(Next);

    return IX;
}
