#include "defns.i"

	/*  Global variables  */

float
	SAMPLE = 1.0,			/* fraction of negative tuples 
					   to sample */
	MINACCURACY = 0.8,		/* minimum acceptable accuracy of 
					   a clause */
	MINALTFRAC  = 0.8,		/* fraction of best gain to qualify 
					   for backup */
	DETERMINATE = 0.80;  		/* use determinate literals */

int
	MAXPOSSLIT  =   5,              /* 1 + max backups from single 
					   literal position */
	MAXALTS     =  20,		/* max total backups */
	MAXVARDEPTH =   4,		/* max depth of var in literal */
        MAXTUPLES = 100000,             /* max number of tuples for literal */
	Verbosity = 1,			/* level of output */
	MaxConst = 0,			/* no. constants */
        MaxTC = 0,                      /* no. of theory constants */
	MaxType = 0,			/* no. types */
	MaxVar = 0,			/* no. variables in training set */
        NewMaxVar = 0,                  /* ditto for new training set */
        OldMaxVar = 0,                  /*  ...  prior to new literal(s) */
	MaxRel = 0,			/* highest relation no */
	Pos, CyclePos,			/* no. pos cases in training set */
        NewPos,                         /* ditto for new training set */
        OrigPosCov,                     /* no. original pos cases covered */
	Tot, InitialTot, CycleTot,	/* no. cases in training set */
        NewTot,                         /* ditto for new training set */
        OrigTotCov,                     /* no. original cases covered */
	NewSize,			/* size of next training set */
	NCl,				/* current clause number */
	NLit,				/* current literal number */
	NDeterminate,			/* no. determinate literals found */
	WeakLiterals,			/* no. no-gain/non-discrim literals */
        Tried,
        ADC,                            /* All Det Clause counter */
        PossibleRelns,                  /* no. relations with possible args */
        *PossibleArgLists,              /* the numbers of possible args */
        EqualityRelnArgs,               /* For coding TCs as part of = */
        NRecLitCl,                      /* Number of recursive literals */
        NRecLitDef,                     /* Ditto prior to current clause */
        CompactClCover,                 /* No. covered by compact clause */
        CompactClNLit;

Relation
        *Reln,		                /* relations */
        *RelnOrder,      		/* order to try relations */
	Target;				/* relation being induced */

Tuples
	TrainingSet = Nil,		/* tuples in current training set */
        NewTS,                          /* tuples in new training set */
	InitialTrainingSet = Nil,	/* copy at start of first clause */
	CopyTrainingSet;		/* copy at start of current clause */

float
	*LogFact,			/* LogFact[i] = log2(i!) */
	BaseInfo,
	InitialBaseInfo,
        OldBaseInfo,
	MaxPossibleGain,
	UsedSoFar,			/* bits in previous literals */
	AvailableBits;			/* bits available for this clause */

Clause
	NewClause,			/* clause being constructed */
        *AllDeterminateClause,          /* clause prior to first non-det lit
                                           - as series of subclauses */
        CompactClause;                  /* best shorter clause discovered
					   while developing current clause */

Boolean
	NEGLITERALS = true,
        RECURSIVEINTERP = false,        /* Test cases to be interpreted
                                           recursively ? */
        FASTFORWARD = false,            /* Clauses to be bootstrapped with
                                           determinate literals from
                                           preceding clause? */
        RecursChecking = false,         /* Recursive checking currently on ? */

	PartialOrder[MAXARITY+1][MAXARITY+1],  /* partial orders on variables*/
	AnyPartialOrder,
        PartialOrderOK = Nil,
        AllCovered,                             
	**Compatible,    /*Compatible[i][j] if types i, j have common value  */
        **ExtCompatible, /* Ext..[i][j] if recursively compatible */
        **DefinitionOrders, /* Constant orders per variable before clause */
        **ClauseOrders,     /* Constant orders per variable so far */
        *TypeOrdered,       /* True if constants of type have been ordered */
        **TypeOrderCl, /* Type Ordered? ([0]) If so, [1] true = reversed */
        **TypeOrderDef, /* Saved copy at start of clause of above */
        ArgOrderedCl[MAXARITY+1], /* Arg Ordered By Recursive Literal? */
        ArgOrderedDef[MAXARITY+1]; /* Saved copy of above */

Ordering
        **RecLitCl,             /* Argument order info for recursive lits */
        **RecLitDef;            /* ditto prior to current clause */

char
	Name[200],
	SectionDelim,
        ArgList[MAXARITY+1],
        *VariableName[MAXARITY+1] = {"_",
                         "A","B","C","D","E","F","G","H","I","J","K","L","M",
                         "N","O","P","Q","R","S","T","U","V","W","X","Y","Z",
            "VA","VB","VC","VD","VE","VF","VG","VH","VI","VJ","VK","VL","VM",
            "VN","VO","VP","VQ","VR","VS","VT","VU","VV","VW","VX","VY","VZ",
            "WA","WB","WC","WD","WE","WF","WG","WH","WI","WJ","WK","WL","WM",
            "WN","WO","WP","WQ","WR","WS","WT","WU","WV","WW","WX","WY","WZ",
            "XA","XB","XC","XD","XE","XF","XG","XH","XI","XJ","XK","XL","XM",
            "XN","XO","XP","XQ","XR","XS","XT","XU","XV","XW","XX","XY","XZ"},
        DefVars[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,
                     14,15,16,17,18,19,20,21,22,23,24,25,26,
                     27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,
                     53,54,55,56,57,58,59,60,61,62,63,64,65,
                     66,67,68,69,70,71,72,73,74,75,76,77,78,
                     79,80,81,82,83,84,85,86,87,88,89,90,91,
                     92,93,94,95,96,97,98,99,100,101,102,103,104},

	**ConstName = Nil,
        *Bits = Nil;


Const
	*SortedConst = Nil,
        Value[MAXARITY+1];


VarInfo *Variable;                      /* variable array */

TCInfo  *TheoryConst;                   /* Theory constant array */

TypeInfo
	*Type;

Tuples	Found;
int	NFound;

Alternative	*ToBeTried;
int		NToBeTried;

PossibleLiteral	*Possible;
int		NPossible;
