;;; -*- Mode: LISP; Syntax: Ansi-common-lisp; Package: CL-USER; Base: 10 -*-

(DECLAIM (OPTIMIZE (SPEED 2) (SAFETY 1) (DEBUG 0))) 

;; miller - Brad Miller (miller@cs.rochester.edu)
#+ccl (require "LISP-PACKAGE") ; for series

(defpackage series 
  (:use common-lisp)
  #+excl (:import-from cltl1 compiler-let special-form-p)
  #+ccl (:import-from lisp compiler-let special-form-p provide)
  (:shadow #:let #:let* #:multiple-value-bind #:funcall #:defun #:restart #:condition)
  (:export  ;74 total concepts in the interface
   ;;(2) readmacros (#M and #Z)

   ;;(5) declarations and types (note dual meaning of series)
    #:optimizable-series-function #:off-line-port ;series
    #:series-element-type #:propagate-alterability

    ;(10) special functions
    #:alter #:to-alter #:encapsulated #:terminate-producing
    #:next-in #:next-out #:generator #:gatherer #:result-of #:gathering

    ;(55) main line functions
    #:make-series #:series #:scan #:scan-multiple #:scan-range #:scan-sublists #:scan-fn
    #:scan-fn-inclusive #:scan-lists-of-lists #:scan-lists-of-lists-fringe #:scan-file
    #:scan-hash #:scan-alist #:scan-plist #:scan-symbols #:collect-fn #:collect
    #:collect-append #:collect-nconc #:collect-file #:collect-alist #:collect-plist
    #:collect-hash #:collect-length #:collect-sum #:collect-max #:collect-min
    #:collect-last #:collect-first #:collect-nth #:collect-and #:collect-or
    #:previous #:map-fn #:iterate #:mapping #:collecting-fn #:cotruncate
    #:latch #:until #:until-if #:positions #:choose #:choose-if
    #:spread #:expand #:mask #:subseries #:mingle #:catenate #:split #:split-if
    #:producing #:chunk 

    ;(5) variables
    #:*series-expression-cache*
    #:*last-series-loop*
    #:*last-series-error*
    #:*suppress-series-warnings*))

(defpackage "QUERY-P" (:use #+:lucid "LISP" #-:lucid #:common-lisp)
    (:shadow #:y-or-n-p #:yes-or-no-p) 
    (:export #:query #:y-or-n-p-wait #:yes-or-no-p-wait))

;;; For a History of recent changes, see the file cl-lib-news in this directory.
(defpackage cl-lib
  (:use common-lisp series query-p)
  #+symbolics (:import-from scl
	       #:read-delimited-string #:add-initialization #:initializations #:delete-initialization #:reset-initializations)
  #+symbolics (:shadow #:defresource #:allocate-resource #:deallocate-resource #:clear-resource #:map-resource)
  (:export #:list-without-nulls #:cartesian-product #:cross-product #:*cl-lib-version*
	   #:permutations #:powerset #:flatten #:circular-list
	   #:occurs #:firstn #:in-order-union #:seq-butlast #:seq-last #:dosequence
	   #:prefix? #:between #:ordinal-string #:parse-with-delimiter #:parse-with-delimiters #:string-search-car #:string-search-cdr
	   #:parallel-substitute #:parse-with-string-delimiter
	   #:parse-with-string-delimiter* #:split-string #:format-justified-string #:number-to-string #:null-string
	   #:force-string #:elapsed-time-in-seconds #:time-string
	   #:factorial #:round-to #:bit-length #:sum-of-powers-of-two-representation
	   #:difference-of-powers-of-two-representation
	   #:extract-keyword #:truncate-keywords
	   #:update-alist #:msetq #:mlet #:while #:while-not #:let*-non-null
	   #:cond-binding-predicate-to 
	   #:mapc-dotted-list #:mapcar-dotted-list #:mapcan-dotted-list #:maplist-dotted-list
	   #:some-dotted-list #:every-dotted-list
	   #:copy-hash-table
	   #:defclass-x #:defflag #:defflags #:let-maybe
	   #:eqmemb #:neq #:car-eq #:dremove #:displace #:tailpush 
	   #:explode #:implode #:crush
	   #:listify-string #:listify 
	   #:and-list #:or-list
	   #:lookup #:make-variable #:variablep
	   #:dofile #:copy-array
           
           #-excl #:if*
           #-excl #:*keyword-package*
	   #+excl #:raw-read-char
	   #+excl #:raw-peek-char
           #+excl #:raw-read-char-no-hang
	   #:make-plist 
	   #:make-keyword
	   #:internal-real-time-in-seconds #:read-char-wait 
           
           ;; reexport from query-p
           #:y-or-n-p-wait #:yes-or-no-p-wait #:query
           
	   #:flags #:add-initialization #:initializations #:delete-initialization #:reset-initializations
	   #:*cold-initialization-list* #:*warm-initialization-list* #:*once-initialization-list*
	   #:*gc-initialization-list* #:*before-cold-initialization-list* #:*after-gc-initialization-list*
	   #:*initialization-keywords*
	   #:reader #:compatiblep #:convert-re-to-dfa #:clear-dfa-cache #:read-delimited-string #:mapatoms
           #:reverse-alist #:fast-union #:fast-intersection
           #:true-list-p #:scheme-delay #:scheme-force #:scheme-stream #:ss-head #:ss-tail #:cons-scheme-stream #:make-scheme-stream 
           #:list-scheme-stream
           #:scheme-stream-p #:progfoo #:foo #:mv-progfoo #:mv-foo #:with-rhyme
           
           #:get-compiled-function-name #:fast-read-char #:fast-read-file-char
           
           ;; better-errors.lisp
           #:warn-or-error #:*general-warning-list* #:*warn-or-error-cleanup-initializations*
           #:check
	   #:parser-error

           ;; resources.lisp
	   #:defresource #:allocate-resource #:deallocate-resource #:clear-resource #:map-resource #:with-resource
           
           #+excl #:edit-system 

           #:macro-indent-rule
           #:alist #:comment
           #:xor #:eqv #:nand #:nor
           #:load-once #:clear-load-once
           
           ;; locatives.lisp
           #:locf #:location-contents #:locative-p #:locative
           
           ;; nregex.lisp
           #:regex #:regex-compile
           
           ;; triangular-matrices.lisp
           #:tarray #:tarray-p #:make-tarray #:make-upper-tarray #:make-lower-tarray
           #:taref #:tarray-element-type #:tarray-rank #:tarray-dimension #:tarray-dimensions  #:copy-tarray
           #:tarray-total-size #:tarray-in-bounds-p #:increment-tarray #:upper-tarray-p #:lower-tarray-p #:full-tarray-p
	   
           ;; prompt-and-read
           #+clim #:popup-read-form #+clim #:popup-error #:prompt-and-read #:prompt-for 
           #+clim #:convert-to-presentation-type #+clim #:*default-presentation-type*
           #+clim #:clim-prompt-for #+clim #:clim-prompt-for-with-default
           
           ;; string-io-streams
           #:string-io-stream #:string-io-stream-p #:make-string-io-stream
           ))

#+excl
(defpackage process
  (:import-from mp #:*current-process*)
  (:export #:with-lock #:make-lock-argument #:lock #:lock-idle-p #:interrupt #:block-process #:process-wait #:runnable-p 
           #:without-preemption #:without-interrupts #:process-name #:unlock
           #:block-and-poll-wait-function #:block-and-poll-with-timeout #:process-run-function #:process-abort
           #:make-lock #:make-process #:make-process-priority #:reset #:kill #:wakeup #:wakeup-without-test
           #:*default-process-priority* #:*current-process*))

#+excl
(excl:defsystem :cl-lib
    (:default-pathname "/s5/cl-lib/"
     :pretty-name "Common Lisp Library"
     )
  (:module version ("cl-lib-version"))
  (:module fix-allegro ("allegro-patches"))
  (:module init ("initializations")
           (:uses-definitions-from fix-allegro))
  (:module basic-extensions ("query" "cl-extensions" "more-extensions" "series/s")
           (:uses-definitions-from fix-allegro init))
  (:module more-ui ("better-errors" "prompt-and-read")
           (:uses-definitions-from fix-allegro init basic-extensions))
  (:module more-libraries ("locatives" "triangular-matrices")
           (:uses-definitions-from fix-allegro init basic-extensions))
  (:module more-allegro ("allegro-stuff" "more-allegro")
           (:uses-definitions-from fix-allegro init basic-extensions))
  (:module advanced-tools ("re-to-dfa" "reader" "nregex" "init-extras")
           (:uses-definitions-from fix-allegro init basic-extensions more-allegro))
  (:module resources ("resources")
            (:uses-definitions-from fix-allegro init basic-extensions more-allegro advanced-tools))
  (:module processes ("process")
           (:uses-definitions-from fix-allegro init basic-extensions more-allegro advanced-tools))
  (:module streams ("string-io-stream")
           (:uses-definitions-from fix-allegro init basic-extensions more-allegro advanced-tools processes)))

#+mk-defsystem
(defsystem :cl-lib
  :source-pathname "HD DC90:MCL 2.0.1:knowledge-tools:cl-lib:"
  :binary-pathname "HD DC90:MCL 2.0.1:knowledge-tools:cl-lib:"
  :components (
               (:module version 
                        :source-pathname ""
                        :components ("cl-lib-version"))
               (:module init 
                        :source-pathname ""
                        :components ("initializations"))
               (:module basic-extensions
                        :source-pathname ""
                        :components ("query" "cl-extensions" "more-extensions" #-ccl "series/s")
                        :depends-on (init))
               (:module more-ui 
                        :source-pathname ""
                        :components ("better-errors" "prompt-and-read")
                        :depends-on (init basic-extensions))
               (:module more-libraries
                        :source-pathname ""
                        :components ("locatives" "triangular-matrices")
                        :depends-on (init basic-extensions))
               (:module series
                        :source-pathname "series"
                        :components ("s"))
               (:module advanced-tools 
                        :source-pathname ""
                        :components ("re-to-dfa" "reader" "nregex" "init-extras")
                        :depends-on (init basic-extensions))
               (:module resources
                        :source-pathname ""
                        :components ("resources")
                        :depends-on (init basic-extensions advanced-tools))))

#-(or excl mk-defsystem)

(eval-when (compile load eval)
  (error "Non-allegro / mk defsystems are not currently supported. Please port and send us a copy with your implementation *features*."))

#-cl-lib
(push :cl-lib *features*)               ; for portably portable code (:-)
