(in-package defsys)

;; some new modules
(eval-when (compile load eval)
  (export '(lisp-example-module edit-system)))

;; lisp example - lisp code you don't want to compile but probably want to load.

(defclass lisp-example-module (lisp-module) ())
  
(defmethod compile-module ((module lisp-example-module) &rest keys &key &allow-other-keys)
  t)                                  ; don't compile it.

(defmethod product-pathname ((module lisp-example-module))
  nil)
  
;; edit system

(defun edit-system (system &key silent include-components)
  (excl:map-system system #'(lambda (module)
                              (let ((source (source-pathname module)))
                                (unless silent
                                  (format t "Editing source for ~A~%" source))
                                (ed source)))
                   :silent t
                   :include-components include-components))


;; system initializations

(cl-lib:add-initialization "init random" '(progn (setq *random-state* (make-random-state t))
                                    (format t "Initing *random-state*"))
                    '(:warm))

;; not done yet - sort of like the example in the docs, but how much nicer if defsystem is patched.

(defmethod describe-object ((ht hash-table) stream)
  (format stream "~&~S is a Hash-Table. It contains the following elements (key / value):~%")
  (maphash #'(lambda (k v)
               (format stream ",5t~S~,30t ~S~%" k v))
           ht))


