;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         frobs.l
; Description:  load file for frobs system
; Author:       Eric Muehle, Craig Steury, Jed Krohnfeldt
; Created:      22-Sep-87
; Package:      FROB
; RCS $Header: paths.l,v 2.7 91/04/01 06:03:54 stoller Exp $
;
; (c) Copyright 1987, University of Utah, all rights reserved
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Copyright (c) 1987 Eric G. Muehle and Utah Portable AI Support 
;; Systems Project.  This program may be used, copied, modified, and 
;; redistributed freely for noncommercial purposes, so long as this 
;; notice remains intact and the program is redistributed in its 
;; entirity.  Any commercial use of the software or derivative thereof
;; requires a redistribution license from: Utah PASS Project 3190 M.E.B 
;; Department of Computer Science University of Utah Salt Lake City, UT 
;; 84112

(shadow 'lisp::compile-file)

;; Load the basic frobs.
(load "./pack")
(load "./globals")
(load "./struct")
(load "./misc")
(load "./define")
(load "./user-methods")
(load "./ask-assert")

;; Load the rule system.
(load "./the-rules")

;; Load the system mixin classes.
(load "./daemons")
; (load "./dynamic")

;; Load some other useful macros.
; (load "./useful")

;; Load the p-frobs.
; (load "./p-frobs")

;; Export the functions out of the FROB package.
(use-package 'frobs)

;;; Put the correct compile-file here
(setf frobs::*compile-file-fn* #'lisp::compile-file)

(setf (symbol-function (intern "COMPILE-FILE"))
      #'frobs::frob-compile-file)

;; Set my user name for p-frobs.  There is a conflict in KCL, so you may
;; want to shadow this.
; (setf *user-name* 'your-name)

;; The p-frob loaddir is my home directory.
; (setf frobs::*pfrob-loaddir* "~/p-frob")

;; Print out the copyright, current version, and date.
; (format t "~A~%~A~%~A~%" 
;	frobs::*copyright* frobs::*version* frobs::*release-date*)

(provide "frobs")

;; End of File.
