;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         globals.l
; Description:  Contains all of the global vars for the frobs.
; Author:       Eric G. Muehle
; Created:      15-Jul-86
; Package:      FROBS
; RCS $Header: globals.l,v 2.4 91/04/01 06:08:28 stoller Exp $
;
; (c) Copyright 1986, 1987, University of Utah, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Copyright (c) 1987 Eric G. Muehle and Utah Portable AI Support 
;;; Systems Project.  This program may be used, copied, modified, and 
;;; redistributed freely for noncommercial purposes, so long as this 
;;; notice remains intact and the program is redistributed in its 
;;; entirity.  Any commercial use of the software or derivative thereof
;;; requires a redistribution license from: Utah PASS Project 3190 M.E.B 
;;; Department of Computer Science University of Utah Salt Lake City, UT 
;;; 84112

(in-package 'frobs)

;;; Not to be removed
(defconstant *copyright* "Copyright Eric Muehle and Utah PASS Group")

;;; Not to be removed
(defconstant *version* "FROBS Version 1.2")

;;; Not to be removed
(defconstant *release-date* "August 2, 1988")

(defvar *daemons*
	(make-hash-table :size 100 :rehash-size 2.0
			 :rehash-threshold 0.8)
	"class-name -> T then this is a daemon class")

(defvar *key* 
	(make-hash-table :size 200 :rehash-size 2.0
			      :rehash-threshold 0.8)
	"contains the module locks")

(defvar *hash* 
	(make-hash-table :size 2500 :rehash-size 2.0
			 :rehash-threshold 0.8 :test #'equal)
	"where all of the frobs are held")

(defvar *class-hash* 
	(make-hash-table :size 200 :rehash-size 2.0
			      :rehash-threshold 0.8)
	"where all of the class frobs are held")

(defvar *main-methods* 
	(make-hash-table :size 500 :rehash-size 2.0
			      :rehash-threshold 0.8)
	"where all of the main methods are held")

(defvar *params*
	(make-hash-table :size 500 :rehash-size 2.0
			 :rehash-threshold 0.8)
	"where all of the params are held")


;; (defvar *frobs* nil "contains a list of all of the instance frobs")

(defvar *class-frobs* nil "contains a list of all of the class frobs")

(defvar *module* nil "current module")

(defvar *context* nil "holds the current context for with-frob")

(defvar *mv* 'normal "controls the behavior of MV slots")

(defconstant *undefined* '*undefined* "the undefined value")

(defvar *sys-class* nil "holds the system frobs")

(defvar *sys-meths* nil "holds the system methods")

(defvar *frob-messages* t "when T all system messages are printed")

(defvar *new-frob* nil "the new frob in def-class")

(defvar *new-parent* nil "the new-frobs parent")

(defvar *comp-meths-list* nil)

(defvar *comp-mode* nil)

(defvar *compile-file-fn* nil)

;;; P-FROBS some of these are referenced in the-frobs.l
(defvar *pfrobs* nil "when T one is using pfrobs")

(defvar *threshold* 10000)

(defvar *locations* 0)

(defvar *pfrob-loaddir*)

(defvar *user-name*)

(defvar *paging* nil)

(defvar *default-type* :read-only)


