;************************************************************
;*                                                          *
;*                File : rules
;*                                                          *
;************************************************************

(defun top-rule (object)
  (print-rule 'top-rule object)
  (propagate-abstract! object))

(defun bottom-rule (object)
  (print-rule 'bottom-rule object)
  (clash 'bottom-rule object)
  )

(defun conceptname-rule (concept object)
  (print-rule 'conceptname-rule concept object)
  (let ((obj (propagate-abstract! object))
	)
       (cond ((superconcept-exists? concept (get-neg-concepts obj))
	      (clash 'conceptname-rule concept object))
	     ((subconcept-exists? concept (get-concepts obj)))
	     (t (add-concept-erasable! obj concept)
		(propagate-functions (get-exec-QPCs concept) obj)
		(propagate-functions (get-rules concept) obj))
	     )))

(defun conceptname-rule-II (concept obj)                  ;;; here: obj is already abstract and
  (print-rule 'conceptname-rule-II concept obj)
  (cond ((superconcept-exists? concept (get-neg-concepts obj)) ;;; the QPCs are not processed
	 (clash 'conceptname-rule-II concept obj))
	((concept-exists? concept (get-concepts obj)))
	(t (add-concept-erasable! obj concept)
	   (propagate-functions (get-rules concept) obj))
	))

(defun neg-conceptname-rule (concept object)
  (print-rule 'neg-conceptname-rule concept object)
  (let ((obj (propagate-abstract! object))
	)
       (cond ((subconcept-exists? concept (get-concepts obj))
	      (clash 'neg-conceptname-rule concept obj))
	     ((concept-exists? concept (get-neg-concepts obj)))
	     (t (add-neg-concept-erasable! obj concept)
		(push-concepts-on-or! (make-membership-assertions (get-neg-rules concept)
								  obj)))
	     )))
       
(defun primitive-rule (prim obj)
  (print-rule 'primitive-rule prim obj)
  (if (primitive-in? prim (get-neg-prims obj))
      (clash 'primitive-rule prim obj)
      (add-primitive-erasable! obj prim))
  )
(defun neg-primitive-rule (prim obj)
  (print-rule 'neg-primitive-rule prim obj)
  (if (primitive-in? prim (get-prims obj))
      (clash 'neg-primitive-rule prim obj)
      (add-neg-primitive-erasable! obj prim))
  )

(defun family-rule (fam object)
  (print-rule 'family-rule fam object)
  (let ((obj (propagate-abstract! object))
	)
       (cond ((family-exists? fam (get-pos-family obj)))
	     ((neg-family-exists? fam (get-neg-family obj))
	      (clash 'family-rule fam obj))
	     (t (add-family-erasable! obj fam))
	     )))

(defun subfamily-rule (fam cprims-complement object)
  (print-rule 'subfamily-rule cprims-complement object)
  (let ((obj (propagate-abstract! object))
	)
       (family-rule fam obj)
       (dolist (cprim cprims-complement)
	       (neg-cprim-rule fam cprim obj))
       ))

(defun neg-family-rule (fam object)
  (print-rule 'neg-family-rule fam object)
  (let ((obj (propagate-abstract! object))
	)
       (cond ((family-exists? fam (get-pos-family obj))
	      (clash 'neg-family-rule fam obj))
	     ((neg-family-exists? fam (get-neg-family obj)))
	     ((neg-family-has-entry? fam (get-neg-family obj))
	      (reset-entry! fam (get-neg-family obj)))
	     (t (add-neg-family-erasable! obj fam))
	     )))

(defun neg-subfamily-rule (fam cprims object)
  (print-rule 'neg-subfamily cprims object)
  (let ((obj (propagate-abstract! object))
	)
       (dolist (cprim cprims)
	       (neg-cprim-rule fam cprim obj))
       ))

(defun sprim-rule (fam prim object)
  (print-rule 'sprim-rule fam prim object)
  (let ((obj (propagate-abstract! object))
	)
       (cond ((prim-exists? fam prim (get-neg-family obj))
	      (clash 'sprim-rule fam prim obj))	
	     ((disj-prim-exists? fam prim (get-pos-family obj))
	      (clash 'sprim-rule fam prim obj))
	     ((neg-family-exists? fam (get-neg-family obj))
	      (clash 'sprim-rule fam prim obj))
	     ((prim-exists? fam prim (get-pos-family obj)))
	     (t (add-sprim-erasable! obj fam prim))
	     )))

(defun neg-cprim-rule (fam prim object)
  (print-rule 'neg-cprim-rule fam prim object)
  (let ((obj (propagate-abstract! object))
	)
       (cond ((prim-exists? fam prim (get-pos-family obj))
	      (clash 'neg-cprim-rule fam prim obj))
	     ((or (neg-family-exists? fam (get-neg-family obj))
		  (prim-exists? fam prim (get-neg-family obj))))
	     ((all-neg-exist? fam prim (get-neg-family obj))
	      (if (family-exists? fam (get-pos-family obj))
		  (clash 'neg-cprim-rule fam prim obj)
		  (reset-entry! fam (get-neg-family obj))))
	     (t (add-neg-sprim-erasable! obj fam prim))
	     )))
(defun neg-oprim-rule (fam prim object)
  (print-rule 'neg-oprim-rule fam prim object)
  (let ((obj (propagate-abstract! object))
	)
       (cond ((prim-exists? fam prim (get-pos-family obj))
	      (clash 'neg-oprim-rule fam prim obj))
	     ((prim-exists? fam prim (get-neg-family obj)))
	     (t (add-neg-sprim-erasable! obj fam prim))
	     )))

(defun conjunction-rule (concepts obj)
  (print-rule 'conjunction-rule concepts obj)
  (dolist (concept (reverse concepts))
	  (push-on-main! (make-membership-assertion concept obj)))
  )
(defun disjunction-rule (concepts obj)
  (print-rule 'disjunction-rule concepts obj)
  (push-concepts-on-or! (make-membership-assertions concepts obj))
  )
(defun attr-rule (obj1 attr obj2)
  (print-rule 'attr-rule obj1 attr obj2)
  (cond ((unknown? obj1)
	 (let ((deref-obj1 (bind-abstract! obj1))
	       (attr-filler (make-attr-filler attr obj2))
	       )
	      (trigger-abstract-functions obj1)
	      (add-attr-filler-erasable! deref-obj1 attr-filler)
	      (trigger-attr-path-rules attr-filler (get-cond-funcs deref-obj1))))
	(t (let ((value (get-attr-filler attr obj1))
		 )
		(cond (value
		       (equal-rule value obj2))
		      (t (let ((attr-filler (make-attr-filler attr obj2))
			       )
			      (add-attr-filler-erasable! obj1 attr-filler)
			      (trigger-attr-path-rules attr-filler (get-cond-funcs obj1))))
		      )))
	))

(defun role-rule (obj1 role obj2)
  (print-rule 'role-rule obj1 role obj2)
  (cond ((unknown? obj1)
	 (let ((deref-obj1 (bind-abstract! obj1))
	       (role-filler (make-role-filler role obj2))
	       )
	      (trigger-abstract-functions obj1)
	      (add-role-filler-erasable! deref-obj1 role-filler)
	      (trigger-role-filler-rules role-filler (get-cond-funcs deref-obj1))))
	((role-exists? obj1 role obj2))
	(t (let ((role-filler (make-role-filler role obj2))
		 )
		(add-role-filler-erasable! obj1 role-filler)
		(trigger-role-filler-rules role-filler (get-cond-funcs obj1))))
	)
  )
(defun equal-rule (obj1 obj2)
  (print-rule 'equal-rule obj1 obj2)
  (cond ((equal-objects? obj1 obj2))
	((object-in? obj1 (get-unequals obj2))
	 (clash 'equal-rule obj1 obj2))
	((abstract? obj1)
	 (cond ((abstract? obj2)
		(abstract-equal-abstract-rule obj1 obj2))
	       ((unknown? obj2)
		(abstract-equal-unknown-rule obj1 obj2))
	       (t (clash 'equal-rule obj1 obj2))))
	((concrete? obj1)
	 (cond ((concrete? obj2)
		(concrete-equal-concrete-rule obj1 obj2))
	       ((unknown? obj2)
		(concrete-equal-unknown-rule obj1 obj2))
	       (t (clash 'equal-rule obj1 obj2))))
	((abstract? obj2)
	 (abstract-equal-unknown-rule obj2 obj1))
	((concrete? obj2)
	 (concrete-equal-unknown-rule obj2 obj1))
	((unknown-equal-unknown-rule obj1 obj2))
	)
  )
(defun abstract-equal-abstract-rule (obj1 obj2)
  (print-rule 'abs-equal-abs-rule obj1 obj2)
  (let ((values (bind-abstract->abstract! obj1 obj2))
	)
       (let ((bound (get-bound values))
	     (unbound (get-unbound values))
	     )
	    (let ((primitives (get-prims bound))
		  (neg-primitives (get-neg-prims bound))
		  (conceptnames (get-concepts bound))
		  (neg-conceptnames (get-neg-concepts bound))
		  (apreds (get-apreds bound))
		  (neg-apreds (get-neg-apreds bound))
		  (cond-funcs (get-cond-funcs bound))
		  (unequals (get-unequals bound))
		  (attrs (get-attr-fillers bound))
		  (roles (get-role-fillers bound))
		  (cond-funcs-unbound (get-cond-funcs unbound))
		  (attrs-unbound (get-attr-fillers unbound))
		  (roles-unbound (get-role-fillers unbound))
		  )
		 (cond ((or (common-concept? neg-conceptnames (get-concepts unbound))
			    (common-concept? (get-neg-concepts unbound) conceptnames)
			    (common-primitive? (get-prims unbound) neg-primitives)
			    (common-primitive? (get-neg-prims unbound) primitives)
			    (incompatible-apreds? (get-neg-apreds unbound) apreds)
			    (incompatible-apreds? (get-apreds unbound) neg-apreds)
			    )
			(clash 'abstract-equal-abstract-rule obj1 obj2))
		       (t (propagate-families! (get-pos-family bound) unbound)
			  (propagate-neg-families! (get-neg-family bound) unbound)
			  (propagate-attr-fillers! unbound attrs)
			  (add-prims-erasable! (object-prim unbound) primitives)
			  (add-prims-erasable! (object-neg-prim unbound) neg-primitives)
			  (add-concepts-erasable! (object-concept unbound) conceptnames)
			  (add-concepts-erasable! (object-neg-concept unbound) neg-conceptnames)
			  (add-unequals-erasable! (object-unequals unbound) unequals)
			  (add-fcts-erasable! (object-cond-funcs unbound) cond-funcs)
			  (add-pfcts-erasable! (object-print-cf unbound)
					       (object-print-cf bound))
			  (add-apreds-erasable! (object-apred unbound) apreds)
			  (add-apreds-erasable! (object-neg-apred unbound) neg-apreds)
		;	  (add-role-fillers-erasable! (object-attr-filler unbound) attrs)
			  (add-role-fillers-erasable! (object-role-filler unbound) roles)
		;	  (trigger-new-equal-rules attrs attrs-unbound)
			  (trigger-path-rules attrs roles cond-funcs-unbound)
			  (trigger-path-rules attrs-unbound roles-unbound cond-funcs)
			  ))))))

(defun abstract-equal-unknown-rule (abs-obj unk-obj)
  (print-rule 'abs-equal-unk-rule abs-obj unk-obj)
  (let ((values (bind-unknown->abstract! unk-obj abs-obj))
	)
       (let ((bound (get-bound values))
	     (unbound (get-unbound values))
	     )
	    (add-unequals-erasable! (object-unequals unbound) 
				    (object-unequals bound))
	    (trigger-abstract-functions unk-obj)
	    )))

(defun concrete-equal-concrete-rule (c-obj1 c-obj2)
  (print-rule 'conc-equal-conc-rule c-obj1 c-obj2)
  (let ((values (bind-concrete->concrete! c-obj1 c-obj2))
	)
       (let ((bound (get-bound values))
	     (unbound (get-unbound values))
	     )
	    (add-unequals-erasable! (object-unequals unbound) (object-unequals bound))
	    (funcall (get-concrete-equal-rule (object-domain c-obj1))
	              c-obj1
	              c-obj2)
	    )))

(defun concrete-equal-unknown-rule (c-obj unk-obj)
  (print-rule 'conc-equal-unk-rule c-obj unk-obj)
  (let ((values (bind-concrete->concrete! c-obj unk-obj))
	)
       (let ((bound (get-bound values))
	     (unbound (get-unbound values))
	     )
	    (add-unequals-erasable! (object-unequals unbound) (object-unequals bound))
	    (trigger-concrete-functions unk-obj)
	    )))

(defun unknown-equal-unknown-rule (unk-obj1 unk-obj2)
  (print-rule 'unk-equal-unk-rule unk-obj1 unk-obj2)
  (let ((values (bind-unknown->unknown! unk-obj1 unk-obj2))
	)
       (let ((bound (get-bound values))
	     (unbound (get-unbound values))
	     )
	    (add-unequals-erasable! (object-unequals unbound) (object-unequals bound))
	    (add-fcts-erasable! (object-abstract-functions unbound) 
				(object-abstract-functions bound))
	    (add-fcts-erasable! (object-concrete-functions unbound)
				(object-concrete-functions bound))
	    )))

(defun unequal-rule (obj1 obj2)
  (print-rule 'unequal-rule obj1 obj2)
  (cond ((equal-objects? obj1 obj2)
	 (clash 'unequal-rule obj1 obj2))
	((and (concrete? obj1) (concrete? obj2))
	 (funcall (get-concrete-unequal-rule (object-domain obj1))
	           obj1
	           obj2)
	)
	(t (add-unequal-erasable! obj2 obj1)
	   (add-unequal-erasable! obj1 obj2))
	))

;*********************************************************************
;
; 		help functions for high-level rules 
;
;******************************************************************** 

(defun propagate-functions (functions obj)
  (dolist (function functions)
	  (funcall function obj))
  )
(defun propagate-families! (fams obj)
  (dolist (fam fams)
	  (let ((family (get-family-name fam))
		)
	       (if (only-family-exists? fam)
		   (family-rule family obj)
		   (dolist (prim (get-prims-of-family fam))
			   (sprim-rule family prim obj))))))

(defun propagate-neg-families! (fams obj)
  (dolist (fam fams)
	  (let ((family (get-family-name fam))
		)
	       (if (only-family-exists? fam)
		   (neg-family-rule family obj)
		   (dolist (prim (get-prims-of-family fam))
			   (if (closed-family? family)
			       (neg-cprim-rule family prim obj)
			       (neg-oprim-rule family prim obj)
			       ))))))

(defun propagate-attr-fillers! (obj attr-fillers)
  (dolist (attr-filler attr-fillers)
	  (attr-rule obj (get-role attr-filler) (deref (get-filler attr-filler)))
	  ))

(defun trigger-new-equal-rules (attr-fillers1 attr-fillers2)
  (dolist (attr-filler attr-fillers1)
	  (let ((other-attr-filler (get-other-attr-filler attr-filler attr-fillers2))
		)
	       (if other-attr-filler
		   (equal-rule (deref (get-filler attr-filler))
			       (deref (get-filler other-attr-filler))))))
  )
