% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public
	tab/0, bell/0, home/0, set_cursor/2, set_region/2,
	erase_/1, attrib/1, wwrite/2.

tab :- write('	').
bell :- write('').
home :- vt100_,write('[H').

:- mode set_cursor(+,+).
set_cursor(Line,Column) :- vt100_,
	write('['),write(Line),write(';'),write(Column),write('H').
set_cursor(_,_).
:- mode set_region(+,+).
set_region(Top,Bottom) :- vt100_,
	write('['),write(Top),write(';'),write(Bottom),write('r').
set_region(_,_).

:- mode erase_(+,+).
erase_([cursor,eos]) :- vt100_,write('[0J').
erase_([bos,cursor]) :- vt100_,write('[1J').
erase_([bos,eos])    :- vt100_,write('[2J').
erase_([cursor,eol]) :- vt100_,write('[0K').
erase_([bol,cursor]) :- vt100_,write('[1K').
erase_([bol,eol])    :- vt100_,write('[2K').
erase_(screen)       :- vt100_,write('[2J').
erase_(line)         :- vt100_,write('[2K').
erase_(_).

:- mode attrib(+).
attrib([A1|As]) :- attrib(A1),attrib(As).
attrib(normal)		:- write('[0m').
attrib(bold)		:- write('[1m').
attrib(underline)	:- write('[4m').
attrib(blink)		:- write('[5m').
attrib(reverse)		:- write('[7m').
attrib(graphic)		:- write('(0').
attrib(ascii)		:- write('').
attrib(big)		:- write('#3').
attrib(_).

:- mode wwrite(+,+).
wwrite(X,A) :- vt100_,attrib(A),write(X),
	(((A=big;member(big,A)),nl,write('#4'),write(X)); true),
	attrib(normal).
wwrite(X,_) :- write(X).

% EOF vt100.pl
