% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public ll/0, ll/1, lrl/0, lgl/0, lel/0, lil/0.

ll :- lrl, lgl, lel, lil.

lrl :-	clear(ll_num), nl,write('rewrite lemma'),nl, ll(rewrite).
lgl :-	clear(ll_num), nl,write('generalize lemma'),nl, ll(generalize).
lel :-	clear(ll_num), nl,write('elimination lemma'),nl, ll(elimination).
lil :-	clear(ll_num), nl,write('induction lemma'),nl, ll(induction).

:- mode ll(+).
ll(rewrite) :- rewrite_lemma(_,_,_,_,Type,Name), llemma(Type,Name), fail.
ll(generalize) :- generalization_lemma(Type,Name,_), llemma(Type,Name), fail.
ll(elimination) :- elimination_lemma(Type,Name,_), llemma(Type,Name), fail.
ll(induction) :- induction_lemma(_,_,Type,Name), llemma(Type,Name), fail.
ll(_) :- clear(ll_num).

:- mode llemma(+).
llemma(Type,Name) :- new(ll_num,N),
	tab(3),write(N),write('	'),write(Type),write('	'),write(Name),nl,!.

clear(Counter) :- abolish(Counter,1), C=..[Counter,0], asserta(C),!.

new(Counter,N1) :- O=..[Counter,N], retract(O), N1 is N+1,
	C=..[Counter,N1], asserta(C),!.
new(Counter,1) :- C=..[Counter,1], asserta(C),!.

:- public lp/0, lp/1, lsp/0, lhp/0, lip/0.

lp :- lsp, lhp, lip.

lsp :- clear(lp_num), nl,write('simplification pool'),nl, lp(simplification).
lhp :- clear(lp_num), nl,write('heuristics pool'),nl, lp(heuristics).
lip :- clear(lp_num), nl,write('induction pool'),nl, lp(induction).

:- mode lp(+).
lp(Pool) :- pool(Pool,Name:_), lpool(Name), fail.
lp(_) :- clear(lp_num).

:- mode lpool(+).
lpool(Name) :- new(lp_num,N),
	tab(3),write(N),write('	'),write(Name),nl,!.

:- public rsp/0, rhp/0, rip/0, hpsa/0, hpsz/0, ipsa/0, ipsz/0.

rsp :- retract(pool(simplification,C)), assertz(pool(simplification,C)).
rhp :- retract(pool(heuristics,C)), assertz(pool(heuristics,C)).
rip :- retract(pool(induction,C)), assertz(pool(induction,C)).

hpsa :- retract(pool(heuristics,C)), asserta(pool(simplification,C)).
hpsz :- retract(pool(heuristics,C)), assertz(pool(simplification,C)).
ipsa :- retract(pool(induction,C)), asserta(pool(simplification,C)).
ipsz :- retract(pool(induction,C)), assertz(pool(simplification,C)).

% EOF util.pl
