% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public banner/0.
banner :- wwrite('BMTP in Prolog V4.0 (Aug. 1985)').

:- dynamic abbrev_/1, abbrev__/1.

:- public (abbrev)/1.
:- mode abbrev(+).
abbrev(X=Y) :-
	(setof(V,var_in_pterm(V,X),Vs); Vs=[]),!,
	p_vars(Vs,X=Y,_,Z),
	mtos1(X,XX), mtos(Y,YY),
	p_vars(Vs,XX=YY,_,W),
	asserta(abbrev_(Z)),
	asserta(abbrev__(W)),
	nl,wwrite('Abbreviation ',[reverse,bold]),wwrite(X=Y),nl,
	nl,wwrite('is accepted.'),nl.

:- public (shell)/1.
:- mode shell(+).
shell(X) :- shell_(X).

:- public (definition)/1.
:- mode definition(+).
definition(X) :- definition_(X).

:- public (axiom)/1.
:- mode axiom(+).
axiom(X) :- add_((axiom),X).

:- public (lemma)/1.
:- mode lemma(+).
lemma(X) :- add_((lemma),X).

:- dynamic proving/1.

:- public (theorem)/1.
:- mode	theorem(+).
theorem(X) :-
	nl,pp_((theorem),X),asserta(proving(X)),!,b,!,
	((proving(X),abolish(dumbly,0),X=(NL=B),NL=..[Name|_],mtos(B,Body),!,
	  prove([theorem(Name)]:Body));
	 true),!.

:- public p/0, pr/0.
p :- pr.
pr :- pool(_,_),!, pp_pool.
pr :- (#X),pp_problem(X),fail.
pr.

:- public qq/0.
qq :- retract(pool(_,_:f)),!,abolish(continue,0),!,fail.
qq :- retract(pool(_,_:t)),!,qq,!.
qq :- remove_subsumed,!,qq,!.
qq :- pool(simplification,_),!,simplify,!,qq,!.
qq :- pool(heuristics,_),!,heuristics,!,qq,!.
qq :- retract(pool(_,_)),!,abolish(continue,0),!,fail.
qq :- (defun_loaded; (nl,wwrite('OK',bold),nl)),!,abolish(continue,0),!.

fail_ :- (dumbly; (nl,wwrite('Fail!'),nl)),!,fail.

remove_subsumed :-
	pool(Pool,P1:C1), pool(Pool,P2:C2), P1\==P2, C1==C2,
%	pp_clause(P1:C1,'is subsumed by'),
%	pp_clause(P2:C2,''),
	retract(pool(Pool,P1:C1)),
	remove_subsumed,!.

%:- public r/0.
%r :- s,proving(_),!,r.
%r.

%:- public x/0.
%x :- listing((#)).
%x :- (#X),pp_problem(X),fail.
%x.

:- mode pp_problem(+).
pp_problem(definition(H=B)) :- mtos(B,Body),
	nl,pp_def(H,Body),!.
pp_problem(axiom(H=B)) :- H=..[Name|Labels],mtos(B,Body),
	nl,pp_(axiom,Name,Labels,Body),!.
pp_problem(lemma(H=B)) :- H=..[Name|Labels],mtos(B,Body),
	nl,pp_(lemma,Name,Labels,Body),!.
pp_problem(theorem(H=B)) :- H=..[Name|Labels],mtos(B,Body),
	nl,pp_(theorem,Name,Labels,Body),!.
pp_problem(X) :- nl,wwrite(X),nl.

:- dynamic (@)/1.

%:- public y/0.
%y :- (#X),!,y(X),((retract((#X)),assertz((@X))); true),!.

%:- public s/0.
%s :- retract(pool(_,_:f)),!,fail_.
%s :- retract(pool(_,_:t)),!.
%s :- remove_subsumed,!.
%s :- pool(simplification,_),!,simplify,!.
%s :- pool(heuristics,_),!,heuristics,!.
%s :- pool(induction,_),!,induction,!.
%s :- pool(fail,_),!,fail_.
%s :- proving(X),!,(dumbly; (nl,wwrite('Q.E.D.',bold),nl)),!,
%	add_((theorem),X),abolish(proving,1),!.

:- public n/0, next/0.
n:- next.
next :- proving(_),!, next1.
next :- (#X),!,next_com(X),((retract((#X)),assertz((@X))); true),!.

next1 :- retract(pool(_,_:f)),!,fail_.
next1 :- retract(pool(_,_:t)),!.
next1 :- remove_subsumed,!.
next1 :- pool(simplification,_),!,simplify,!.
next1 :- pool(heuristics,_),!,heuristics,!.
next1 :- pool(induction,_),!,induction,!.
next1 :- pool(fail,_),!,fail_.
next1 :- proving(X),!,(dumbly; (nl,wwrite('Q.E.D.',bold),nl)),!,
	add_((theorem),X),abolish(proving,1),!.

:- dynamic sw/1.

:- public next_com/1.
:- mode next_com(+).
next_com(pause) :- assert(sw(pause)).
next_com(X) :- integer(X),!,(X<1; (X1 is X-1, next,!,next_com(X1))),!.
next_com(make_env(X)) :- retract((#make_env(X))),make_env(X),!.
next_com(X) :- call(X),!.

%:- public z/0.
%z :- retract(sw(pause)).
%z :- proving(_).
%z :- next,!,z.

:- public b/0.
b :- dumbly,!.
b :- ((on_statistics,nl,statistics); true), brk,!.

:- public continue/0.
:- dynamic continue/0.
:- public c/0.
c :- off_(continue).
c :- on(continue).

:- dynamic expl_rewrite/0, expl_expand/0.
:- public t/0.
t :- off_(expl_rewrite),off_(expl_expand).
t :- on(expl_rewrite),on(expl_expand).

:- public q/0, quit/0.
q :- quit.
quit :- abolish(pool,2),
	((proving(X),add_((theorem),X),abolish(proving,1)); true).

:- public h/0.
h :- help.

:- dynamic vt100_/0.
:- public v/0, vt100/0.
v :- vt100.
vt100 :- off_(vt100_).
vt100 :- on(vt100_).

:- public brk/0.
brk :- continue.
brk :- nl,wwrite('Option (h for help): ',[blink,bold]),ttyflush,
	get_com(C),do_com(C),!.

:- mode off(+), off_(+), on(+).
off(SW) :- abolish(SW,0),nl,wwrite(SW),wwrite(' disabled.'),nl.
off_(SW) :- SW,abolish(SW,0),nl,wwrite(SW),wwrite(' disabled.'),nl.
on(SW) :- (SW; asserta(SW)),nl,wwrite(SW),wwrite(' enabled.'),nl.

:- mode get_com(-).
get_com(C) :- ttyget0(X),!,((X<32,C=[]);(get_com(Cs),C=[X|Cs])),!.

:- dynamic expand_depth/1.

:- mode do_com(+).
do_com("a") :- abort.
do_com("b") :- break.
do_com("c") :- c.
do_com("d") :- nl,prompt(_,'expansion depth: '),read(X),
	integer(X),abolish(expand_depth,1),asserta(expand_depth(X)).
do_com("e") :- e.
do_com("g") :- g.
do_com("h") :- help_com,brk.
do_com("p") :- pp_pool,brk.
do_com("t") :- trace.
do_com("v") :- v,brk.
do_com("@") :- !,nl,prompt(_,'| :- '),read(X),call(X).
do_com(_).

:-public help_com/0.
help_com :- wwrite('
a	abort
b	break
c	toggle continue mode
e	toggle tracing (rewrite,expand)
g	give up the proof (but store as lemma)
h	help
p	print remaining conjectures
t	trace
v	toggle VT100 mode
@	accept command
'),!.

:- public (note_env)/1.
:- mode note_env(+).
note_env([F|Fs]) :- note_env(F),!,note_env(Fs),!.
note_env([]).
%note_env(-F) :- name_concat(F,'.env',FE),reconsult(FE),!.
%note_env(F) :- name_concat(F,'.env',FE),consult(FE),!.
note_env(-F) :- name_concat(F,'.env',FE),see(FE),!, abolish((@)/1),
	do_note_env, seen,
	nl,wwrite(FE),wwrite(' has been loaded.'),nl.
note_env(F) :- name_concat(F,'.env',FE),see(FE),!,
	do_note_env, seen,
	nl,wwrite(FE),wwrite(' has been loaded.'),nl.

do_note_env :- read(X), (X=end_of_file ; assert(X), do_note_env).

:- public (make_env)/1.
:- mode make_env(+).
make_env([F|Fs]) :- make_env(F),!,make_env(Fs),!.
make_env([]).
make_env(F) :- name_concat(F,'.env',FE),tell(FE),env,told,
	nl,wwrite(FE),wwrite(' told.'),nl,!.

:- mode name_concat(+,+,-).
name_concat(A,B,C) :- name(A,As), name(B,Bs), append(As,Bs,Cs), name(C,Cs),!.

:- public env/0.
env :-
	listing(abbrev_),
	listing(abbrev__),
	listing(bit_place),
	listing(constructor),
	listing(constructor_bottom),
	listing(constructor_TRs),
	listing(bottom_object),
	listing(accessor),
	listing(type_of_A),
	listing(recognizer),
	listing(recognizer_constructor),
	listing(recognizer_bottom),
	listing(rewrite_lemma),
	listing(induction_lemma),
	listing(elimination_lemma),
	listing((definition)/2),
	listing(type_prescription),
	listing(nonrecursive),
	listing(recursive),
	listing(nasty_function),
	listing(measured_subset),
	listing(induction_template),
	listing((@)),
	listing(pool),
	listing(proving),
	listing(var_seed),
	listing(used_variable),
	listing((#)),
!.

%
%	Pretty Printing
%

:- public pp_def/2.
:- mode	pp_def(+,+).
pp_def(FA,Body) :-
	wwrite('Definition ',bold),wwrite(FA),nl,
	nl,wwrite('    =   '),pp(8,Body),nl,!.

:- public pp_TP/1.
:- mode pp_TP(+).
pp_TP(FA) :-
	type_prescription(FA,tp(TS,Vars)),
	type_list(TS,Vars,TL),
	wwrite('    ... type is '),
%	((TL=[T],!,pp(8,T)); pp(12,['OR'|TL])),!,
	pp_TPs(TL),!,
	wwrite('.'),!.

:- mode pp_TPs(+).
pp_TPs([T]) :- wwrite(T,reverse),!.
pp_TPs([T|Ts]) :- wwrite(T,reverse),wwrite(' or '),pp_TPs(Ts),!.


:- mode type_list(+,+,-).
type_list(8'377777,_,[universe]).
type_list(TS,Vars,[boolean|Types]) :- bit_place([t],B1), bit_place([f],B2),
	ts_intersection(TS,B1,B1),
	ts_intersection(TS,B2,B2),
	ts_difference(TS,B1,TS1),
	ts_difference(TS1,B2,TS2),
	type_list(TS2,Vars,Types),!.
type_list(TS,Vars,[T1|Types]) :- bit_place(T1,B1),
	ts_intersection(TS,B1,B1),
	ts_difference(TS,B1,TS1),
	type_list(TS1,Vars,Types),!.
type_list(0,[V1|Vars],[type_of(V1)|Ts]) :-
	type_list(0,Vars,Ts),!.
type_list(0,[],[]).

wwrite(X) :- write(X).

:- public user_help/0.

user_help :-
	see('help.txt'),
	do_help,
	seen.

do_help :- get0(C), (C= -1 ; put(C), do_help).

{F,Files} :- read_prob(F), {Files}.
{F} :- read_prob(F).

read_prob(File) :- name_concat(File,'.bm',InFile),
	see(InFile), do_read_prob, seen.

do_read_prob :- read(X), (X=end_of_file ; assert(X), do_read_prob).

% EOF top.pl
