% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- mode shell_(+).
shell_(S:R/BTM) :- bit_place(_,BP),
	( (BP=8'200000,nl,error('Too many shells.'),!,fail);
	  ( BP1 is BP<<1,
	    S=..[C|Args], length(Args,N), generate_vars(1,N,Xs),
	    ((N=0, asserta(bit_place([S],BP1))); asserta(bit_place(R,BP1))),
	    arg_list(Args,Args1,As,TRs,DVs,AXs,X),
	    add_shell( C/N,Args1,R,BTM,As,TRs,DVs,AXs,X,Xs ),
	    pp_shell(S:R/BTM),nl,write('is accepted.'),nl)),!.
shell_(S:R) :- shell_(S:R/{}),!.
shell_(X) :-
	error('Wrong shell definition.'),
	pp_shell(X),nl,write('is rejected.'),nl,!.

:- mode arg_list(+,-,-,-,-,+).
arg_list([ATR/DV|Args],[ATR/DV|Args1],
	 [A|As],[TR|TRs],[DV|DVs],[[A,X]|AXs],X) :-
	(ATR=A:TR; (ATR=A,TR=t)),
	arg_list(Args,Args1,As,TRs,DVs,AXs,X),!.
arg_list([],[],[],[],[],[],_).

:- mode add_shell(+,+,+,+,+,+,+,+,+,+).
add_shell( C/N,Args,R,BTM,As,TRs,DVs,AXs,X,Xs ) :-
	nl,write('Adding the following axiom(s)...'),nl,
/* 0 */ add_axiom_A_C(			C/N,Args,Xs,[C|Xs]),
/* 1 */ add_axiom_A_not_R(		C/N,Args,R),
/* 2 */ add_axiom_A_type_restriction(	C/N,Args,[],Xs,[C|Xs]),
/* 3 */ add_axiom_A_BTM(		C/N,Args,BTM),
/* 4 */ add_axiom_A_lessp(		C/N,Args,R,BTM),
/* 5 */ add_axiom_C_equal(		C/N,Args,Xs),
/* 6 */ add_axiom_C_A(			C/N,As,DVs,AXs,X,R,BTM),
/* 7 */ add_axiom_A_elim(		C/N,As,DVs,AXs,X,R,BTM),
/* 8 */ add_axiom_count_C(		C/N,Args,Xs),
/* 9 */ add_axiom_count_BTM(		C/N,BTM),
	((N=0,
	  assertz( constructor(C) ),
	  assertz( recognizer_constructor([R,C]) ));
	 (assertz( constructor([C|Xs]) ),
	  assertz( constructor_TRs([C|Xs],TRs) ),
	  assertz( recognizer_constructor([R,[C|Xs]]) ))),
	assertz( recognizer([R,X]) ),
	assertz_A(Args),
	(BTM={};
	 (assertz( bottom_object(BTM) ),
	  assertz( recognizer_bottom([R,BTM]) ),
	  assertz( constructor_bottom([C|Xs],BTM) ))),!.

:- mode add_axiom_A_C(+,+,+,+).
/* 0 */ add_axiom_A_C(C/N,[ATR/DV|As],[X|Xs],CX) :-
	((ATR=A:TR,RHS=[if,[TR,X],X,DV]); (ATR=A,RHS=X)),
	asserta(rewrite_lemma([A,CX],RHS,t,no,
		(axiom),[A,C])),
	Body=[equal,[A,CX],RHS],
	numbervars(Body,0,_),
	nl,pp_((axiom),[A,C],rewrite,Body),
	add_axiom_A_C(C/N,As,Xs,CX),!.
%
% e.g.		[equal,[sub1,[add1,X]],
%		       [if,[numberp,X],X,0]]
%
add_axiom_A_C(_,[],[],_).

:- mode add_axiom_A_not_R(+,+,+).
/* 1 */ add_axiom_A_not_R(C/N,[ATR/DV|As],R) :-
%	(ATR=A:TR; ATR=A),
	(ATR=A:_; ATR=A),
	asserta(rewrite_lemma([A,X],DV,[[[not,[R,X]]]],no,
		(axiom),[A,not,R])),
	Body=[implies,[not,[R,X]],[equal,[A,X],DV]],
	numbervars(Body,0,_),
	nl,pp_((axiom),[A,not,R],rewrite,Body),
	add_axiom_A_not_R(C/N,As,R),!.
%
% e.g.		[implies,[not,[listp,X]],
%			 [equal,[car,X],nil]]
%
add_axiom_A_not_R(_,[],_).

:- mode add_axiom_A_type_restriction(+,+,+,+,+).
/* 2 */ add_axiom_A_type_restriction(C/N,[ATR/DV|As],Xh,[X|Xt],CX) :-
	((ATR=A:TR,
	append(Xh,[DV|Xt],DVx),
	asserta(rewrite_lemma(CX,[C|DVx],[[[not,[TR,X]]]],no,
		(axiom),type_restriction(A))),
	Body=[implies,[not,[TR,X]],[equal,CX,[C|DVx]]],
	numbervars(Body,0,_),
	nl,pp_((axiom),type_restriction(A),rewrite,Body)); true),
	append(Xh,[X],Xh1),
	add_axiom_A_type_restriction(C/N,As,Xh1,Xt,CX),!.
%
% e.g.		[implies,[not,[numberp,X]],
%			 [equal,[add1,X],
%				[add1,0]]]
%
add_axiom_A_type_restriction(_,[],_,[],_).

:- mode add_axiom_A_BTM(+,+,+).
/* 3 */ add_axiom_A_BTM(_,_,{}).
	add_axiom_A_BTM(C/N,[ATR/DV|As],BTM) :-
%	(ATR=A:TR; ATR=A),
	(ATR=A:_; ATR=A),
	asserta(rewrite_lemma([A,BTM],DV,t,no,
		(axiom),[A,BTM])),
	Body=[equal,[A,BTM],DV],
	numbervars(Body,0,_),
	nl,pp_((axiom),[A,BTM],rewrite,Body),
	add_axiom_A_BTM(C/N,As,BTM),!.
%
% e.g.		[equal,[sub1,0],0]
%
add_axiom_A_BTM(_,[],_).

:- mode add_axiom_A_lessp(+,+,+,+).
%/* 4 */ add_axiom_A_lessp(C/N,[ATR/DV|As],R,BTM) :-
%	(ATR=A:TR; ATR=A),
/* 4 */ add_axiom_A_lessp(C/N,[ATR/_|As],R,BTM) :-
	(ATR=A:_; ATR=A),
	((BTM={},LHS=[R,x]); LHS=[and,[R,x],[not,[equal,x,BTM]]]),
	Body=[lessp,[count,[A,x]],[count,x]],
	numbervars(Body,0,_),
	formula_to_clauses(LHS,LHSC),
	p_vars([x],[LHSC,Body],_,P), P=[P_LHS,P_Body],
	asserta(induction_lemma(P_Body,P_LHS,(axiom),lessp(A))),
	nl,pp_((axiom),lessp(A),induction,[implies,LHS,Body]),
	add_axiom_A_lessp(C/N,As,R,BTM),!.
%
% e.g.		[implies,[and,[numberp,X],
%			      [not,[equal,X,0]]],
%			 [lessp,[count,[sub1,X]],[count,[sub1,X]]]]
%
add_axiom_A_lessp(_,[],_,_).

:- mode add_axiom_C_equal(+,+,+).
/* 5 */ add_axiom_C_equal(C/N,Args,Xs) :- (N=0; (
	generate_vars(1,N,Ys),
	tr_list(Xs,Ys,Args,TRlist),
	(TRlist=[RHS]; RHS=[and|TRlist]),
	asserta(rewrite_lemma([equal,[C|Xs],[C|Ys]],RHS,t,no,
		(axiom),equal(C))),
	Body=[equal,[equal,[C|Xs],[C|Ys]],RHS],
	numbervars(Body,0,_),
	nl,pp_((axiom),equal(C),rewrite,Body))),!.
%
% e.g.		[equal,[equal,[add1,X1],
%			      [add1,Y1]].
%		       [if,[numberp,X1],
%			   [if,[numberp,Y1],
%			       [equal,X1,Y1],
%			       [equal,X1,0]],
%			   [if,[numberp,Y1],
%			       [equal,0,Y1],
%			       t]]]]
%

:- mode tr_list(+,+,+,-).
%tr_list([X|Xs],[Y|Ys],[A:TR/DV|As],
tr_list([X|Xs],[Y|Ys],[_:TR/DV|As],
	[[if,[TR,X],
	     [if,[TR,Y],
		 [equal,X,Y],
		 [equal,X,DV]],
	     [if,[TR,Y],
		 [equal,DV,Y],
		 t]]|TRlist]) :- !,
	tr_list(Xs,Ys,As,TRlist),!.
%tr_list([X|Xs],[Y|Ys],[A/DV|As],[[equal,X,Y]|TRlist]) :- !,
tr_list([X|Xs],[Y|Ys],[_|As],[[equal,X,Y]|TRlist]) :- !,
	tr_list(Xs,Ys,As,TRlist),!.
tr_list([],[],[],[]).

:- mode add_axiom_C_A(+,+,+,+,+,+,+).
/* 6 */ add_axiom_C_A(C/N,As,DVs,AXs,X,R,BTM) :- (N=0; (
	((BTM={},LHS=[R,X]); LHS=[and,[R,X],[not,[equal,X,BTM]]]),
	asserta(rewrite_lemma([C|AXs],[if,LHS,X,[C|DVs]],t,no,
		(axiom),[C,As])),
	Body=[equal,[C|AXs],[if,LHS,X,[C|DVs]]],
	numbervars(Body,0,_),
	nl,pp_((axiom),[C,As],rewrite,Body))),!.
%
% e.g.		[equal,[add1,[sub1,X]],
%		       [if,[and,[numberp,X],
%				[not,[equal,X,0]]],
%			   X,
%			   [add1,0]]]
%

:- mode add_axiom_A_elim(+,+,+,+,+,+,+).
%/* 7 */ add_axiom_A_elim(C/N,As,DVs,AXs,X,R,BTM) :- (N=0; (
/* 7 */ add_axiom_A_elim(C/N,As,_,AXs,X,R,BTM) :- (N=0; (
	((BTM={},LHS=[R,X]); LHS=[and,[R,X],[not,[equal,X,BTM]]]),
	asserta(elimination_lemma((axiom),elim(As),
		[implies,LHS,
			 [equal,[C|AXs],X]])),
	Body=	[implies,LHS,
			 [equal,[C|AXs],X]],
	numbervars(Body,0,_),
	nl,pp_((axiom),elim(As),elimination,Body))),!.
%
% e.g.		[implies,[and,[numberp,X],
%			      [not,[equal,X,0]]],
%			 [equal,[add1,[sub1,X]],X]]).
%

:- mode add_axiom_count_C(+,+,+).
/* 8 */ add_axiom_count_C(C/N,Args,Xs) :-
	((N=0,LHS=C); LHS=[C|Xs]),
	count_list(Args,Xs,Counts),
	((Counts=[],RHS=zero); Counts=[RHS]; RHS=[plus|Counts]),
	asserta(rewrite_lemma([count,LHS],[add1,RHS],t,no,
		(axiom),count(C))),
	Body=[equal,[count,LHS],[add1,RHS]],
	numbervars(Body,0,_),
	nl,pp_((axiom),count(C),rewrite,Body),!.
%
% e.g.		[equal,[count,[cons,X1,X2]],
%		       [add1,[plus,[count,X1],[count,X2]]]]
%

:- mode count_list(+,+,-).
%count_list([A:TR/DV|As],[X|Xs],[[if,[TR,X],[count,X],zero]|Counts]) :- !,
count_list([_:TR/_|As],[X|Xs],[[if,[TR,X],[count,X],zero]|Counts]) :- !,
	count_list(As,Xs,Counts),!.
count_list([_|As],[X|Xs],[[count,X]|Counts]) :- !,
	count_list(As,Xs,Counts),!.
count_list([],[],[]).

:- mode add_axiom_count_BTM(+,+).
%/* 9 */ add_axiom_count_BTM(C/N,BTM) :-
/* 9 */ add_axiom_count_BTM(_,BTM) :-
	(BTM={};
	 (asserta(rewrite_lemma([count,BTM],zero,t,no,
		(axiom),count(BTM))),
	  Body=[equal,[count,BTM],zero],
	  numbervars(Body,0,_),
	  nl,pp_((axiom),count(BTM),rewrite,Body))),!.
%
% e.g.		[equal,[count,0],0]
%

:- mode assertz_A(+).
%assertz_A([ATR/DV|As]) :-
assertz_A([ATR/_|As]) :-
	((ATR=A:TR,assertz(type_of_A([TR,[A,X]]))); ATR=A),
	assertz(accessor([A,X])),
	assertz_A(As),!.
assertz_A([]).

:- mode pp_shell(+).
pp_shell(S:R/BTM) :-
	nl,wwrite('Shell ',bold),S=..[C|Args],wwrite(C,reverse),
	(Args=[];
	 (wwrite('(',reverse),pp_C(Args),wwrite(')',reverse),nl,
	  tab(8),write('Accessor(:Type-restriction)/Default-value: '),
	  ((Args=[A],write(A),nl);
	   (nl,pp_As(Args))))),
	tab(8),write('Recognizer: '),wwrite(R,reverse),nl,
	(BTM={};(tab(8),write('Bottom-object: '),wwrite(BTM,reverse),nl)),!.
pp_shell(S) :- \+S=_:_,
	nl,wwrite('Shell ',bold),wwrite(S,reverse),nl,!.

:- mode pp_C(+).
pp_C([_|Args]) :-
	wwrite('_',reverse),(Args=[];(wwrite(',',reverse),pp_C(Args))),!.

:- mode pp_As(+).
pp_As([A|As]) :-
	tab(16),wwrite(A,reverse),nl,(As=[];pp_As(As)),!.

% EOF shell.pl
