% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public set_equalp/2.
:- mode set_equalp(+,+).
set_equalp([A1|A],B) :- !,set_delete(B,A1,B1),set_equalp(A,B1),!.
set_equalp(X,X).

:- public set_memberp/2.
:- mode set_memberp(+,+).
set_memberp(A,[B|_]) :- set_equalp(A,B),!.
set_memberp(A,[_|B]) :- set_memberp(A,B),!.

:- public set_delete/3.
:- mode set_delete(+,+,-).
set_delete([A1|A],B,C) :- set_equalp(A1,B),!, set_delete(A,B,C),!.
set_delete([A1|A],B,[A1|C]) :- set_delete(A,B,C),!.
set_delete([],_,[]).

:- public subsetp/2.
:- mode subsetp(+,+).
subsetp([A1|A],B) :- set_memberp(A1,B),subsetp(A,B),!.
subsetp([],_).

:- public union/3.
:- mode union(+,+,-).
union([A1|A],B,C) :- set_memberp(A1,B),!,union(A,B,C),!.
union([A1|A],B,[A1|C]) :- union(A,B,C),!.
union([],B,B).

:- public intersection/3.
:- mode intersection(+,+,-).
intersection([A1|A],B,[A1|C]) :- set_memberp(A1,B),!,intersection(A,B,C),!.
intersection([_|A],B,C) :- intersection(A,B,C),!.
intersection([],_,[]).

:- public set_equal/2.
:- mode set_equal(+,+), set_equal1(+,+).
set_equal(A,B) :- var(A), var(B),!, A==B.
set_equal(A,_) :- var(A),!, fail.
set_equal(_,B) :- var(B),!, fail.
set_equal(A,A) :- atomic(A).
set_equal(X,Y) :- X=..[F|A],Y=..[F|A].
set_equal(A,[_|_]) :- atomic(A),!, fail.
set_equal([_|_],B) :- atomic(B),!, fail.
set_equal(A,B) :- set_equal1(A,B),!, set_equal1(B,A).

	set_equal1([A1|A],B) :- set_member(A1,B),!, set_equal1(A,B).
	set_equal1([],_).

:- public set_member/2.
:- mode set_member(+,+).
set_member(A,[B|C]) :- var(A), var(B),!, (A==B; set_member(A,C)).
set_member(A,[B|_]) :- set_equal(A,B).
set_member(A,[_|B]) :- set_member(A,B).

:- public subset/2.
:- mode subset(?,+).
subset([A1|A],B) :- set_member(A1,B), subset(A,B).
subset([],_).

:- public var_union/3.
:- mode var_union(+,+,-).
var_union([A1|A],B,C) :- set_member(A1,B),!,var_union(A,B,C),!.
var_union([A1|A],B,[A1|C]) :- var_union(A,B,C),!.
var_union([],B,B).

% EOF set.pl
