% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- mode	rewrite(+,-,+,+,-,+,-,+,-).
rewrite(X,X,_,U,U,V,V,W,W) :- var(X),!.
rewrite(X,X,_,U,U,V,V,W,W) :- integer(X),!.
rewrite([`,X],[`,X],_,U,U,V,V,W,W).
rewrite(X,Z,[I,N,P,L,H],U,U1,V,V1,W,W1) :-
	rewrite0(X,Y,[I,N,P,L,H],U,U1,V,V1,W,W1),
	((H=tf,type_set(Y,YTS,I),ts_intersection(YTS,1,YTS1),YTS1=0,Z=t);
	 Z=Y),!.

:- mode	rewrite0(+,-,+,+,-,+,-,+,-).
rewrite0(t,t,_,U,U,V,V,W,W).
rewrite0(f,f,_,U,U,V,V,W,W).
rewrite0([quote,X],[quote,X],_,U,U,V,V,W,W).
rewrite0(X,Y,_,U,U,V,V1,W,W) :- member(X,V),!,V=V1,!,X=Y,!.
rewrite0(X,Y,[TS_alist|_],U,U,V,V1,W,W) :-
	member(X=TS,TS_alist),bit_place([Y],TS),!,V=V1,!.
rewrite0(X,t,_,U,U,V,V,W,W) :- recognizer_constructor(X),!.
rewrite0(X,t,_,U,U,V,V,W,W) :- recognizer_bottom(X),!.
rewrite0(X,Y,_,U,U,V,[Y|V],W,W) :- variable(X),!,X=Y,!.
rewrite0(X,Y,_,U,U,V,[Y|V],W,W) :- explicit_value(X),!,X=Y,!.
rewrite0(X,Z,[TS_alist|Info],U,U1,V,[Z|V1],W,W1) :-
	rewrite1(X,Y,[TS_alist|Info],U,U1,V,V1,W,W1),!,
	((type_set(Y,TS,TS_alist),bit_place([Z],TS)); Y=Z),!.

:- mode	rewrite1(+,-,+,+,-,+,-,+,-).

rewrite1([if,_,X,X],X1,I,U,U1,V,V1,W,W1) :- !,rewrite(X,X1,I,U,U1,V,V1,W,W1),!.
rewrite1([if,t,L,_],L1,I,U,U1,V,V1,W,W1) :- !,rewrite(L,L1,I,U,U1,V,V1,W,W1),!.
rewrite1([if,f,_,R],R1,I,U,U1,V,V1,W,W1) :- !,rewrite(R,R1,I,U,U1,V,V1,W,W1),!.
rewrite1([if,T,L,R],New,[TS_alist,N_list,_,Lev,H],U,U2,V,V2,W,W2) :-
	rewrite(T,T1,[TS_alist,N_list,[],Lev,tf],U,U1,V,V1,W,W1),!,
	rewrite_if(T1,L,R,New,[TS_alist,N_list,_,Lev,H],
			U1,U2,V1,V2,W1,W2),!.

:- mode rewrite_if(+,+,+,-,+,+,-,+,-,+,-).
rewrite_if(t,L,_,New,[TS_alist,N_list,_,Lev,H],U,U1,V,V1,W,W1) :- !,
	rewrite(L,New,[TS_alist,N_list,[],Lev,H],U,U1,V,V1,W,W1),!.
rewrite_if(f,_,R,New,[TS_alist,N_list,_,Lev,H],U,U1,V,V1,W,W1) :- !,
	rewrite(R,New,[TS_alist,N_list,[],Lev,H],U,U1,V,V1,W,W1),!.
rewrite_if(T,L,R,New,[TS_alist,N_list,_,Lev,H],U,U,V,V,W,W2) :-
	type_set(T,TS,TS_alist), TS=3,
	ts_assumption(T,A,TS_alist), A=or(L_Ass,R_Ass),!,
	(((expl_rewrite; expl_expand),
	  write('------------------------------------------------------------------------------'),nl); true),
	rewrite(L,L1,[L_Ass,N_list,[],Lev,H],U,_,[],_,W,W1),!,
	(((expl_rewrite; expl_expand),
	  write('------------------------------------------------------------------------------'),nl); true),
	rewrite(R,R1,[R_Ass,N_list,[],Lev,H],U,_,[],_,W1,W2),!,
	(((expl_rewrite; expl_expand),
	  write('------------------------------------------------------------------------------'),nl); true),
	rewrite_if1([if,T,L1,R1],New,TS_alist),!.
rewrite_if(T,L,R,[if,T,L,R],_,U,U,V,V,W,W).

%
%   Use the following (wired-in-)rewrite rules if applicable:
%
%	[equal,[if,X,Y,Y],Y]
%	[equal,[if,X,X,f],X]
%	[equal,[if,X,t,f],X]	(applied only if X is Boolean)
%

:- mode	rewrite_if1(+,-,+).
rewrite_if1([if,_,Y,Y],Y,_).
rewrite_if1([if,X,X,f],X,_).
rewrite_if1([if,X,t,f],X,TS_alist) :- type_set(X,TS,TS_alist),TS=3,!.
rewrite_if1([if,[not,X],f,t],X,TS_alist) :- type_set(X,TS,TS_alist),TS=3,!.
rewrite_if1(X,X,_).

rewrite1([equal,X,X],t,_,U,U,V,V,W,W).
rewrite1([equal,L,R],New,[TS_alist,N_list,P_list,Lev,H],U,U3,V,V3,W,W3) :-
	rewrite(L,L1,[TS_alist,N_list,[],Lev,strict],U,U1,V,V1,W,W1),!,
	rewrite(R,R1,[TS_alist,N_list,[],Lev,strict],U1,U2,V1,V2,W1,W2),!,
	rewrite_equal(L1,R1,New,[TS_alist,N_list,P_list,Lev,H],
			U2,U3,V2,V3,W2,W3),!.

:- mode rewrite_equal(+,+,-,+,+,-,+,-,+,-).
rewrite_equal(X,X,t,_,U,U,V,V,W,W).
rewrite_equal(L,R,f,[TS_alist,_,_,_,_],U,U,V,V,W,W) :-
	type_set(L,L_ts,TS_alist), type_set(R,R_ts,TS_alist),
	ts_intersection(L_ts,R_ts,0),!.
rewrite_equal(L,R,f,_,U,U,V,V,W,W) :- explicit_value(L), explicit_value(R),!.
rewrite_equal(L,R,f,_,U,U,V,V,W,W) :- bottom_object(L), constructor(R),!.
rewrite_equal(L,R,f,_,U,U,V,V,W,W) :- bottom_object(R), constructor(L),!.
rewrite_equal(L,R,f,[TS_alist,_,_,_,_],U,U,V,V,W,W) :- constructor_TRs(R,TRs),
	R=[_|Args], component(L,Args,TRs,TS_alist),!.
rewrite_equal(L,R,f,[TS_alist,_,_,_,_],U,U,V,V,W,W) :- constructor_TRs(L,TRs),
	L=[_|Args], component(R,Args,TRs,TS_alist),!.
rewrite_equal(L,R,New,I,U,U1,V,V1,W,W1) :-
	rewrite_equal1([equal,L,R],New,I,U,U1,V,V1,W,W1),!.
rewrite_equal(L,R,New,I,U,U1,V,V1,W,W1) :-
	rewrite_equal1([equal,R,L],New,I,U,U1,V,V1,W,W1),!.
rewrite_equal(L,R,New,I,U,U1,V,V1,W,W1) :-
	if_expr([equal,L,R],P), if_norms(P,Q),
	((Q\==[equal,L,R],!,
	  rewrite(Q,New,I,U,U1,V,V1,W,W1));
	 rewrite_val([equal,L,R],New,I,U,U1,V,V1,W,W1)),!.
rewrite_equal(L,R,[equal,L,R],_,U,U,V,V,W,W).

:- mode component(+,+,+,+).
component(T,[T|_],t,_).
component(T,[T|_],[TR|_],TS_alist) :- type_set([TR,T],TS,TS_alist),TS=2,!.
component(T,[_|Args],[_|TRs],TS_alist) :- component(T,Args,TRs,TS_alist),!.

%
%   Use the following (wired-in-)rewrite rules if applicable:
%
%	[equal,[equal,X,t],X]	(applied only if X is Boolean)
%
%	[equal,[equal,X,[equal,Y,Z]],
%	       [if,[equal,Y,Z],
%		   [equal,X,t],
%		   [equal,X,f]]]
%
%	[equal,[equal,X,f],[if,X,f,t]]
%

:- mode rewrite_equal1(+,-,+,+,-,+,-,+,-).
rewrite_equal1([equal,X,t],New,[TS_alist|Info],U,U1,V,V1,W,W1) :-
	type_set(X,TS,TS_alist),TS=3,!,
	rewrite_equal2(X,New,[TS_alist|Info],U,U1,V,V1,W,W1),!.
rewrite_equal1([equal,X,[equal,Y,Z]],New,I,U,U1,V,V1,W,W1) :-
	rewrite_equal2([if,[equal,Y,Z],[equal,X,t],[equal,X,f]],
		    New,I,U,U1,V,V1,W,W1),!.
rewrite_equal1([equal,X,f],New,I,U,U1,V,V1,W,W1) :-
	rewrite_equal2([if,X,f,t],New,I,U,U1,V,V1,W,W1),!.

:- mode rewrite_equal2(+,-,+,+,-,+,-,+,-).
rewrite_equal2(X,Y,I,U,U1,V,V1,W,W1) :- rewrite_val(X,Y,I,U,U1,V,V1,W,W1),!.
rewrite_equal2(X,X,_,U,U,V,V,W,W).

rewrite1(X,New,[TS_alist,N_list,P_list,Lev,H],U,U2,V,V2,W,W2) :-
	recognizer(X),!,X=[R,Y],!,
	(bit_place(R,RTS);
	 (recognizer_constructor([R,C]), bit_place([C],RTS))),!,
	rewrite(Y,Z,[TS_alist,N_list,[],Lev,strict],U,U1,V,V1,W,W1),!,
	type_set(Z,ZTS,TS_alist),!,
	((RTS=ZTS,!,New=t,!,U1=U2,!,V1=V2,!,W1=W2);
	 (ts_intersection(RTS,ZTS,0),!,New=f,!,U1=U2,!,V1=V2,!,W1=W2);
	 rewrite_val([R,Z],New,[TS_alist,N_list,P_list,Lev,H],
			U1,U2,V1,V2,W1,W2);
	 (New=[R,Z],!,U1=U2,!,V1=V2,!,W1=W2)),!.

rewrite1([not,X],New,[TS_alist,N_list,_,Lev,H],U,U2,V,V2,W,W2) :- !,
	((H=t,!,H1=f); (H=f,!,H1=t); H1=H),!,
	rewrite(X,Y,[TS_alist,N_list,[],Lev,H1],U,U1,V,V1,W,W1),!,
	((Y=t,!,New=f,!,U1=U2,!,V1=V2,!,W1=W2);
	 (Y=f,!,New=t,!,U1=U2,!,V1=V2,!,W1=W2);
	 (if_norms([not,Y],Z),Z\==[not,Y],!,
	  rewrite(Z,New,[TS_alist,N_list,p_list,Lev,H],U1,U2,V1,V2,W1,W2));
	 (negate(Y,New),!,U1=U2,!,V1=V2,!,W1=W2)),!.
/*
rewrite1(X,New,_,U,U,V,V,W,W) :- (integer(X); X=[list|_]; X=[`|_]),!,
	((H=tf,!,New=t); expand_abbrev(X,New)),!.

rewrite1(X,New,_,U,U,V,V,W,W) :- expand_abbrev1(X,New),!.
*/
rewrite1([F|A],New,[TS_alist,N_list,P_list,Lev,H],U,U2,V,V2,W,W2) :-
	rewrite_args(A,B,[TS_alist,N_list,[],Lev,strict],U,U1,V,V1,W,W1),!,
	if_expr([F|B],P), if_norms(P,Q),
	((Q\==[F|B],!,
	  rewrite(Q,New,
	       [TS_alist,N_list,P_list,Lev,H],U1,U2,V1,V2,W1,W2));
	 expand([F|A],[F|B],New,
	       [TS_alist,N_list,P_list,Lev,H],U1,U2,V1,V2,W1,W2)),!.

:- mode rewrite_args(+,-,+,+,-,+,-,+,-).
rewrite_args([A|As],[B|Bs],[TS_alist,N_list,_,Lev,H],U,U2,V,V2,W,W2) :-
	rewrite(A,B,[TS_alist,N_list,[],Lev,H],U,U1,V,V1,W,W1),!,
	rewrite_args(As,Bs,[TS_alist,N_list,[],Lev,H],U1,U2,V1,V2,W1,W2),!.
rewrite_args([],[],_,U,U,V,V,W,W).

%
%	Rewriting Terms using axioms and lemmas
%

:- mode rewrite_val(+,-,+,+,-,+,-,+,-).
rewrite_val(X,New,I,U,U1,V,V1,W,W1) :-
	rewrite_lemma(X,Y,Hyp,P,Type,Name),
	rewrite_val1(X,Y,Hyp,P,Type,Name,New,I,U,U1,V,V1,W,W1),!.
rewrite_val(X,New,[T,N,Q,L,H],U,U1,V,V1,W,W1) :-
	negate(X,NX),
	rewrite_lemma(NX,Y,Hyp,P,Type,Name),
	((H=t,H1=f); (H=f,H1=t); H1=H),
	rewrite_val1(NX,Y,Hyp,P,Type,Name,Z,[T,N,Q,L,H1],U,U1,V,V1,W,W1),
	negate(Z,New),!.

	% "rewrite_val" may fail

:- mode rewrite_val1(+,+,+,+,+,+,-,+,+,-,+,-,+,-).
rewrite_val1(L,R,Hyp,P,Type,Name,New,[TS_alist,N_list,_,Lev,H],
		U,U2,V,V2,W,W2) :-
	expl_rewrite_lemma(Type,Name,Lev),!,
	L1 is Lev+1,!,
	establish(Hyp,[TS_alist,N_list,[],L1,H],
		U,_,V,_,[r(Lev,Type,Name)|W],W1),!,
/*
	(P\==permutative; \+member(R,P_list)),
	rewrite(R,New,[TS_alist,[],[L|P_list],Lev,H],U1,U2,V1,V2,W1,W2),!,
	(P\==permutative; New @< L;
	 (measured_subset(New,MS),explicit_values(MS))),!.
*/
	(P\==permutative; alphalessp(R,L)),
	rewrite(R,New,[TS_alist,[],[],Lev,H],U,U2,V,V2,W1,W2),!.

:- mode alphalessp(+,+).
alphalessp([X|Xs],[Y|Ys]) :- !,length([X|Xs],L),length([Y|Ys],M),!,
	(L<M;
	 (L=M,(alphalessp(X,Y); (alphalesseqp(X,Y),alphalessp(Xs,Ys))))),!.
alphalessp(X,[_|_]) :- atomic(X),!.
alphalessp(X,Y) :- atomic(X), atomic(Y), alpha_lessp(X,Y),!.

:- mode alphalesseqp(+,+).
alphalesseqp([X|Xs],[Y|Ys]) :- !,length([X|Xs],L),length([Y|Ys],M),!,
	(L<M; (L=M,alphalesseqp(X,Y),alphalesseqp(Xs,Ys))),!.
alphalesseqp(X,[_|_]) :- atomic(X),!.
alphalesseqp(X,Y) :- atomic(X), atomic(Y), \+alpha_lessp(Y,X),!.

:- public alpha_lessp/2.
:- mode alpha_lessp(+,+).
alpha_lessp(X,Y) :- lessp_transitive(X,Y),!.
alpha_lessp(X,Y) :- \+lessp_transitive(Y,X), X @< Y,!.

:- public lessp_transitive/2.
:- mode lessp_transitive(+,+).
lessp_transitive(X,Y) :- lessp(X,Y),!.
lessp_transitive(X,Y) :- lessp(X,Z),lessp_transitive(Z,Y),!.

% Preventing from Infinite Backward Chaining

:- public establish/8.
:- mode establish(+,+,+,-,+,-,+,-).
establish(t,_,U,U,V,V,W,W).
establish([Hyp|Hyps],[TS_alist,N_list,_,Lev,H],U,U2,V,V2,W,W2) :-
	establish1(Hyp,[TS_alist,N_list,[],Lev,H],U,U1,V,V1,W,W1),
	establish(Hyps,[TS_alist,N_list,[],Lev,H],U1,U2,V1,V2,W1,W2).
establish([],_,U,U,V,V,W,W).

:- mode establish1(+,+,+,-,+,-,+,-).
establish1([Hyp|_],I,U,U1,V,V1,W,W1) :- establish2(Hyp,I,U,U1,V,V1,W,W1).
establish1([_|Hyp],I,U,U1,V,V1,W,W1) :- establish1(Hyp,I,U,U1,V,V1,W,W1).

:- mode establish2(+,+,+,-,+,-,+,-).
establish2({},_,U,U,V,V,W,W).
establish2({X},_,U,U,V,V,W,W) :- call(X),!.
%establish2({X},_,U,U,V,V,W,W).
establish2(Hyp,[TS_alist,_,_,_,_],U,U,V,V,W,W) :- has_free_var(Hyp),!,
	fix_free_var(Hyp,TS_alist).
establish2(Hyp,[_,N_list,_,_,_],U,U,V,V,W,W) :- member(Hyp,N_list),!.
establish2(Hyp,[_,N_list,_,_,_],U,U,V,V,W,W) :-
	find_looping(Hyp,N_list),!,fail.
establish2(Hyp,[TS_alist,N_list,_,Lev,_],U,U1,V,V1,W,W1) :-
	add_negation(Hyp,N_list,N_list1),!,
	rewrite(Hyp,X,[TS_alist,N_list1,[],Lev,t],U,U1,V,V1,W,W1),!,
	X = t,!.

% Fixing Free Variables

:- mode fix_free_var(+,+).
fix_free_var(Hyp,TS_alist) :- assume_t(Hyp,HypTS),!,member(HypTS,TS_alist),!.

:- public has_free_var/1.
has_free_var(X) :- var(X),!.
has_free_var([A|D]) :- (has_free_var(A); has_free_var(D)),!.

:- mode assume_t(+,-).
assume_t([not,X],Ass) :- !,assume_f(X,Ass),!.
assume_t(X,X=2).

:- mode assume_f(+,-).
assume_f([not,X],Ass) :- !,assume_t(X,Ass),!.
assume_f(X,X=1).

:- mode find_looping(+,+).
find_looping(_,[]) :- !,fail.  
find_looping(New,N_list) :- negate(New,NN), member(NN,N_list),!.
find_looping(New,N_list) :- one_of(Old,N_list),
	atom_of(New,NewAtom),
	atom_of(Old,OldAtom),
	elaboration(OldAtom,NewAtom),!.

:- mode add_negation(+,+,-).
add_negation([not,Hyp],N_list,[Hyp|N_list]).
add_negation(Hyp,N_list,[[not,Hyp]|N_list]).

:- mode atom_of(+,-).
atom_of([not,X],Y) :- !,atom_of(X,Y),!.
atom_of(X,X).

:- mode elaboration(+,+).
elaboration(X,X).
elaboration(Old,New) :-
	(bagof(X,fn_in_term(X,Old),Oldlist); Oldlist=[]),!,
	(bagof(Y,fn_in_term(Y,New),Newlist); Newlist=[]),!,
	length(Oldlist,Oldnum), length(Newlist,Newnum),	Oldnum =< Newnum,!,
	worse_than(Old,New),!.

:- mode fn_in_term(?,+).
fn_in_term(F,[F|_]) :- atomic(F).
fn_in_term(F,[_|Args]) :- fn_in_args(F,Args).

:- mode fn_in_args(?,+).
fn_in_args(F,[Arg|_]) :- fn_in_term(F,Arg).
fn_in_args(F,[_|Args]) :- fn_in_args(F,Args).

:- mode worse_than(+,+).
worse_than(Old,New) :- variable(Old), Old\==New, var_in_term(Old,New),!.

worse_than(Old,New) :- \+variable(Old), \+variable(New),
	worse_than1(Old,New),!.

worse_than1([F1|Args1],[F2|Args2]) :- F1 \== F2,
   subterm_of(Subnew,[F2|Args2]),
  ([F1|Args1] = Subnew; worse_than([F1|Args1],Subnew)),!.

:- mode subterm_of(?,+).
subterm_of(X,[_|Args]) :- one_of(X,Args).
subterm_of(X,[_|Args]) :- subterm_of_args(X,Args).

:- mode subterm_of_args(?,+).
subterm_of_args(X,[Top|_]) :- subterm_of(X,Top).
subterm_of_args(X,[_|Rest]) :- subterm_of_args(X,Rest).

worse_than1([F|OldArgs],[F|NewArgs]) :-
	some_arg_worse(OldArgs,NewArgs),
	non_var_or_exp(OldArgs,NewArgs),
	\+some_arg_worse(NewArgs,OldArgs),!.

:- public some_arg_worse/2.
:- mode some_arg_worse(+,+).
some_arg_worse([OldArg|_],[NewArg|_]) :- worse_than(OldArg,NewArg).
some_arg_worse([_|OldArgs],[_|NewArgs]) :- some_arg_worse(OldArgs,NewArgs).

:- mode non_var_or_exp(+,+).
non_var_or_exp([OldArg|OldArgs],[NewArg|NewArgs]) :-
	((\+var_or_exp(NewArg), true); var_or_exp(OldArg)),!,
	non_var_or_exp(OldArgs,NewArgs),!.
non_var_or_exp([],[]).

:- public var_or_exp/1.
:- mode var_or_exp(+).
var_or_exp(Term) :- (variable(Term) ; explicit_value(Term)),!.

:- mode expl_rewrite_lemma(+,+,+).
expl_rewrite_lemma(_,_,_) :- (dumbly; \+expl_rewrite),!.
expl_rewrite_lemma(Type,Name,Lev) :-
	I is Lev*3, tab(I), write('rewriting with the '),
	write(Type),write(': '), wwrite(Name,reverse),nl,!.

% EOF rewrite.pl
