% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public prove/1.
:- mode	prove(+).
prove(Path:Formula) :-
	(dumbly; defun_loaded; (nl,wwrite('Proving...'),nl)),
	abolish(goal_ID,1),
	abolish(pool,2),
	abolish(var_seed,1),
	abolish(used_variable,1),
	((setof(V,var_in_term(V,Formula),Vs),
	  setof(W,(one_of(W,Vs),assertz(used_variable(W))),_));
	 true),
	formula_to_clauses(Formula,Clauses),
	pool_(simplification,[#(0=Path)]:Clauses,z),!.

:- mode new_goal(-).
new_goal(N) :- (retract(goal_ID(M)); M=0),
	N is M+1, asserta(goal_ID(N)),!.

:- dynamic save_continue/0.
:- public prove_short/1.
:- mode	prove_short(+).
prove_short(Path:Formula) :-
	( continue -> assert(save_continue) ; true ),
	abolish(continue,0), assert(continue),
	prove(Path:Formula),!,qq,!,
	( save_continue -> assert(continue) ; abolish(continue,0) ),!.

:- public error/1.
:- mode error(+).
error(X) :- nl,wwrite('Error! ---> '),wwrite(X),nl,!.

:- public pool_/3.
:- mode pool_(+,+,+).
pool_(_,_:t,_) :- defun_loaded,!.
%pool_(_,_:t,_) :- nl,wwrite(trivial),nl,!.
pool_(_,_:t,_) :- !.
pool_(P,Path:[t|Cs],AZ) :- pool_(P,Path:Cs,AZ),!.
pool_(P,Path:[C1|Cs],AZ) :-
	((Cs=[],!,
%	  (dumbly;
%	   (nl,wwrite('Poured a conjecture into the '),
%	    wwrite(P),wwrite('-pool.'),nl)),
	  pool1_(P,Path:C1,AZ)) ;
%	 (length([C1|Cs],N),
%	  (dumbly;
%	   (nl,wwrite('Poured '),wwrite(N),wwrite(' conjectures into the '),
%	    wwrite(P),wwrite('-pool.'),nl)),
	  pooln_(P,Path:[C1|Cs],1,AZ)),!.

:- mode pool1_(+,+,+).
pool1_(_,_:t,_) :- (defun_loaded; (nl,wwrite(trivial),nl)),!.
pool1_(P,Path:Clause,a) :- (Path=[#(N)|Pa]; (new_goal(N),Pa=Path)),
	asserta(pool(P,[#(N)|Pa]:Clause)),!,
	nl,wwrite('Conjecture ',bold),pp_path(11,[#(N)]),nl,
	nl,wwrite('    has been placed on the top of the '),
	wwrite(P),wwrite('-pool.'),nl,!.
pool1_(P,Path:Clause,z) :- (Path=[#(N)|Pa]; (new_goal(N),Pa=Path)),
	assertz(pool(P,[#(N)|Pa]:Clause)),!,
	nl,wwrite('Conjecture ',bold),pp_path(11,[#(N)]),nl,
	nl,wwrite('    has been placed at the bottom of the '),
	wwrite(P),wwrite('-pool.'),nl,!.

:- mode pooln_(+,+,+,+).
pooln_(P,[M|Path]:[C1|Cs],N,AZ) :-
	pool1_(P,[M-N|Path]:C1,AZ),
	N1 is N+1,
	pooln_(P,[M|Path]:Cs,N1,AZ),!.
pooln_(_,_:[],_,_).

:- mode add_(+,+).
add_(Type,NL=B) :- NL=..[Name|Labels],mtos(B,Body),
	( dumbly ;
	  ( nl,pp_(Type,Name,[],Body),
	    ( Type\== (theorem) ; (nl,wwrite('    has been proved.'),nl)))),!,
	add_(Type,Name,Labels,Body),!.

:- mode	add_(+,+,+,+).
add_(Type,Name,[Label|Labels],Body) :-
	add_(Type,Name,Label,Body),
	add_(Type,Name,Labels,Body),!.
add_(_,_,[],_).
add_(Type,Name,rewrite,Body) :-
	formulate_rewrite_lemma(Body,L,R,Hyp,P),
	asserta(rewrite_lemma(L,R,Hyp,P,Type,Name)),
	( dumbly ;
	  ( %nl,pp_(Type,Name,rewrite,Body),
	    nl,wwrite('    is registered as a rewrite lemma.'),nl)),!.
add_(Type,Name,induction,Body) :-
	formulate_induction_lemma(Body,B,Hyp),
	asserta(induction_lemma(B,Hyp,Type,Name)),
	( dumbly ;
	  ( %nl,pp_(Type,Name,induction,Body),
	    nl,wwrite('    is registered as an induction lemma.'),nl)),!.
add_(Type,Name,elimination,Body) :-
	(setof(V,var_in_term(V,Body),Vars); Vars=[]),
	p_vars(Vars,Body,_,P_Body),
	assertz(elimination_lemma(Type,Name,P_Body)),
	( dumbly ;
	  ( %nl,pp_(Type,Name,Label,Body),
	    nl,wwrite('    is registered as an elimination lemma.'),nl)),!.
add_(Type,Name,generalize,Body) :-
	(setof(V,var_in_term(V,Body),Vars); Vars=[]),
	p_vars(Vars,Body,_,P_Body),
	assertz(generalization_lemma(Type,Name,P_Body)),
	( dumbly ;
	  ( %nl,pp_(Type,Name,Label,Body),
	    nl,wwrite('    is registered as a generalization lemma.'),nl)),!.
add_(_,_,_,_) :- error('Invalid lemma.').

:- mode formulate_rewrite_lemma(+,-,-,-,-).
formulate_rewrite_lemma(Body,P_L,P_R,P_H,P) :-
	(setof(V,var_in_term(V,Body),Vars); Vars=[]),
	((Body=[implies,Hyp,Conc], formula_to_clauses(Hyp,H));
	 (Body=Conc,H=t)),
	((Conc=[equal,L,R],permutative(L,R,P));
	 (Conc=[not,L],R=f,P=no);
	 (Conc=L,R=t,P=no)),
	p_vars(Vars,[L,R,H],_,PLRH),
	PLRH=[P_L,P_R,P_H],!.

:- mode formulate_induction_lemma(+,-,-).
formulate_induction_lemma(Body,P_Conc,P_H) :-
	(setof(V,var_in_term(V,Body),Vars); Vars=[]),
	((Body=[implies,Hyp,Conc], formula_to_clauses(Hyp,H));
	 (Body=Conc,H=[])),
	p_vars(Vars,[Conc,H],_,PCH),
	PCH=[P_Conc,P_H],!.

:- mode permutative(+,+,-).
permutative(L,R,permutative) :- variable(L),variable(R),!.
permutative([F|A1],[F|A2],permutative) :- permutative1(A1,A2),!.
permutative(_,_,no).

:- mode permutative1(+,+).
permutative1([A1|A],[B1|B]) :- permutative(A1,B1,P),!,P=permutative,!,
	permutative1(A,B),!.
permutative1([],[]).

:- mode pp_(+,+).
pp_(Type,NL=B) :- NL=..[Name|Labels],mtos(B,Body),
	pp_(Type,Name,Labels,Body),!.

:- public pp_/4.
:- mode pp_(+,+,+,+).
pp_(Type,Name,Labels,Body) :-
	((Type = (axiom),   wwrite('Axiom ',bold)) ;
	 (Type = (lemma),   wwrite('Lemma ',bold)) ;
	 (Type = (theorem), wwrite('Theorem ',bold)) ),
	wwrite(Name),
	(Labels=[];
	 (atomic(Labels),wwrite(' ('),wwrite(Labels),wwrite(')'));
	 (wwrite(' '),Lab=..[''|Labels],wwrite(Lab))),nl,
	nl,tab(8),pp(8,Body),nl,!.

:- public pp_clause/2.
:- mode pp_clause(+,+).
pp_clause(_,_) :- dumbly,!.
pp_clause(Path:Clause,Mess) :-
	clause_to_implies(Clause,Implies),
	nl,wwrite('Conjecture ',bold),pp_path(11,Path),nl,
	nl,tab(8),pp(8,Implies),nl,
	(Mess=''; (nl,wwrite(Mess),nl)),!.

:- mode pp_path(+,+).
pp_path(I,[Anc|Dec]) :- pp_node(Anc),!,
	(Dec=[]; (nl,tab(I),pp_path(I,Dec))),!.
pp_path(_,P) :- pp_node(P),!.

:- mode pp_node(+).
pp_node(s(ID)) :- wwrite('simplified '),wwrite(ID),!.
pp_node(c(X,ID)) :- wwrite('eliminating destructor(s) '),wwrite(X),
	wwrite(' base case for '),wwrite(ID),!.
pp_node(d(X,ID)) :- wwrite('destructor(s) replaced by '),wwrite(X),
	wwrite(' in '),wwrite(ID),!.
pp_node(e(ID)) :- wwrite('used an equality in '),wwrite(ID),!.
pp_node(g(X,ID)) :- wwrite('generalized '),wwrite(ID),wwrite(' with '),wwrite(X),!.
pp_node(l(ID)) :- wwrite('irrelevance(s) eliminated in '),wwrite(ID),!.
pp_node(b(ID)-N) :- wwrite('base case-'),wwrite(N),wwrite(' for '),wwrite(ID),!.
pp_node(b(ID)) :- wwrite('base case for '),wwrite(ID),!.
pp_node(i(ID)-N) :- wwrite('induction step-'),wwrite(N),
	wwrite(' for '),wwrite(ID),!.
pp_node(i(ID)) :- wwrite('induction step for '),wwrite(ID),!.
pp_node(X-N) :- pp_node(X), wwrite(' -'), wwrite(N),!.
pp_node(X) :- wwrite(X),!.

pp_pool :-
	(setof(P:C,(pool(simplification,P:C),
		pp_clause(['waiting simplification'|P]:C,'')),_); true),
	(setof(P:C,(pool(heuristics,P:C),
		pp_clause(['waiting heuristic rewrite'|P]:C,'')),_); true),
	(setof(P:C,(pool(induction,P:C),
		pp_clause(['waiting induction'|P]:C,'')),_); true),
	(setof(P:C,(pool(fail,P:C),
		pp_clause(['failed'|P]:C,'')),_); true),!.

% EOF prove.pl
