% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public generalize/1.
:- mode generalize(+).
generalize([ID|Path]:Clause) :- !,
%	nl,wwrite('Generalizing...'),nl,!,
	induction_step(Path),
	abolish(common,1),
	setof(T,(common_term(T,Clause),
		 generalizable(T,Clause),
		 assertz(common(T))),_),
	minimal_common_subterms,
	setof(GT,common(GT),GTM),
	abolish(common,1),
	assume_false(Clause,[],_,_,_,[],_,[],Context),
	perform_generalization(Clause,Context,GTM,Vars,NCl),
	expl_gen(GTM,Vars),
	pool_(simplification,[g(Vars,ID)|Path]:NCl,a),!.

:- public common_term/2.
:- mode common_term(?,+).
common_term(T,Clause) :-
	(common_term_lit(T,Clause) ; common_term_equ(T,Clause)).

:- mode common_term_lit(?,+).
common_term_lit(T,[L1|Clause]) :- one_of(L2,Clause),
	call_in_term(T,L1), call_in_term(T,L2).
common_term_lit(T,[_|Clause]) :- common_term_lit(T,Clause).

:- mode common_term_equ(?,+).
common_term_equ(T,Clause) :-
	one_of(L,Clause), (L=[equal,A,B];L=[not,[equal,A,B]]),
	call_in_term(T,A), call_in_term(T,B).

:- public generalizable/2.
:- mode generalizable(+,+).
generalizable(X,_) :-
	\+explicit_value_template(X),
	\+X=[equal,_,_],
	\+accessor(X),!.

minimal_common_subterms :- common(T1), common(T2), T1\==T2,
	call_in_term(T1,T2), retract(common(T2)),
	minimal_common_subterms,!.
minimal_common_subterms.

:- mode perform_generalization(+,+,+,-,-).
perform_generalization(Clause,Context,GTM,Vars,C3) :-
	(setof(R,generalization_restriction(Context,GTM,R),Rs);
	 Rs=[]),
	length(GTM,N),
	gen_vars(N,Vars),
	append(Rs,Clause,C1),
	gen_subst(C1,GTM,Vars,C2),
	formula_to_clauses([or|C2],C3),!.

:- public generalization_restriction/3.
:- mode generalization_restriction(+,+,-).
generalization_restriction(Context,GTM,B) :-
	one_of(T,GTM),
	((generalization_lemma(_,_,X),
	  call_in_term(T,X),
	  B=[not,X]);
	 (type_set(T,TS,Context),
	  bit_place(R,TS),
	  B=[not,[R,T]])).

:- mode gen_subst(+,+,+,-).
gen_subst([L|Ls],Ts,Vs,[L1|Ls1]) :-
	gen_subst1(L,Ts,Vs,L1),	gen_subst(Ls,Ts,Vs,Ls1),!.
gen_subst([],_,_,[]).

:- mode gen_subst1(+,+,+,-).
gen_subst1(L,[T1|Ts],[V1|Vs],L2) :-
	gen_subst2(L,T1,V1,L1),	gen_subst1(L1,Ts,Vs,L2),!.
gen_subst1(L,[],[],L).

:- mode gen_subst2(+,+,+,-).
gen_subst2(T,T,V,V).
gen_subst2([F|Args],T,V,[F|Args1]) :- gen_subst2s(Args,T,V,Args1),!.
gen_subst2(T,_,_,T).

:- mode gen_subst2s(+,+,+,-).
gen_subst2s([A|As],T,V,[A1|As1]) :-
	gen_subst2(A,T,V,A1), gen_subst2s(As,T,V,As1),!.
gen_subst2s([],_,_,[]).

:- mode expl_gen(+,+).
expl_gen(_,_) :- dumbly,!.
expl_gen(Terms,Vars) :-
	nl,wwrite('We generalize the conjecture by replacing'),nl,
	nl,tab(8),((Terms=[T],pp(8,T)); pp(8,[''|Terms])),
	nl,wwrite('    by'),
	nl,tab(8),((Vars=[V],wwrite(V,reverse)); pp(8,[''|Vars])),nl,!.

% EOF gen.pl
