% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- mode expand(+,+,-,+,+,-,+,-,+,-).

expand(_,[and|P],New,_,U,U,V,V,W,W) :- !,if_expr([and|P],New),!.
expand(_,[or|P],New,_,U,U,V,V,W,W) :- !,if_expr([or|P],New),!.
expand(_,[implies|P],New,_,U,U,V,V,W,W) :- !,if_expr([implies|P],New),!.

expand(_,X,New,[TS_alist,N_list,_,Lev,H],U,U1,V,V1,W,W1) :-
	(nonrecursive(X); (measured_subset(X,MS),explicit_values(MS))),
	definition(X,Body),!,expl_expand(X,Lev),!,Lev1 is Lev+1,!,
	rewrite(Body,New,[TS_alist,N_list,[],Lev1,H],
		U,U1,V,V1,[e(Lev,X)|W],W1),!.

expand(_,X,Y,_,U,U1,V,[X|V],W,W) :-
	X=[F|Args], length(Args,N), member(F/N,U),!,X=Y,!,U=U1,!.

expand(_,X,Y,I,U,U1,V,V1,W,W1) :- rewrite_val(X,Y,I,U,U1,V,V1,W,W1),!.
expand(_,X,X,[_,_,L,_],U,U,V,[X|V],W,W) :- expand_depth(D),L>D,!.

%expand(O,X,New,[TS_alist,N_list,_,Lev,H],U,U,V,V1,W,W1) :-
expand(_,X,New,[TS_alist,N_list,_,Lev,H],U,U,V,V1,W,W1) :-
	definition(X,Body), expl_expand(X,Lev),
	X=[F|Args], length(Args,N), Lev1 is Lev+1,
	rewrite(Body,New,[TS_alist,N_list,[],Lev1,H],
		[F/N|U],_,V,V1,[e(Lev,X)|W],W1),
	recursive_calls(F/N,New,Fs),
	rewrite_env(Path:Terms),
%	better(Fs,O,Path:Terms),!.
	better(Fs,X,Path:Terms),!.

expand(_,X,X,_,U,U,V,[X|V],W,W).

:- mode better(+,+,+).
better([[_|Args]|Fs],F,Path:Ts) :-
	no_new_terms(Args,Ts),!,better(Fs,F,Path:Ts),!.
better([[F|A1]|Fs],[F|A2],Path:Ts) :-
	more_explicit_values(A1,A2,0,0),!,better(Fs,[F|A2],Path:Ts),!.
better([[F|A1]|Fs],[F|A2],Path:Ts) :-
	proper_induction_step(Path),
	make_pairs(A1,A2,P), measured_subset([F|P],P1),	less_complex(P1,0,0),!,
	better(Fs,[F|A2],Path:Ts),!.
better([],_,_).

:- mode proper_induction_step(+).
proper_induction_step([i-_|_]).
proper_induction_step([i|_]).

:- mode no_new_terms(+,+).
no_new_terms([A|Args],Terms) :- (variable(A); member(A,Terms)),!,
	no_new_terms(Args,Terms),!.
no_new_terms([],_).

:- mode more_explicit_values(+,+,+,+).
more_explicit_values([A|As],[B|Bs],M,N) :-
	((explicit_value(A), M1 is M+1); M1 is M),!,
	((explicit_value(B), N1 is N+1); N1 is N),!,
	more_explicit_values(As,Bs,M1,N1),!.
more_explicit_values([],[],M,N) :- M>N,!.

:- mode make_pairs(+,+,-).
make_pairs([A|As],[B|Bs],[A-B|P]) :- make_pairs(As,Bs,P),!.
make_pairs([],[],[]).

:- mode less_complex(+,+,+).
less_complex([A-B|P],I1,I2) :- complexity(A,CA), complexity(B,CB),
	I1n is I1+CA, I2n is I2+CB, less_complex(P,I1n,I2n),!.
less_complex([],C1,C2) :- C1<C2,!.

:- mode complexity(+,-).
complexity([if,_,X,Y],C) :- complexity(X,XC), complexity(Y,YC),
	((XC>YC, C is XC); C is YC),!.
complexity([_|Args],C) :- complexity_args(Args,0,CA), C is CA+1,!.
complexity(_,0).

:- mode complexity_args(+,+,-).
complexity_args([A|Args],I,O) :- complexity(A,CA), I1 is I+CA,
	complexity_args(Args,I1,O),!.
complexity_args([],C,C).

:- mode expl_expand(+,+).
expl_expand(_,_) :- (dumbly; \+expl_expand),!.
expl_expand(X,Lev) :-
	I is Lev*3, tab(I), write('expanding '), I1 is I+10, pp(I1,X),nl,!.

% EOF expand.pl
