% (C)1992 Institute for New Generation Computer Technology
% ۤ¾COPYRIGHTե򻲾ȤƲ
% (Read COPYRIGHT for detailed information.)

:- public equ/1.
:- mode equ(+).
equ([ID|Path]:Clause) :-
%	nl,wwrite('Using Equalities...'),nl,!,
	((one_of([not,[equal,S,T]],Clause),
	  cross_fertilize(Path:Clause,S,T,Cls));
	 (one_of([not,[equal,S,T]],Clause),
	  uniform_subst(Clause,S,T,Cls))),
	pool_(simplification,[e(ID)|Path]:[Cls],a),!.

:- mode cross_fertilize(+,+,+,-).
cross_fertilize(Path:Clause,S,T,Cls) :-
	induction_step(Path),!,
	setof([Sid,X,C],cross_fertilize0(Clause,S,T,Sid,X,C),L),
	decide_side(L,Side,Cls),
	expl_fertilize(S,T,Side),!.

:- mode decide_side(+,-,-).
decide_side([[Side,_,Cls]],Side,Cls).
decide_side([[Sid1,A,Cls1],[Sid2,B,Cls2]],Side,Cls) :-
	((less_complex([A-B],0,0), Side=Sid1, Cls=Cls1);
	 (Side=Sid2, Cls=Cls2)).

:- mode induction_step(+).
induction_step([b(_)-_|_]) :-!,fail.
induction_step([b(_)|_]) :-!,fail.
induction_step([i(_)-_|_]).
induction_step([i(_)|_]).
induction_step([_|Path]) :- induction_step(Path).

:- public cross_fertilize0/6.
:- mode cross_fertilize0(+,+,+,-,-,-).
cross_fertilize0(Clause,S,T,Sid,X,C) :-
	cross_fertilize1(Clause,S,T,Sid,C),
	((Sid=right,\+explicit_value(S),\+explicit_value_template(T),X=S);
	 (Sid=left, \+explicit_value(T),\+explicit_value_template(S),X=T)).

:- mode cross_fertilize1(+,+,+,?,-).
cross_fertilize1([[not,[equal|U]]|Ls],S,T,Side,Ls2) :- !,
	cross_fertilize1(Ls,S,T,Side,Ls1),
	((U=[S,T], Ls2=Ls1);
	 (U\==[S,T],
	  ((Side == right,
	    substitute_term_nonfail(S,T,[equal|U],U1)) ;
	   (Side == left,
	    substitute_term_nonfail(T,S,[equal|U],U1))),
	  Ls2=[[not,U1]|Ls1])).
cross_fertilize1([[equal,U,V]|Ls],S,T,Side,[[equal,U1,V1]|Ls1]) :- !,
	((substitute_term(S,T,V,V1), U1=U, Side=right);
	 (substitute_term(T,S,U,U1), V1=V, Side=left);
	 (U1=U, V1=V)),
	cross_fertilize1(Ls,S,T,Side,Ls1).
cross_fertilize1([L|L1],S,T,Side,[L|L2]) :-
	cross_fertilize1(L1,S,T,Side,L2).
cross_fertilize1([],_,_,Side,[]) :- nonvar(Side).

:- mode substitute_term(+,+,+,-).
substitute_term(New,Old,Old,New).
substitute_term(New,Old,[F|Old_args],[F|New_args]) :-
	substitute_terms(New,Old,Old_args,New_args),!,
	Old_args\==New_args,!.

:- mode substitute_terms(+,+,+,-).
substitute_terms(New,Old,[O1|O],[N1|N]) :-
	substitute_term_nonfail(New,Old,O1,N1),
	substitute_terms(New,Old,O,N),!.
substitute_terms(_,_,[],[]).

:- mode substitute_term_nonfail(+,+,+,-).
substitute_term_nonfail(New,Old,Old,New).
substitute_term_nonfail(New,Old,[F|Old_args],[F|New_args]) :-
	substitute_terms(New,Old,Old_args,New_args),!.
substitute_term_nonfail(_,_,X,X).

:- mode uniform_subst(+,+,+,-).
uniform_subst(Ls,S,T,Ls1) :-
	((\+explicit_value_template(T),Subst=(S->T),
	  uniform_subst1(Ls,Subst,Ls1));
	 (\+explicit_value_template(S),Subst=(T->S),
	  uniform_subst1(Ls,Subst,Ls1))),
	Ls\==Ls1,
	expl_uniform_subst(Subst),!.

:- mode uniform_subst1(+,+,-).
uniform_subst1([L|Ls],(S->T),[L|Ls1]) :-
	(L=[not,[equal,S,T]];L=[not,[equal,T,S]]),
	uniform_subst1(Ls,(S->T),Ls1),!.
uniform_subst1([L|Ls],(S->T),[L1|Ls1]) :-
	substitute_term(S,T,L,L1),
	uniform_subst1(Ls,(S->T),Ls1),!.
uniform_subst1([],_,[]).

:- mode expl_uniform_subst(+).
expl_uniform_subst(_) :- dumbly,!.
expl_uniform_subst((S->T)) :-
	nl,wwrite('We now use the above equality hypothesis'),
	wwrite(' by uniformly substituting'),nl,
	nl,tab(8),pp(8,S),
	nl,wwrite('    for'),
	nl,tab(8),pp(8,T),nl,!.

:- mode expl_fertilize(+,+,+).
expl_fertilize(_,_,_) :- dumbly,!.
expl_fertilize(S,T,Side) :-
	nl,wwrite('We use the above equality hypothesis'),
	wwrite(' by cross-fertilizing'),nl,
	((Side==left,SS=T,TT=S);(Side==right,SS=S,TT=T)),
	nl,tab(8),pp(8,SS),
	nl,wwrite('    for'),
	nl,tab(8),pp(8,TT),nl,
	nl,wwrite('    and throwing away the equality.'),nl,!.

% EOF equ.pl
