/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*
 *	search.c
 *			(C) Copyright 1991, All rights reserved by ICOT
 */

#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include "define.h"
#include "config.h"
#include "wchar.h"
#include "kio.h"
#include "find.h"

static int tty;

/*
 *	write info
 */

void write_info(line_buf, count, inn, num, poses, yomi)
    w_char_t *line_buf;
    int count, *inn, *num;
    short poses[][S_WIDTH];
    w_char_t yomi[][S_WIDTH][S_STRL];
{
    register int i, cnt, syn;
    static w_char_t wbuf[MAX_MIDASIGO];

    if (!tty)
	write_line(stdout, line_buf);
    for (cnt = 0; cnt < count; cnt++) {
	for (i = 0; i < num[cnt]; i++)
	    wbuf[i] = line_buf[i];
	wbuf[i] = 0;
	(void)fprintf(stdout, tty ? "midasigo = ": "    ");
	write_line(stdout, wbuf);
	(void)putchar('\n');
	for (syn = 0; syn < inn[cnt]; syn++) {
	    (void)fprintf(stdout,
		    tty ? "hinsi = %04x : yomi = ": "    %04x ",
		    poses[cnt][syn]);
	    write_line(stdout, yomi[cnt][syn]);
	    (void)putchar('\n');
	}
    }
}

void delete_newline(buf)
    w_char_t *buf;
{
    while (*buf != NULL) {
	if (*buf == '\n') {
	    *buf = NULL;
	    break;
	}
	buf++;
    }
}
	      
/*
 *	initialize routines
 */

void create_file(name, ext, fp)
    char *name, *ext;
    FILE **fp;
{
    char file[FILE_NAME_SIZE];

    (void)strcpy(file, name);
    (void)strcat(file, ext);

    if ((*fp = fopen(file, "r")) == NULL) {
	(void)fprintf(stderr, "can't open file: %s\n", file);
	exit(1);
    }
}

void initialize(argc, argv)
    int argc;
    char **argv;
{
    char *input_file;

    if (argc != 2) {
	(void)fprintf(stderr, "Usage: search file_name\n");
	exit(1);
    }
    input_file = argv[1];
    create_file(input_file, ".rot", &root_fp);
    create_file(input_file, ".pat", &path_fp);
    create_file(input_file, ".inf", &info_fp);
}

void terminate()
{
    (void)fclose(root_fp);
    (void)fclose(path_fp);
    (void)fclose(info_fp);
}

/*
 *	main
 */

void main(argc, argv)
    int argc;
    char **argv;
{
    static w_char_t line_buf[MAX_LINE];
    static int count, inn[S_DEPTH], num[S_DEPTH];
    static short poses[S_DEPTH][S_WIDTH];
    static w_char_t yomi[S_DEPTH][S_WIDTH][S_STRL];

    initialize(argc, argv);
    tty = isatty(0);
    for (;;) {
	if (tty)
	    (void)fprintf(stderr, "search> ");
	if (read_line(stdin, line_buf) == 0) {
	    (void)fprintf(stderr, "exit.\n");
	    break;
	}
	delete_newline(line_buf);
	searchw(line_buf, &count, inn, num, poses, yomi);
	if (count > 0)
	    write_info(line_buf, count, inn, num, poses, yomi);
	else
	    (void)fprintf(stdout, "search failed.\n");
    }
    terminate();
}
