% (C)1992 Institute for New Generation Computer Technology %
% $BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F$/$@$5$$(B
% (Read COPYRIGHT for detailed information.)

% 1992.7 Check and refine every program for IFS (ICOT Free
% Software) release.

add_operator(::,xfx,1200).

use_package(fts).

macro_bank qxt_macro_bank has

    A =< B => _ :- !,fail ;
    A = B => _ :- !,fail ;

end.

%%%Pseudo interpreter for QXT.

macro_bank qxt_internal has

nature qxt_macro_bank;

% IO macros.
    print(X) => 
        :putt(standard#output,X);
    nl => 
        :putf(standard#output,"\n");
    putf(X,Y) => 
        :putf(standard#output,X,Y);
    read(X) => 
        :gett(standard#input,X);


% QXT macros.

    assert(M,O) =>
        :assert(#qxt##qxt,M,O);
    basic_object(O,B) =>
        :basic_object(#qxt##qxt,O,B);
    get_less_than_mod(M,L,ML) =>
        :get_less_than_mod(#qxt##qxt,M,L,ML);
    head(O,H) =>
        :head(#qxt##qxt,O,H);
    instance(O,H) => 
        :instance(#qxt##qxt,O,H);
    labels(O,L) =>
        :labels(#qxt##qxt,O,L);
    less_than_mod(M1,M2) =>
        :less_than_mod(#qxt##qxt,M1,M2);
    link(M1,M2) =>
        :link(#qxt##qxt,M1,M2);
    make_module(Module,ModId) =>
        :make_module(#qxt##qxt,Module,ModId);
    make_module(Module) =>
        :make_module(#qxt##qxt,Module,_);
    merge(O1,O2,O3) =>
        :merge(#qxt##qxt,O1,O2,O3);
    module(Module) =>
        :module(#qxt##qxt,Module);
    name(Expr,Object) =>
        :name(#qxt##name_table,Expr,Object);
    new_expr(Expr) =>
        :new_expr(#qxt##name_table,Expr);
    of(O,L,V) =>
        :of(#qxt##qxt,O,L,V);
    support(O,C) =>
        :support(#qxt##qxt,O,C);
    support(M,Q,C) =>
        :support(#qxt##qxt,M,Q,C);
    support_all(M,Q,C,OL) =>
        :support_all(#qxt##qxt,M,Q,C,OL);
    qxt_unify(O1,O2) =>
        :unify(#qxt##qxt,O1,O2);
    unlink(M1,M2) =>
        :unlink(#qxt##qxt,M1,M2);
    init_qxt =>
        :initialize(#qxt##qxt);
    translate(File) =>
        :translate(#qxt##qxt,File);
    load_order(File) =>
        :load_order(#qxt##basic_object,File);

end.

class instance_list with_macro fts##qxt_internal has

:instance_list(C,L,LL):-
    instance_list(L,LL);

local 

instance_list([],[]):-!;
instance_list([E|L],[EE|LL]):-
    instance(E,EE),
    instance_list(L,LL);

end.


macro_bank qxt_interpreter has

nature qxt_macro_bank;

% IO macros.
    print(X) => 
        :putt(standard#output,X);
    nl => 
        :putf(standard#output,"\n");
    putf(X,Y) => 
        :putf(standard#output,X,Y);
    read(X) => 
        :gett(standard#input,X);


% QXT macros.

    assert(M,O) =>
        (:assert(#qxt##qxt,M,O),!;
         :make_module(#qxt##qxt,M,_),
         :assert(#qxt##qxt,M,O));
    (M::O) =>
        (:assert(#qxt##qxt,M,O),!;
         :make_module(#qxt##qxt,M,_),
         :assert(#qxt##qxt,M,O));
    basic_object(O,B) =>
        :basic_object(#qxt##qxt,O,B);
    get_less_than_mod(M,L,ML) =>
        :get_less_than_mod(#qxt##qxt,M,L,ML);
    head(O,H) =>
        :head(#qxt##qxt,O,H);
    instance(O,H) => 
        :instance(#qxt##qxt,O,H);
    labels(O,L) =>
        :labels(#qxt##qxt,O,LL),
        instance_list(LL,L);
    less_than_mod(M1,M2) =>
        :less_than_mod(#qxt##qxt,M1,M2);
    link(M1,M2) =>
        :link(#qxt##qxt,M1,M2);
    make_module(Module,ModId) =>
        :make_module(#qxt##qxt,Module,ModId);
    make_module(Module) =>
        :make_module(#qxt##qxt,Module,_);
    merge(O1,O2,O3) =>
        :merge(#qxt##qxt,O1,O2,OO3),
        instance(OO3,O3);
    module(Module) =>
        :module(#qxt##qxt,Module);
    name(Expr,Object) =>
        :name(#qxt##name_table,Expr,Object);
    new_expr(Expr) =>
        :new_expr(#qxt##name_table,Expr);
    of(O,L,V) =>
        :of(#qxt##qxt,O,L,VV),
        instance(VV,V);
    support(O,C) =>
        :support(#qxt##qxt,O,CC),
        instance(CC,C);
    support(M,Q,C) =>
        :support(#qxt##qxt,M,Q,CC),
        instance(CC,C);
    support_all(M,Q,C,OL) =>
        :support_all(#qxt##qxt,M,Q,C,OLL),
        instance_list(OLL,OL);
    qxt_unify(O1,O2) =>
        :unify(#qxt##qxt,O1,O2);
    unlink(M1,M2) =>
        :unlink(#qxt##qxt,M1,M2);
    init_qxt =>
        :initialize(#qxt##qxt);
    translate(File) =>
        :translate(#qxt##qxt,File);
    load_order(File) =>
        :load_order(#qxt##basic_object,File);
    instance_list(L,LL) =>
        :instance_list(#qxt##instance_list,L,LL);

end.

macro_bank cil_qxt_macro_bank has

% For cil.
    A / B => _ :- !,fail;

% For QXT.
    A =< B => _ :- !,fail ;
    A = B => _ :- !,fail ;

end.


macro_bank cil_qxt_internal has

nature cil_qxt_macro_bank,
       cil_macro,
       qxt_internal;

end.

