% (C) 1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information)

%
% File name : prolog.spec
%
% (01) 91. 1.25 by T.S. from io module
% (02) 91. 2. 4 by T.S. change self slot access
% (03) 91. 2. 6 by T.S. genSym/2 bug forget defining slot
% (04) 91. 2.13 by S.K. define package

%
% PROLOG environment
%   specifies esp_call,kl0 as environments
%
:-define prolog.

:-define prolog/builtin.
:-environment esp_call.

% execution time
:-view statistics/2.
statistics(runtime,Time):-!,
    Time = [_,Runtime],
    unbound(Runtime),
    get_watch(Watch),
    :stop(Watch),
    :show(Watch, To),
    :get_count(To, Current_time),
    Previous_time =  !previous_time,
    Runtime = Current_time - Previous_time,
    !previous_time := Current_time,
    :start(Watch).
statistics(_,_).

:-attribute stop_watch, previous_time.
get_watch(Watch):-
    Watch = !stop_watch,
    object(Watch, _, _),!.
get_watch(Watch):-
    :create(#stop_watch, Watch),
    !stop_watch := Watch,
    :reset(Watch),
    :start(Watch),
    !previous_time := 0.

%
% variable check
%
:-view var/1.
var(X):-unbound(X).

:-view nonvar/1.
nonvar(X):-bound(X).

%
% code-string conversion
%
:-view name/2.
name(A,L):-atom(A),!,
    :get_atom_token(#symbolizer, A, AL),
    AL = L.
name(I,L):-integer(I),!,
    :get_number_token(#symbolizer, I, IL),
    IL = L.
name(A,L):-unbound(A),
    ( :get_number(#symbolizer, A, L)
    ; :enter_atom(#symbolizer, A, L) ),!.


%
% negation
%
% In fact, \+/1 is expanded to kl0 not/1 in syntax.
% So this definition in builtin is a dummy.
:-view (\+)/1.
\+(_).

%
% unique symbol
%
:-view genSym/2.
genSym(Prefix, Symbol):-
    get_gensym_table(Table),
    get_prefix_number(Table, Prefix, Number),
    :get_atom_string(#symbolizer, Prefix, Prefix_string),
    :get_number_string(#symbolizer, Number, Number_string),
    :append(#string, [Prefix_string,Number_string], Atom_string),
    :enter_atom(#symbolizer, Atom, Atom_string),
    Symbol = Atom.

:-attribute gensym_table.
get_gensym_table(Table):-
    Table = !gensym_table,
    object(Table,_,_),!.
get_gensym_table(Table):-
    :create(#monogyny_hash_index, Table, 64),
    !gensym_table := Table.

get_prefix_number(Table, Prefix, Number):-
    :get_at(Table, Current, Prefix),!,
    Number is Current + 1,
    :put_at(Table, Number, Prefix).
get_prefix_number(Table, Prefix, Number):-
    Number = 1,
    :put_at(Table, Number, Prefix).

% syntax sugar
:-define prolog/syntax.
:-view syntax/3.
syntax( '\+'(X), not(X), true).

% operator
:-define prolog/operator.
:-view op/3.
op(900, fy, (\+)).