% (C) 1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information)

%
% File name : dcg.spec
%
% (01) 91. 1.25 by T.S. from V3 syntax sugar
% (02) 91. 1.30 by T.S. change suppressor from ` to $
% (03) 91. 2.13 by S.K. define package
% (04) 91. @.25 by S.K. change suppressor from $ to `

%
% DCG environment
%   specifies esp_call as an environment
:- define dcg.

%
% dcg syntax
%
:-define dcg/syntax.
:-environment esp_call.

:-view clause_syntax/2.
clause_syntax('-->'(H,T), Expanded):-one_clause(H,T,Expanded).


one_clause(Head0, Body0, (Head :- Body)) :- !,
    convert_head(Head0,Head,S0,S1),
    convert_body(Body0,Body,S0,S1,_).

convert_head((Head0,List),Head,S0,S2) :- !,
    construct_head(Head0,Head,S0,S1),
    concatinate(List,S1,S2).
convert_head(Head0,Head,S0,S1) :-
    construct_head(Head0,Head,S0,S1).

concatinate(X,_,_) :- unbound(X),!,fail.
concatinate([],S,S) :- !.
concatinate([X|T],[X|RR],S) :- !,
    concatinate(T,RR,S).

construct_head(X,_,_,_) :- unbound(X),!,fail.
construct_head(!,!,S,S) :- !.
construct_head(Head0,Head,S0,S1) :-
    (
        atom(Head0),!, new_stack_vector(Head,3),
        first(Head,Head0), Length = 1
    ;
        stack_vector(Head0,Length),
        new_stack_vector(Head,Length+2),
        subvector(Head,0,Length,Head0)
    ),
    vector_element(Head,Length,S0),
    vector_element(Head,Length+1,S1).

convert_body(X,_,_,_,_) :- unbound(X),!,fail.
convert_body((Body0,Tail),Body,S0,S,F) :- !,
    convert_body(Body0,One_body,S0,S1,F),
    convert_body(Tail,Body_tail,S1,S,F),
    neatify(One_body,Body_tail,Body).
convert_body((B0;B1),Out,S0,S,F0) :- !,
    convert_body(B0,B00,S00,S,F1),
    convert_body(B1,B11,S11,S,F2),
    ( unbound(F1),unbound(F2),!,
            S0 = S, Out = (B00;B11)     % optimize
    ;
      convert_or(F1,B00,BB0,S0,S00),
            convert_or(F2,B11,BB1,S0,S11),
            Out = (BB0;BB1), F0 = yes ).
convert_body([],true,S,S,_) :- !.
convert_body("",true,S,S,_) :- !.
convert_body({ExtraCond},ExtraCond,S,S,_) :- !.
convert_body(ExtraCond,EXTRACOND,S,S,_):-
    extra_conditions(ExtraCond,EXTRACOND),!.
convert_body(String,Out,S0,S,yes) :- string(String,_,_),!,
    :string_to_list(#symbolizer,List,String),
    convert_element(List,Out,S0,S).
convert_body(List,Result,S0,S,yes) :-  list(List),!,
    convert_element(List,Result,S0,S).
convert_body(One,Result,S0,S,yes) :-
    construct_head(One,Result,S0,S).

extra_conditions(X,Y):-
    stack_vector(X,N),N>0,first(X,F),stack_vector(F,_),!,
    extra_cond(0,N,X,Y).
extra_cond(N,N,_,true):-!.
extra_cond(M,N,X,Y):-
    Y=(E,R),
    T is M+1,
    vector_element(X,M,E),!,
    extra_cond(T,N,X,R).

neatify(true,One,One) :- !.
neatify(One,true,One) :- !.
neatify(One,Two,(One,Two)).

convert_or(F,B0,B1,S0,S1) :- atom(F),!,
    B0 = B1, S0 = S1.
convert_or(_,true, `(S0=S1),S0,S1) :- !.        %optimize 
convert_or(_,B0,(`(S0=S1),B0),S0,S1) :- !.

convert_element([_|X],_,_,_):-unbound(X),!,fail.
convert_element([One],true, [One|S],S) :- !.
convert_element([One|Rest],Tail, [One|S1],S) :-
    convert_element(Rest,Tail,S1,S).

%
% dcg operator
%
:-define dcg/operator.
:-view op/3.
op(1100, xfx, -->).
