#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <signal.h>

#include "cmd.h"


#ifndef	True
#define	True	1
#endif
#ifndef	False
#define	False	0
#endif

#define get_short(_nn, _pp)\
{\
    short _ss;\
\
    memcpy((char *)&_ss, (_pp), 2);\
    _nn = ntohs(_ss);\
}

extern void set_mark();
extern void put_string();
extern void create_menu_titles();
extern void add_menu_items();
extern void clear_menu_items();

static int port;
static int sock = -1;
static short buf_area[MAX_PACKET];
static char *recv_buf = (char *)buf_area;


int get_fd()
{
    return sock;
}

static void close_sock()
{
    if (sock >= 0) {
	close(sock);
	sock = -1;
    }
}

static void com_exit()
{
    close_sock();
    close(port);
    exit(3);
}

static int create_port()
{
    struct sockaddr_in server;
    int sp;
    int on = 1;
    int length;

    if ((sp = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("opening stream socket");
	exit(1);
    }

    if (setsockopt(sp, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on)) < 0) {
	perror("set socket option/reuseraddr");
	exit(1);
    }
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = 0;
    if (bind(sp, (struct sockaddr *)&server, sizeof(server)) < 0) {
	perror("binding stream socket");
	exit(1);
    }

    length = sizeof(server);
    if (getsockname(sp, (struct sockaddr *)&server, &length) < 0) {
	perror("getting socket name");
	exit(1);
    }
    printf("Socket port #%d\n", ntohs(server.sin_port));

    return sp;
}

void connect_to_pim()
{
    int pid;

    port = create_port();
    signal(SIGHUP, com_exit);
    signal(SIGINT, com_exit);
    signal(SIGQUIT, com_exit);
    signal(SIGKILL, com_exit);
    listen(port, 5);
/*
    for (;;) {
*/
	if ((sock = accept(port, (struct sockaddr *)0, (int *)0)) < 0) {
	    if (errno != EINTR) {
		perror("accept error");
		exit(1);
	    }
	    /*continue;*/
	    exit(1);
	} 
        close(port);
        return;
/*
	if ((pid = fork()) == 0) {
	    close(port);
	    return;
	}
	if (pid < 0)
	    perror("fork");
    }
*/
}

int send_to_pim(ack, text, size)
    int ack;
    char *text;
    int size;
{
    struct iovec iov[3];
    short cmd, len;
    int n;

#ifdef DEBUG
    fprintf(stderr, "[s:%d]\n", ack);
    if (ack == ACK_TEXT)
	fprintf(stderr, "[%d:\"%s\"]\n", size+2, text);
#endif

    iov[0].iov_base = (caddr_t)&len;
    iov[0].iov_len = sizeof(short);
    iov[1].iov_base = (caddr_t)&cmd;
    iov[1].iov_len = sizeof(short);
    iov[2].iov_base = (caddr_t)text;
    iov[2].iov_len = size;
    len = htons((short)(size + 2));
    cmd = htons((short)ack);
    if ((n = writev(sock, iov, 3)) < 0) {
	perror("writing on stream socket");
	close_sock();
	exit(1);
    }
    if (n < (sizeof(short)*2)) { /* !!!! */
	close_sock();
	exit(1);
    }
    n -= (sizeof(short)*2);
    text += n;
    size -= n;
    while (size > 0) {
	if ((n = write(sock, text, len)) < 0) {
	    perror("writing on stream socket");
	    close_sock();
	    exit(1);
	}
	text += n;
	size -= n;
    }
#ifdef DEBUG
    fprintf(stderr, "[sss]\n");
#endif
    return True;
}

void send_ack()
{
    (void)send_to_pim(ACK_TRUE, NULL, 0);
}

int receive_packet(ptr, len, max)
    char *ptr;
    int *len, max;
{
    int n, rn, size, cmd;
    char buf[sizeof(short)];

    if (read(sock, buf, sizeof(short)) == 0) {
	close_sock();
	exit(1);
    }
    size = ((int)ntohs(*((short *)buf))) - 2;
    if (read(sock, buf, sizeof(short)) == 0) {
	close_sock();
	exit(1);
    }
    cmd = (int)ntohs(*((short *)buf));
    if (size == 0) {
	*ptr = '\0';
	*len = size;
	return cmd;
    }
    rn = size;
    do {
	if ((n = read(sock, ptr, rn)) == 0) {
	    close_sock();
	    exit(1);
	}
	ptr += n;
	rn -= n;
    } while (rn > 0);
    *ptr = '\0';
    *len = size;
    return cmd;
}

static struct cmd_str_list *scan_str_list(ptr, len, num)
    char *ptr;
    int len;
    int num;
{
    union cmd_str_list *str;
    int size;

    if (len < sizeof(short))
	return NULL;
    get_short(size, ptr);
    ptr += sizeof(short);
    len -= sizeof(short);
    if (len < size)
	return NULL;
    str = alloc_cmd_str_list(size);
    str->str_length = size;
    strncpy(&(str->string[0]), ptr, size);
    str->string[size] = '\0';
    if (--num <= 0) {
	str->next = NULL;
        return str;
    }
    if ((str->next = scan_str_list(ptr + size, len - size, num)) == NULL)
	return NULL;
    return str;
}

static void create_cmd(ptr, len)
    char *ptr;
    int len;
{
    struct cmd_create *data;
    struct cmd_str_list *str;
    short num;

    if (len < sizeof(short))
	return;
    get_short(num, ptr);
    str = scan_str_list(ptr+sizeof(short), len-sizeof(short), num);
    if (str == NULL)
	return;
    data = alloc_cmd_create();
    data->num_titles = num;
    data->str_list = str;
    create_menu_titles(data);
    send_ack();
}

static void add_items_cmd(ptr, len)
    char *ptr;
    int len;
{
    struct cmd_add_items *data;
    struct cmd_str_list *str;
    short num;

    if (len < sizeof(short))
	return;
    get_short(num, ptr);
    str = scan_str_list(ptr+sizeof(short), len-sizeof(short), num);
    if (str == NULL)
	return;
    data = alloc_cmd_add_items();
    data->num_items = num;
    data->str_list = str;
    add_menu_items(data);
    send_ack();
}

static void clear_items_cmd(ptr, len)
    char *ptr;
    int len;
{
    struct cmd_clear_items *data;
    short size;

    if (len < sizeof(short))
	return;
    get_short(size, ptr);
    ptr += sizeof(short);
    data = alloc_cmd_clear_items(size);
    data->str_length = size;
    strncpy(&(data->string[0]), ptr, size);
    data->string[size] = '\0';
    clear_menu_items(data);
    send_ack();
}

static void set_title_cmd(ptr, len)
    char *ptr;
    int len;
{
    struct cmd_set_title *data;
    short size;

    if (len < sizeof(short))
	return;
    get_short(size, ptr);
    ptr += sizeof(short);
    data = alloc_cmd_set_title(size);
    data->str_length = size;
    strncpy(&(data->string[0]), ptr, size);
    data->string[size] = '\0';

    send_ack();
}

static void set_font_cmd(ptr, len)
    char *ptr;
    int len;
{
    struct cmd_set_font *data;
    short size;

    if (len < sizeof(short))
	return;
    get_short(size, ptr);
    ptr += sizeof(short);
    data = alloc_cmd_set_font(size);
    data->str_length = size;
    strncpy(&(data->string[0]), ptr, size);
    data->string[size] = '\0';

    send_ack();
}

static void put_cmd(ptr, len)
    char *ptr;
    int len;
{
    struct cmd_put *data;
    short size;

    if (len < sizeof(short))
	return;
    get_short(size, ptr);
    ptr += sizeof(short);
    data = alloc_cmd_put(size);
    data->str_length = size;
    strncpy(&(data->string[0]), ptr, size);
    data->string[size] = '\0';
    put_string(ptr);
    send_ack();
    free_cmd_put(data);
}

void receive_from_pim()
{
    int len;
    char *ptr;
    int tag;



    ptr = recv_buf;
    tag = receive_packet(recv_buf, &len, MAX_PACKET);
#ifdef DEBUG
    fprintf(stderr, "[r:%d]\n", tag);
#endif
    switch (tag) {
    case CMD_ERROR:
	break;
    case CMD_CREATE:
	create_cmd(recv_buf, len);
	break;
    case CMD_ADD_ITEMS:
	add_items_cmd(recv_buf, len);
	break;
    case CMD_CLEAR_ITEMS:
	clear_items_cmd(recv_buf, len);
	break;
    case CMD_SET_TITLE:
	set_title_cmd(recv_buf, len);
	break;
    case CMD_SET_FONT:
	set_font_cmd(recv_buf, len);
	break;
    case CMD_GET:
	set_mark();
	break;
    case CMD_PUT:
	put_cmd(recv_buf, len);
	break;
    }
#ifdef DEBUG
    fprintf(stderr, "[rrr]\n");
#endif
}
