/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* structure definition of objects in the parse tree */

typedef enum AttrRel  { InstanceOf=-1, Equal, AbstractOf } AttrRel;

typedef struct MQT_Var_Rec {
  TermType type;
  struct MQT_Var_Rec *next;
  struct MQT_Var_Rec *next_bucket;
  unsigned char *name;
  struct MQ_Var_Rec *var;
} MQT_VarList_Rec, *MQT_VarList, MQT_Var_Rec, *MQT_Var;

typedef struct MQT_Constraints_Rec {
  Rel rel;
  union MQT_Term_Rec *term1;
  union MQT_Term_Rec *term2;
  struct MQ_Atom_Rec *op;
  struct MQT_Constraints_Rec *next;
} MQT_Constraints_Rec, *MQT_Constraints;

typedef struct MQT_AttrList_Rec {
  struct MQ_Atom_Rec *label;
  union MQT_VTerm_Rec *vterm;
  struct MQT_AttrList_Rec *next;
} MQT_AttrList_Rec, *MQT_AttrList;

typedef struct MQT_Obj_Rec {
  TermType type;

  struct MQ_Atom_Rec *atom;
  struct MQT_AttrList_Rec *attr_list;
} MQT_Obj_Rec, *MQT_Obj;

typedef struct MQT_Dot_Rec {
  TermType type;

  union MQT_VTerm_Rec *vterm;
  struct MQ_Atom_Rec *label;
} MQT_Dot_Rec, *MQT_Dot;

typedef union MQT_VTerm_Rec {
  TermType type;
  MQT_Var_Rec var;
  MQT_Obj_Rec obj;
} MQT_VTerm_Rec, *MQT_VTerm;

typedef union MQT_Term_Rec {
  TermType type;
  MQT_Var_Rec var;
  MQT_Dot_Rec dot;
  MQT_Obj_Rec obj;
} MQT_Term_Rec, *MQT_Term;

typedef struct MQT_VTermList_Rec {
  struct MQT_VTermList_Rec *next;

  union MQT_VTerm_Rec *vterm;
} MQT_VTermList_Rec, *MQT_VTermList;

typedef struct MQT_AtomList_Rec {
  struct MQT_AtomList_Rec *next;
  struct MQ_Atom_Rec *atom;
} MQT_AtomList_Rec, *MQT_AtomList;

extern MQT_Obj mqTO_True;
extern MQT_Constraints current_cnstrs;

extern MQ_VarNameList get_all_variables _P((void));
extern void init_tree _P((void));
extern void free_parse_tree _P((void));
extern MQT_Var makeT_variable _P((unsigned char *));
extern MQT_AttrList makeT_attr_list _P((AttrRel, MQ_Atom, MQT_VTerm, MQT_AttrList));
extern MQT_Obj makeT_object _P((MQ_Atom, MQT_AttrList));
extern MQT_Dot makeT_dot _P((MQT_Term, MQ_Atom));
extern MQT_VTermList makeT_vterm_list _P((MQT_VTerm, MQT_VTermList));
extern MQT_Constraints makeT_constraints _P((Rel, MQT_Term, MQT_Term, MQ_Atom, MQT_Constraints));
extern MQT_Constraints current_cnstrs;
extern MQT_AtomList makeT_atom_list _P((MQ_Atom, MQT_AtomList));
