/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* extern declarations */
typedef void (void_func)_P(());

extern char *mq_version;
extern void *xmalloc _P((unsigned int));
extern void *xrealloc _P((void *ptr, unsigned int));
extern void xfree _P((void *));
extern int interactive;
extern int interactive_orig;
extern int force_interactive;
extern void output_prompt _P((void));

extern struct obstack *mm_current;

extern int temporary;
extern void begin_tmp _P((void));
extern void suspend_exec _P((void));
extern void resume_exec _P((void));
extern void end_tmp _P((void));

/* atom.c */
extern struct obstack *mm_atom;
extern unsigned char *atom_first_obj;
extern void init_atom _P((void));
extern void free_atom _P((void));
extern MQ_Atom make_atom _P((unsigned char *, struct obstack *));
extern MQ_Atom intern_atom _P((unsigned char *));
extern MQ_Atom system_atom _P((unsigned char *));
extern void remove_rule _P((void));
extern void remove_temp_rule _P((void));

/* attr.c */
extern MQ_Goal make_attribute_goals _P((MQ_Goal));

/* commands.c */
extern void init_command _P((void));
extern void cmd_quit _P((void));
extern void cmd_set _P((MQ_Atom, MQ_Atom));
extern void cmd_load _P((MQ_Atom));
extern void cmd_clear _P((MQ_Atom));
extern void cmd_show _P((MQ_Atom));
extern void show_version _P((void));

/* cs.c */
extern int constrain_failed;
extern MQ_Constraints dot_cnstrs, dot_asmpts, dot_cnstrs_h;
extern MQ_Constraints sub_cnstrs, sub_asmpts, sub_cnstrs_h;
extern MQ_Constraints ext_cnstrs, ext_asmpts, ext_cnstrs_h;
extern MQ_CnstrsAsmpts cnstrs_asmpts;
extern MQ_Constraint mQ_void_cnstr;
extern MQ_Constraints mQ_void_cnstrs;
extern MQ_CnstrsAsmpts mQ_void_cnstrs_asmpts;

extern void init_constraints _P((void));
extern void delete_nonsence_asmpts _P((void));
extern MQ_Constraint make_cnstr _P((Rel, MQ_Term, MQ_VTerm));
extern MQ_Constraints make_cnstrs _P((MQ_Constraint, MQ_Constraints));
extern int constrain_front _P((MQ_Goal));
extern int constrain_back _P((MQ_Goal));

/* cs-dot.c */
extern void constraint_solve_dot_cnstrs _P((void));
extern void constraint_solve_dot_asmpts _P((void));
extern void constraint_solve_dot_cnstrs_h _P((void));
extern void add_cnstr_to_dot_cnstrs _P((MQ_Constraint));
extern void add_cnstr_to_dot_asmpts _P((MQ_Constraint));
extern void add_cnstr_to_dot_cnstrs_h _P((MQ_Constraint));
extern int check_cnstr_in_dot_cnstrs _P((MQ_Constraint));

/* cs-sub.c */
extern void constraint_solve_sub_cnstrs _P((void));
extern void constraint_solve_sub_asmpts _P((void));
extern void constraint_solve_sub_cnstrs_h _P((void));
extern void add_cnstr_to_sub_cnstrs _P((MQ_Constraint));
extern void add_cnstr_to_sub_asmpts _P((MQ_Constraint));
extern void add_cnstr_to_sub_cnstrs_h _P((MQ_Constraint));
extern int check_cnstr_in_sub_cnstrs _P((MQ_Constraint));
extern MQ_VarList delete_bound_var_in_var_list _P((MQ_VarList));

/* cs-ext.c */
extern void constraint_solve_ext_cnstrs _P((void));
extern void constraint_solve_ext_asmpts _P((void));
extern void constraint_solve_ext_cnstrs_h _P((void));
extern void add_cnstr_to_ext_cnstrs _P((MQ_Constraint));
extern void add_cnstr_to_ext_asmpts _P((MQ_Constraint));
extern void add_cnstr_to_ext_cnstrs_h _P((MQ_Constraint));
extern int check_cnstr_in_ext_cnstrs _P((MQ_Constraint));

/* dot.c */
extern MQ_VTerm *eval_dot _P((MQ_Dot));

/* error.c */
extern int number_of_errors;
extern int yyerror _P((char *));
extern void error _P((char *));
extern volatile void_func exec_error;
extern void warning _P((char *));
extern volatile void_func fatal;

/* exec.c */
extern int executing;
extern struct obstack *mm_exec;
extern MQ_Goal mq_goal_true;

extern void init_exec _P((void));
extern void begin_exec _P((void));
extern void end_exec _P((void));
extern void free_exec _P((void));
extern int solve _P((MQ_Goal));
extern void do_query _P((MQ_Query));
extern MQ_Goal generate_subgoals _P((MQ_Goal));
extern MQ_VTermList generate_variables _P((MQ_VarList));
extern MQ_Obj tangle_obj _P((MQ_Obj));
extern MQ_Constraints tangle_constraints _P((MQ_Constraints));
extern void init_interactive _P((int));
extern volatile void_func interrupt_handler;

/* ext.c */
extern int eval_ext_cnstr _P((MQ_Obj));
extern MQ_Obj eval_ext_expr _P((MQ_Obj));

/* lex.c */
extern int last_char_is_newline;
extern unsigned char *yytext;
extern int lineno;
extern void init_lex _P((void));
extern void gobble_newline _P((void));
extern void read_line_to_yytext _P((void));
extern void pushfilename _P((char *, int));
extern int fetch_char _P((void));
extern MQ_Atom external_cnstr_op;

/* lookup.c */
extern void init_lookup _P((void));
extern void free_lookup _P((void));
extern int lookup_active_goals _P((MQ_Goal));

/* option.c */
extern int debug;
extern int debug_memory;
extern int mq_opt_lookup;
extern int mq_opt_trace;
extern int mq_opt_constrain;
extern int mq_opt_inheritance;

extern void init_options _P((void));

/* parse.y */
#define MODE_PROGRAM              0
#define MODE_PROGRAM_RULE         1
#define MODE_PROGRAM_SUBSUMPTION  2
#define MODE_QUERY                3
#define MODE_COMMAND              4
#define PS_EXPECT_PRD            10
#define PS_EXPECT_Q_PRD          11
#define PS_EXPECT_TERM           12

extern int mq_mode;
extern int error_recovering;
extern int reading_object;
extern int yyparse _P((void));

/* print.c */
extern void print_all_subrel _P((void));
extern void print_all_rules _P((void));
extern void print_answer _P((MQ_Query));
extern void print_goal _P((MQ_Goal));
extern void print_constraints _P((MQ_Constraints, int));
extern void print_obj _P((MQ_Obj));

/* rule.c */
extern MQ_Atom mqA_True;
extern MQ_Obj mqO_True;
extern MQ_NameVar mq_name;
extern MQ_Rule mQ_void_rule;
extern MQ_RuleList mQ_void_rule_list;
extern struct obstack *mm_rule;
extern MQ_RuleList rule_list, rule_list_last;
extern void init_rule _P((void));
extern void begin_temp_alloc_rule _P((void));
extern void end_temp_alloc_rule _P((void));
extern void free_rule _P((void));
extern MQ_Rule make_rule _P((void));
extern MQ_RuleList make_rule_list _P((MQ_Rule, MQ_RuleList, int));

/* subrel.c */
extern MQ_SubRel subrel_list;
extern void init_subrel _P((void));
extern void begin_temp_alloc_subrel _P((void));
extern void end_temp_alloc_subrel _P((void));
extern void free_subrel _P((void));
extern MQ_SubRel make_subrel _P((MQ_Atom, MQ_Atom, MQ_SubRel));

/* subsump.c */
extern MQ_Atom mqA_Bottom, mqA_Top;
extern MQ_Obj  mqO_Bottom, mqO_Top;
extern void init_lattice _P((void));
extern void free_lattice _P((void));
extern void generate_lattice _P((void));
extern MQ_Obj meet _P((MQ_Obj, MQ_Obj));
extern MQ_Obj join _P((MQ_Obj, MQ_Obj));
extern int eval_subsumption _P((MQ_VTerm, MQ_VTerm, MQ_Constraints *));
extern void begin_get_atom_which_supersumes _P((MQ_Atom));
extern MQ_Atom get_next_atom_supersump _P((void));
extern void begin_get_atom_which_subsumes _P((MQ_Atom));
extern MQ_Atom get_next_atom_subsump _P((void));
extern MQ_VarList variables_in_obj _P((MQ_Obj));

/* unify.c */
extern int binding_changed;
extern UnwindProtect up;

extern void init_unify _P((void));
extern void unwind_protect_variable_in_cnstrs _P((MQ_Var, MQ_VTermAddrList));
extern void unwind_variables _P((UnwindProtect));
extern int equal _P((MQ_VTerm, MQ_VTerm));
extern void bind _P((MQ_Var, MQ_VTerm));
extern int unify _P((MQ_VTerm *, MQ_VTerm *));
