/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* error handling routines */

#include <stdio.h>
#include "mq.h"
#include "internal.h"
#include "tree.h"
#include "extern.h"

int number_of_errors;

void error (message)
     char *message;
{
  if (interactive)
    fprintf (stderr, " %s", message);
  else
    fprintf (stderr, "%d: %s", lineno, message);
  number_of_errors++;
}

void exec_error (message)
     char *message;
{
  if (interactive)
    fprintf (stderr, " %s", message);
  else
    fprintf (stderr, "%d: %s", lineno, message);
  interrupt_handler ();
}

void warning (message)
     char *message;
{
  if (interactive)
    fprintf (stderr, " %s", message);
  else
    fprintf (stderr, "%d: %s", lineno, message);
}

void fatal (message)
     char *message;
{
  fprintf (stderr, "fatal error: %s", message);
  exit (1);
  /* DON'T RETURN */
}
