// IMSAVE.CPP: 	Saving images.
// 				This code is partially based on the SDK example SHOWDIB
// Copyright 1993 by Harley Davis

#include "stdafx.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <direct.h>
#include "showdib.h"

int ErrorMsg( HWND hwnd, char *Error )
{
	MessageBox( hwnd, Error, "Warning",
					MB_ICONASTERISK | MB_OK );
	return(0);
}

BOOL SaveBMPFile( HBITMAP hBitmap, const char* szFName, CPalette* pPal)
{
	HPALETTE	  hOrigPal = (HPALETTE)(pPal->m_hObject);
    TRACE("Saving file '%s'\n", szFName);
    
    HANDLE hDib = DibFromBitmap(hBitmap, hOrigPal, BI_RGB, 0);
    
    if(!hDib) return FALSE;

	BOOL bWrote = WriteDIB(szFName, hDib);
	
	if (!bWrote) return FALSE;
 
	return TRUE;
}



