// imogene.cpp : Defines the class behaviors for the application.
// Copyright 1993 by Harley Davis

#include <math.h>
#include "stdafx.h"
#include "imogene.h"
#include "iminl.h"
#include "imobj.h"
#include "mainfrm.h"
#include "imframe.h"
#include "imdoc.h"
#include "imview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif 



/////////////////////////////////////////////////////////////////////////////
// CImApp

BEGIN_MESSAGE_MAP(CImApp, CWinApp)
	//{{AFX_MSG_MAP(CImApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_HELP_INDEX, OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, OnHelpUsing)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	// ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImApp construction

CImApp::CImApp()
{
	m_bComputing = FALSE;
}

CImApp::~CImApp()
{
	end_math();
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CImApp object

CImApp NEAR theApp;
CImApp *pTheApp;

const char* Copyright = "Copyright 1993 by Harley Davis";

/////////////////////////////////////////////////////////////////////////////
// CImApp initialization

BOOL CImApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.
	
#ifdef _DEBUG
	afxTraceEnabled = TRUE;
#endif

	pTheApp = this;

	SetDialogBkColor();        // set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	AddDocTemplate(new CMultiDocTemplate(IDR_IMOGENTYPE,
			RUNTIME_CLASS(CImDoc),
			RUNTIME_CLASS(CImFrame),        // my own splitter
			RUNTIME_CLASS(CImView)));

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;

	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->ShowWindow(SW_SHOWMAXIMIZED);
	pMainFrame->UpdateWindow();
	m_pMainWnd = pMainFrame;
	
	// Imogene initializations
	srand((unsigned int)time(NULL));
	init_math();

	// create a new (empty) document
	// Some prefer that we don't create it right away.
	// OnFileNew();

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CImApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CImApp commands



void CImApp::OnFileNew()
{
	if(!m_bComputing) 
	{
		TRACE("New document.\n");
		CWinApp::OnFileNew();
	}
	else
	{
		TRACE("Read my lips:  no new documents!\n");
	}
	return;	
}

void CImApp::OnHelpIndex()
{
	CWinApp::OnHelpIndex();	
}

void CImApp::OnHelpUsing()
{
	CWinApp::OnHelpUsing();	
}
