// IMMATH:  Math operations
//			This really speeds things up for floating point calculations, which have
//			to undergo conversion and scaling without these tables.
//			However, the tables are enormous (in Windows terms).
// Copyright 1993 by Harley Davis

#include <math.h>
#include "stdafx.h"
#include "iminl.h"

static HGLOBAL sinHandle;
static HGLOBAL cosHandle;
static HGLOBAL lnHandle;

long *lsin_table;
long *lcos_table;
long *lln_table;

double scaled_ln(double d)
{
	// d is between 0 and dResultMax.
	// We must scale it to [1..e], then take the ln
	// and scale that from [0..1] to [0..dResultMax].
	const static double e_1 = exp(1.0)-1.0;
	return dResultMax*(log(dScale(d, dResultMax, e_1)+1.0));
}

void init_math()
{
	// initialize the math tables.
	TRACE("Making math tables...");
	TRACE("sin...");
	sinHandle = GlobalAlloc(GHND, (lResultMax+1)*sizeof(long));
	ASSERT(sinHandle!=NULL);
	lsin_table = (long*)GlobalLock(sinHandle);
	ASSERT(lsin_table!=NULL);
	TRACE("cos...");
	cosHandle = GlobalAlloc(GHND, (lResultMax+1)*sizeof(long));
	ASSERT(cosHandle!=NULL);
	lcos_table = (long*)GlobalLock(cosHandle);
	ASSERT(lcos_table!=NULL);
	TRACE("ln...");
	lnHandle = GlobalAlloc(GHND, (lResultMax+1)*sizeof(long));
	ASSERT(lnHandle!=NULL);
	lln_table = (long*)GlobalLock(lnHandle);
	ASSERT(lln_table!=NULL);
	for(long i = 0; i<=lResultMax; i++)
	{   
		double si = double(i)*ScaledPi;
		lsin_table[i] = (long)(dResultMax2*sin(si)+dResultMax2);
		lcos_table[i] = (long)(dResultMax2*cos(si)+dResultMax2);
		lln_table[i] = (long)(scaled_ln(i));
		if((i%300)==0) TRACE("lln_table[%ld] = %ld\n", i, lln_table[i]);
	}
	TRACE("Done.\n");
	long foo = rand();
	TRACE("Testing: lsin_table[%ld] = %ld\n", foo, lsin_table[foo]);
	TRACE("Testing: lcos_table[%ld] = %ld\n", foo, lcos_table[foo]);
	TRACE("Testing: lln_table[%ld] = %ld\n", foo, lln_table[foo]);
}

void end_math()
{
	BOOL bUnlock = GlobalUnlock(sinHandle);
	ASSERT(!bUnlock);
	bUnlock = GlobalUnlock(cosHandle);
	ASSERT(!bUnlock);
	bUnlock = GlobalUnlock(lnHandle);
	ASSERT(!bUnlock);
	sinHandle = GlobalFree(sinHandle);
	ASSERT(sinHandle==NULL);
	cosHandle = GlobalFree(cosHandle);
	ASSERT(cosHandle==NULL);
	lnHandle = GlobalFree(lnHandle);
	ASSERT(lnHandle==NULL);
}  