// imframe.h : header file for main window class
// Copyright 1993 by Harley Davis

/////////////////////////////////////////////////////////////////////////////
// CImFrame frame with splitter

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CImFrame : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CImFrame)
protected:
	CImFrame();			// protected constructor used by dynamic creation

// Attributes
protected:
	CSplitterWnd	m_wndSplitter;
	BOOL m_bCycling;			// Color cycling?
	long m_nCycleSpeed;			// ms between cycles
	BOOL m_bCycleIn;			// which way to cycle?
	CPalette* m_pPalette;		// Palette
	int m_nColors;				// # of colors 
	BOOL m_bNewPalette;			// first palette?
	LPPALETTEENTRY m_pPalEntries; // palette entry vector used for cycling.
	
// Operations
public:
	CPalette* GetPalette() { return m_pPalette; }
	int GetColors() { return m_nColors; }
	void GetFrameDims(int & nHeight, int & nWidth);
	void CycleColors();

// Implementation

public:
	virtual ~CImFrame();
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext); 
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	void InitPalette();

	// Generated message map functions
	//{{AFX_MSG(CImFrame)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnToggleCycling();
	afx_msg void OnLoadColorMap();
	afx_msg void OnDefaultColorMap();
	afx_msg void OnAccelCycling();
	afx_msg void OnDecelCycling();
	afx_msg void OnCycleIn();
	afx_msg void OnCycleOut();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
