// imdoc.cpp : implementation of the CImDoc class.
//				A CImDoc corresponds to an evolution, which has a set of
//				generations, each of which has a set of objects, each of which
//				has a formula, which is an instance of CImGene, and an image, which 
//				is a CImView.
// Copyright 1993 by Harley Davis

#include <stdio.h>
#include <math.h>
#include "stdafx.h"
#include "iminl.h"
#include "imobj.h"
#include "imogene.h"
#include "imdoc.h"
#include "imview.h"
#include "imparam.h"
#include "imshowge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CImDoc

IMPLEMENT_DYNCREATE(CImDoc, CDocument)

BEGIN_MESSAGE_MAP(CImDoc, CDocument)
	//{{AFX_MSG_MAP(CImDoc)
	ON_COMMAND(ID_NEW_GENERATION, OnNewGeneration)
	ON_COMMAND(ID_SET_PARAMETERS, OnSetParameters)
	ON_COMMAND(ID_RND_GENERATION, OnRndGeneration)
	ON_COMMAND(ID_SHOW_GEN, OnShowGen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImDoc construction/destruction

CImDoc::CImDoc()
{
	m_nGeneration = 0;
	m_pEvolution = new CImEvolution;
	CImApp* pApp = (CImApp*)AfxGetApp();
	pApp->m_bComputing = TRUE;
}

CImDoc::~CImDoc()
{
	delete m_pEvolution;
}

BOOL CImDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	CImApp* pApp = (CImApp*)AfxGetApp();
	OnNewGeneration();
	pApp->m_bComputing = FALSE;
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CImDoc serialization

void CImDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}


/////////////////////////////////////////////////////////////////////////////
// CImDoc diagnostics

#ifdef _DEBUG
void CImDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CImDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CImDoc commands

void CImDoc::OnNewGeneration()
{ 
	TRACE("CImDoc: Making new generation\n");
	m_nGeneration++;
	m_pEvolution->NewGeneration();
	
	UpdateGeneration();
}

void CImDoc::UpdateGeneration(int nGeneration)
{
	// point views to organisms.
	POSITION pos = GetFirstViewPosition();
	for(int i = 0; i<9; i++)
	{
		CImView* pView = (CImView*)GetNextView( pos );
		ASSERT(pView!=NULL);
		pView->SetOrganism(m_pEvolution->GetOrganism(i, nGeneration));
	}
	UpdateAllViews(NULL);
	
	char buf[40];
	if((nGeneration==m_nGeneration)||(nGeneration==-1))	// -1 is default value.
		sprintf(buf, "Generation #%d", m_nGeneration);
	else
		sprintf(buf, "Generation #%d (%d)", nGeneration, m_nGeneration);
	SetTitle(buf);	
}

void CImDoc::OnSetParameters()
{
	CImParameters dlg;
	// init dialog data
	dlg.m_nCrossoverPct = m_pEvolution->GetCrossoverPct();
	dlg.m_nMutationPct = m_pEvolution->GetMutationPct();
	dlg.m_nMaxCom = m_pEvolution->GetMaxComplexity();
	if(dlg.DoModal()==IDOK)
	{
		// get dialog data.
		m_pEvolution->SetCrossoverPct(dlg.m_nCrossoverPct);
		m_pEvolution->SetMutationPct(dlg.m_nMutationPct);
		m_pEvolution->SetMaxComplexity(dlg.m_nMaxCom);
	}
}

void CImDoc::OnRndGeneration()
{
	TRACE("Doing random generation.\n");
	m_nGeneration++;
	m_pEvolution->RandomGeneration();
	
	UpdateGeneration();
}

void CImDoc::OnShowGen()
{
	CImShowGenDlg dlg;
	dlg.SetMaxGen(m_nGeneration);
	dlg.m_nGen = m_nGeneration;
	
	if(dlg.DoModal()==IDOK)
	{
		UpdateGeneration(dlg.m_nGen);
	}
	
}

