// IMBYTEC:  The formula byte code compiler and byte code machine.
// Copyright 1993 by Nitsan Seniak (seniak@ilog.fr)

// The byte code compiler gains around 15-20% in image generation time, but
// makes writing new node classes a little hairy.

#include <math.h>
#include "stdafx.h"
#include "iminl.h"
#include "imobj.h"
#include "imgene.h"
#include "imogene.h"
#include "imframe.h"
#include "imdoc.h"
#include "imview.h"
/*
// Can we really trust the compiler to inline these functions?
// See #define versions below.
// This is what happens when you let a C programmer touch C++ -- harley

static inline long StackPop(long *&sp)
{
	return *(sp--);
}

static inline long StackTop(long *&sp)
{
	return *sp;
}

static inline void StackPush(long *&sp, long n)
{
	*(++sp) = n;
}

static inline void StackSet(long *sp, long n)
{
	*sp = n;
}	

static inline long ByteCodeData(ByteCode *&pBc)
{
	return (pBc++)->data;
}
*/

#define StackPop(sp)		(*(sp--))
#define StackTop(sp)		(*sp)
#define StackPush(sp, n)	(*(++sp)=n)
#define StackSet(sp, n)		(*sp=n)
#define ByteCodeData(pBc)	((pBc++)->data)

void ByteCodeProgram::Run(long x1, long y1, long x2, long y2, 
							CDC* pDC, CDC* pMemDC, CImView* pView)
// Compute the points between (x1,y1) and (x2,y2).
// We pass in all relevent information to avoid any function calls
// during the crucial loop.
{
	TRACE("Running for %d, %d & %d, %d\n", x1, y1, x2, y2);
	if ((x1==x2)||(y1==y2)) return;	// can happen when resizing.
	CImFrame* pFrame = (CImFrame*)(pView->GetParentFrame());
	ASSERT(pFrame);
	int nPalSize = pFrame->GetColors();
	ByteCode *pCurByte;
	ByteCode *pLastByte; 
	static const int StackSize = 1024;
	static long stack[StackSize];
	long *sp;
	long lastx = x1;		// last value of x used for displaying
	// Everything must be inlined in this loop.
	// If you modify it, please examine the generated assembler to verify
	// that you have not screwed up the optimizations.
	for (long sx = x1; sx <= x2; sx++)
	{
		long x = lScale(sx, x2);
		for (long sy = y1; sy < y2; sy++)
		{
			long y = lScale(sy, y2);
//			long nPalIndex = m_pOrganism->Eval(sx, sy, m_pBitmap);
         	pCurByte = &program[0];
			pLastByte = &program[length];
			sp = stack;
	                                                
			while (pCurByte < pLastByte)
			{
				switch ((pCurByte++)->code)
				{   
					case GN_X: 			BC_X
					case GN_Y: 			BC_Y
					case GN_CONST: 		BC_CONST  
					case GN_ADD: 		BC_ADD
					case GN_SUB: 		BC_SUB	
					case GN_MUL: 		BC_MUL
					case GN_DIV: 		BC_DIV
					case GN_AND: 		BC_AND
					case GN_OR: 		BC_OR
					case GN_XOR: 		BC_XOR				
					case GN_DISTXY: 	BC_DISTXY				
					case GN_CIRC: 		BC_CIRC				
					case GN_SIN: 		BC_SIN				
					case GN_COS: 		BC_COS
					case GN_LN:			BC_LN				
					case GN_NOT: 		BC_NOT				
					case GN_RAND: 		BC_RAND				
					case GN_MAX: 		BC_MAX				
					case GN_MIN: 		BC_MIN									
					case GN_AVG: 		BC_AVG				
					case GN_INV: 		BC_INV
					case GN_RAND_RANGE: BC_RAND_RANGE				
					case GN_POLAR_1:  	BC_POLAR_1				
					case GN_POLAR_2:  	BC_POLAR_2
					case GN_MANH:		BC_MANH
					case GN_MDISTXY: 	BC_MDISTXY
					case GN_BITMAP:
						{ 
							TRACE("Doing a bitmap at %d, %d.\n", x, y);		
						  	BC_BITMAP
						 }						
					case RESTORE_XY:
						{ long val = StackPop(sp);
				  		y = StackPop(sp);
				  		x = StackTop(sp);
				  		StackSet(sp, val);
				  		break; }							  
					default:
						ASSERT(0);
				} // switch
			} // while
	
			ASSERT(sp == stack+1); 
	
			long nPalIndex = StackTop(sp);
			long ScaledPI = lScale(nPalIndex, lResultMax, nPalSize);
			// long ScaledPI = nPalIndex%nPalSize;
			COLORREF nPalRes = PALETTEINDEX((WORD)ScaledPI);
			pMemDC->SetPixel(int(sx), int(sy), nPalRes);
		} // for y
		// show progress every few lines.
		if((sx-lastx)==lShowLines)
		{
			pView->ShowRegion(pDC, pMemDC, (int)lastx, 0, lShowLines, int(y2),
								lShowLines, int(y2));
			lastx = sx;
		}
		else if (sx>=x2)
			pView->ShowRegion(pDC, pMemDC, (int)lastx, 0, (int)(x2-lastx), int(y2),
								(int)(x2-lastx), int(y2));	
	} // for x
}

// Compilation

void ByteCodeProgram::Load(CImGene *pGene)
{
	length = 0;
	pGene->Compile(this);
}

void CImGene::Compile(ByteCodeProgram *pProg)
{
	ASSERT(0);
}
                             
void CImGene0::Compile(ByteCodeProgram *pProg)
{
	pProg->AddCode(GeneByte());
}

void CImGene1::Compile(ByteCodeProgram *pProg)
{
	m_pArg1->Compile(pProg);
	pProg->AddCode(GeneByte());
}
                            
void CImGene2::Compile(ByteCodeProgram *pProg)
{
	m_pArg1->Compile(pProg);
	m_pArg2->Compile(pProg);
	pProg->AddCode(GeneByte());
}
          
void CImConstGene::Compile(ByteCodeProgram *pProg)
{
	pProg->AddCode(GeneByte());
    pProg->AddData(m_nConst);
}
          
void CImCircGene::Compile(ByteCodeProgram *pProg)
{
	pProg->AddCode(GeneByte());
    pProg->AddData(m_cx); 
    pProg->AddData(m_cy);
}
 
void CImDistxyGene::Compile(ByteCodeProgram *pProg)
{
	m_pArg1->Compile(pProg);
	m_pArg2->Compile(pProg);
	pProg->AddCode(GeneByte());
    pProg->AddData(nX); 
    pProg->AddData(nY);
}

void CImInvGene::Compile(ByteCodeProgram *pProg)
{
	pProg->AddCode(GeneByte());
//	pProg->AddData(m_dx);
//	pProg->AddData(m_dy);
	m_pArg1->Compile(pProg);
	pProg->AddCode(RESTORE_XY);
}

void CImPolarGene::Compile(ByteCodeProgram *pProg)
{
	if (m_bRhoX) pProg->AddCode(GN_POLAR_1);
	else pProg->AddCode(GN_POLAR_2);
	pProg->AddData(m_dx);
	pProg->AddData(m_dy);
	m_pArg1->Compile(pProg);
	pProg->AddCode(RESTORE_XY);
}

void CImBitmapGene::Compile(ByteCodeProgram *pProg)
{
	pProg->AddCode(GN_BITMAP);
	pProg->AddData(m_nWidth);
	pProg->AddData(m_nHeight);
	pProg->AddHandle(m_pBits);
}



                                                    		  