//
//      TOLKIEN: Tool Kit for Genetics-based Applications
//
//      Anthony Yiu-Cheung Tang, 1992-93.
//      Department of Computer Science
//      The Chinese University of Hong Kong.
//
#include "slctlrnk.h"

static  PCTypeInfo linearRankBases[] = { &SelectionScheme::infoObj, 0 };
const TypeInfo  LinearRanking::infoObj("Linear Ranking", linearRankBases);

//
//	the population to be selected is first sorted in decending order
//	of fitness
//
//	a selection index is generated by
//
//
//		index = (population_size / (2 * (bias - 1))) *
//			(bias - sqrt(bias*bias - 4(bias - 1) * rnd(0,1)))
//
//
PCTGAObj LinearRanking::select()
{
	int index;

	index = sorted.size() *
	  (flBias -
	   sqrt(flBiasSqr - tRand.asFloat() * 4 * flBiasLessOne)) /
	   (2 * flBiasLessOne);

	return (PCTGAObj) sorted.elem(index);
}

