/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* common definitions */

#include "topology.h"


typedef unsigned long popelem_f;
/* Das hat Platz fr die 23 Bits des 1.GA */

typedef signed short popelem;


extern struct target {
    	float input[IN_LAYER];
    	float output[OUT_LAYER];
} targets[N_TARGET];

/* Erstellt die Nodeliste */
extern int make_node_list(struct node_list **node, popelem_f *pop );

/* Macht die Nodeliste weg */
extern void destroy_node_list( struct node_list *node );

/* Output des Neuron n, basierend auf Netz p und Nodeliste n, mit Eingabe in */
extern void output( popelem *p, float *in, float *out,
    		struct node_list *n );

/* Fehlerverhalten von p und n, bei Eingabe in zu Output out */
extern float error(popelem *p, float *in, float *out,
    		struct node_list *n);

/* Fehlerverhalten von p und n bezogen auf alle Targets t */
extern float ges_error(popelem *p, struct target *t,
    		struct node_list *n);

/* Alle Targets setzen */
extern void set_target( void );

/* Globale Variablen */
