/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/*@ GENETIC.LIB (c) Jochen Ruhland */
#include "version.inc"
/* A portable Randomnumber generator */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "portrnd.h"

#define M1	233280L
#define IA1	9301L
#define IC1	49297L

#define M2	714025L
#define IA2	4096L
#define IC2	150889L

#define M3	259200L
#define IA3	7141L
#define IC3	54773L

/*
 * #define M4	243000L #define IA4	4561L #define IC4	51349L 
 */

#define M4	120050L
#define IA4	2311L
#define IC4	25367L


static unsigned long _rand16 = 0, rr;

double          d1, d2;

unsigned short  us;

unsigned short  rand16(unsigned short max)
{
	                rr = _rand16;
	_rand16 = (_rand16 * IA4 + IC4) % M4;
	d1 = (double) _rand16 *(double) max;

	d2 = d1 / (double) M4;
	us = (unsigned short) d2;
	return us;
}

unsigned short  rands(void)
{
	                _rand16 = (_rand16 * IA4 + IC4) % M4;
	return (unsigned short) (_rand16 & 0xffff);
}

void            seed16(unsigned short seed)
{
	                _rand16 = seed;
}

#pragma auto_inline( off )
float           frand16(void)
{
	                _rand16 = (_rand16 * IA4 + IC4) % M4;
	return (float) _rand16 / (float) M4;
}

#pragma auto_inline( on )

unsigned short  brand16(double p_bit)
{
	int             i;
	unsigned short  mask, shifter;

	for (mask = 0, shifter = 1, i = 0;
	     i < 16;
	     i++, shifter <<= 1)
	{
		if (frand16() < p_bit)
			mask ^= shifter;
	}
	return mask;
}

unsigned short time_seed( void )
{
    return (unsigned short)(time(NULL)&0xffff);
}
