/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* Genetic operators */
/* Erweiterung auf mehrere Populationen gleichzeitig */

#include "debug.h"

#ifndef __USHORT
#define __USHORT
typedef unsigned short USHORT;
#endif

#define POPNONVALID	-1

/* Statusfunktionen */
extern int get_number_multi(int);
/* Anzahl der Elemente in der int-Pop */

extern int get_size_multi(int);
/* Groesse der Elemente in der int-Pop */

extern void *get_spare(int);
/* Zeiger auf Spare-Datenbereich der int-Population */

struct r_list *get_rlist_multi( int npop );
/* Zeiger auf die Rangliste der Population */

struct r_list *get_rlist_meta( void );
/* Zeiger auf die Meta-Rangliste */

extern int get_number_meta(void);
/* Anzahl der Elemente in der meta-Pop */

extern int get_size_meta(void);
/* Groesse der Elemente in der meta-Pop */

extern void init_multi(int number, int meta, USHORT rseed);
/* Legt die Super-Population an, mit number Elementen, die Meta gross
 * sind, seed ist Initiator fuer Zufallszahlengenerator */

extern void init_multi_population(int npop, int number, int sizepop);
/* Legt in Pop npop number von popelem's an, mit Groesse sizepop */

extern void make_multi_population(int npop, int number, int make_spare() );
/* wie init_multi_population, erstellt allerdings gleich die spare-liste mit.
 * npop - welche wird angelegt, number wieviel drin, make_spare - eine Funktion,
 * die aus der Geneom-Information die Spare-Funktion errechnet */

extern void destroy_multi_population(int npop, void destroy_spare());
/* Loest eine die multi-Pop npop wieder auf, destroy_spare weiss mit dem
 * Spare-Bereich umzugehen */

extern void set_rank_multi(int npop, float (*ges_error) (), void *t );
/* Erstellt eine Rangliste der npop sub-Population,  ges_error errechnet
 * den fehler zu den Targets t */

extern void set_rank_meta(float (*pop_error) ());
/* Erstellt eine Rangliste der Meta-Population, pop_error ist eine Funktion
 * die eine Rangliste einer Sub-Pop auswertet */

void eval_sub_population(int number, float (*pop_error) ());
/* Bewertet die Multipopulation number fuer die Meta mithilfe von pop_error */

extern double compute_hamming_multi(int number);
extern double compute_hamming_meta(void);
/* Berechnet die mittleren Hammingabstaende fuer multi und meta Populationen */

extern int dimension_multi(int number);
extern int dimension_meta(void);
/* Berechnet die noch vorhandenen Dimensionen in multi und meta Populationen */

/* Normaler C1 GA einer multi Population */
extern float genstep_c1_multi( int npop, float (*ges_error) (), void *t,
				    float c1_rate, float m_rate);

/* Normaler C2 GA einer multi Population */
extern float genstep_c2_multi( int npop, float (*ges_error) (), void *t,
				    float c2_rate, float m_rate);

/* Normaler Cn GA einer multi Population */
extern float genstep_cn_multi( int npop, float (*ges_error) (), void *t,
				    float cn_rate, float m_rate);

/* Normaler c[1n] GA der Meta Population */
extern float genstep_c1_meta( float (*pop_error) (), int(*make_spare)(),
		void (*destroy_spare)(),float c1_rate, float m_rate);
extern float genstep_cn_meta( float (*pop_error) (), int(*make_spare)(),
		void (*destroy_spare)(),float cn_rate, float m_rate);
/* pop_error kann Sub-Populationen auswerten, make_spare kann Spare-Bereiche
 * von Multi-Populationen erzeugen, destroy_spare kann Spare-Bereiche von
 * Multi-Populationen loeschen */


