/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/*@ GENETIC.LIB (c) Jochen Ruhland */
#include "version.inc"

/*
 * Support Funktions for genetic 
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>

#include "cmdargs.h"

/* Holt aus vals eine Ganzzahl und speichert alaog zu p */
#ifdef MSDOS
__inline
#endif
static void process_fixed(struct pararray p, char *vals)
{
    long            number;

    number = atol(vals + 2);
    switch (p.datatype)
    {
    case (P_SHORT):
	*((short *) p.parameter) = (short) number;
	break;
    case (P_LONG):
	*((long *) p.parameter) = (long) number;
	break;
    case (P_INT):
	*((int *) p.parameter) = (int) number;
	break;
    }
}

/* Holt aus vals eine Floatzahl und speichert alaog zu p */
#ifdef MSDOS
__inline
#endif
static void process_float(struct pararray p, char *vals)
{
    float           number;

    number = (float) atof(vals + 2);
    switch (p.datatype)
    {
    case (P_FLOAT):
	*((float *) p.parameter) = (float) number;
	break;
    case (P_DOUBLE):
	*((double *) p.parameter) = (double) number;
	break;
    }
}

static void process_boolean(struct pararray p, char *vals)
{
    switch (p.datatype)
    {
    case (P_BOOLEAN_ON):
	*((int *) p.parameter) = 0;
	break;
    case (P_BOOLEAN_OFF):
	*((int *) p.parameter) = 1;
	break;
    }
}

#ifdef MSDOS
__inline
#endif
static void process_char(struct pararray p, char *vals)
{
    char            c;

    c = *(vals + 2);
    *((char *) p.parameter) = c;
}

static void set_default( void )
{
    int par;
    for( par=0; par < def_parameter; par++ )
	if(p_array[par].datatype == P_BOOLEAN_ON )
	    *(int *)p_array[par].parameter = 1;
	else if(p_array[par].datatype == P_BOOLEAN_OFF )
	    *(int *)p_array[par].parameter = 0;
}

void parse_parameter(int argc, char **argv)
{
    int             look_at = 1;

    /* Zunaechst die Default-Booleans setzten */
    set_default();

    while (look_at < argc)
    {
	char            parchar;
	int             testpar;

	if ((argv[look_at][0] != '-') || (argv[look_at][1] == 0))
	{
	    fprintf(stderr,
	      	"Parameter Error in parameter %d, skipping\n%s\n",
		look_at, argv[look_at]);
	    look_at++;
	    continue;
	}
	parchar = argv[look_at][1];
	for (testpar = 0; testpar < def_parameter; testpar++)
	{
	    char pchar = parchar, tchar = p_array[testpar].switch_char;

	    switch (p_array[testpar].set_case)
	    {
	    case (P_UPCASEPAR):
		tchar = (char) toupper(tchar);
		break;
	    case (P_LOCASEPAR):
		tchar = (char) tolower(tchar);
		break;
	    case (P_NOCASEPAR):
		tchar = (char) toupper(tchar);
		pchar = (char) toupper(pchar);
		break;
	    }
	    if (pchar == tchar)
		break;
	};
	if (testpar >= def_parameter)
	{
	    fprintf(stderr,
		"Parameter Error in parameter %d, skipping\n%s\n",
		look_at, argv[look_at]);
	    look_at++;
	    continue;
	}
	else
	{
	    /* Switch-Zeichen wurde richtig erkannt */
	    switch (p_array[testpar].datatype)
	    {
	    case (P_SHORT):
	    case (P_LONG):
	    case (P_INT):
		process_fixed(p_array[testpar], argv[look_at]);
		look_at++;
		break;
	    case (P_FLOAT):
	    case (P_DOUBLE):
		process_float(p_array[testpar], argv[look_at]);
		look_at++;
		break;
	    case (P_CHAR):
		process_char(p_array[testpar], argv[look_at]);
		look_at++;
		break;
	    case (P_BOOLEAN_ON):
	    case (P_BOOLEAN_OFF):
		process_boolean(p_array[testpar], argv[look_at]);
		look_at++;
		break;
	    case (P_STRING):
	    default:
		fprintf(stderr,
		    "Error in p_array %d, skipping\n%s\n",
		    look_at, argv[look_at]);
		look_at++;
		continue;

	    }
	}
    }
}
