
/*----------------------------------------------------------------------*/
/*                                                                      */
/* User program for defining the interactions between the model and the */
/* inference engine                                                     */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
#include <stdio.h>
#include <math.h>

 /*
  * Pointer to the output file. The outcome of the simulation will be written
  * here. You must fill it using the calls to fprintf included below
  */
extern FILE    *pFichSALIDA;

 /*
  * These arrays are used to communicate this module with the rest of the 
  * simulation. You must read the values from them and, after processing,
  * write the new values back. The default is writing the same values that
  * have been read.
  */
extern float    ANTEC[],
                CONSEC[];

 /*
  * Number of antecedents and consequents, i. e., the dimensions of the
  * former arrays.
  */
extern          numANTEC,
                numCONSEC;

/*-----------------------------------------------------------------------*/
/* FUNCTION: actualizaDATOS                                              */
/* PARAMET :                                                             */
/* RDO     : Leave in the arrays ANTEC[] y CONSEC[] the final values     */
/*           after reading and processing them.                          */
/* COMENT  : Special care must by taken with this function and the       */
/*           modifications it makes on the values. It constitutes the    */
/*           core of the plant simulation you are developing the         */
/*           controller for.                                             */
/*-----------------------------------------------------------------------*/
void            actualizaDATOS ()
{
   /*
    * This variable indicates the index of the current iteration.
    * IT MUST BE ALWAYS DECLARED STATIC.
    */
   static int      iteracionActual;


   /*
    * You may define here the local variables of the function
    */
   float           x, xPrima, yPrima,
                   r,
                   angRueda, angCamion, angCamionPrima;
   static float    y;

   /*
    * You must put here the names you want to identify the axes in the graphic
    * display of the application and the maximum and minimum values for the
    * variables to be represented.
    */
   if (iteracionActual == 0)
   {
      fprintf (pFichSALIDA, "%s\t%f\t%f",
	       "X",
	       (float) 0,
	       (float) 100);
      fprintf (pFichSALIDA, "\n%s\t%f\t%f",
	       "Y",
	       (float) 0,
	       (float) 100);
      y = 1;
   }

   /*
    * DO NOT DELETE THIS LINE !!!
    * The iteration index must be incremented each time the function is called.
    */
   iteracionActual++;

   /*
    * Here is where you may include the calculation of the output values from
    * the current data. Be careful with the indexes of the arrays. You can 
    * use the list in the left-hand side of the window, where you can find
    * the association between antecedents/consequents and their correspondant
    * indexes in the arrays.
    */
   x = ANTEC[0];
   angCamion = ANTEC[1];
   angRueda = CONSEC[0];
   r = 1;

   angCamionPrima = angCamion + angRueda;
   xPrima = x + r * cos (angCamionPrima * 3.141592/180);
   yPrima = y + r * sin (angCamionPrima * 3.141592/180);
   y = yPrima;

   /*
    * At this point you must return the values which will be used in the
    * next iteration.
    */
   ANTEC[0] = xPrima;
   ANTEC[1] = angCamionPrima;

   /*
    * Use this section to write the values you want to be displayed into the
    * the output file. Bear in mind the identifiers you asigned to the axes
    * some lines before.
    */
   fprintf (pFichSALIDA, "\n%f %f ",
	    (float)xPrima, 
	    (float)yPrima);

   return;
}

/*----------------------------------------------------------------------*/
/* End of user's source for the model                                   */
/*----------------------------------------------------------------------*/
