function g=very(g)
% VERY Applies linguistic hedge "VERY" to grades.
%
% VERY(G)
%   G - Row vector(s) of grades.
% Returns new row vector(s) of grades after applying
%   a hedge of 2.0.
%
% EXAMPLE: s = 0:.1:10;
%          g1 = large(s);
%          g2 = very(g1);
%          plotfs(s,'Fuzzy Sets: Large & Very Large')
%          plot(s,g1,'--',s,g2)
%          hold off
%
% SEE ALSO: exactly, extremly, hedge, slightly, somewhat, vaguely

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

g = hedge(g,2);
