% TRUKSIM Simulation of uncontrolled truck.
%   This script is referred to in Chapter 5.
%
% USES: trukmod, trukplot.

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

clc
clear

% SIMULATION UNCONTROLLED TRUCK
% =============================

% INITIAL STATE
deg = (pi/180);
s0 = [30; -70; 70*deg];

% Horizontal position = 30 meters
% Vertical position = -70 meters
% Truck angle = 70 degrees

% TIME
t0 = 0;
t1 = 160;
dt= 0.2;
T = (t0+dt):dt:t1;
steps = length(T);

% STEERING ANGLE
u = 2*deg;

S = zeros(3,steps);

s = s0;
trukplot(s,u)
title('Uncontrolled Truck');

for i=1:steps

  % UPDATE STATE
  s = s + dt * trukmod(s,u);

  % MAKE SURE ANGLE BETWEEN 0 AND 2*PI
  s(3) = rem(s(3), 2*pi);

  % DRAW EVERY 10 TIME STEPS
  if rem(i,10) == 0
    trukplot(s,u,'add');
  end

  % SAVE VALUES
  S(:,i) = s;
end

% PLOT RESPONSES
% ==============

% HORIZONTAL POSITION RESPONSE
clc
disp('Hit any key to see the Horizontal Position Response...')
pause;
plot([t0 T],[s0(1) S(1,:)])
hold on
plot([t0 t1],[0 0],':')
hold off
title('Horizontal Position Response')
xlabel('Time (Seconds)')
ylabel('Horizontal Position (Meters)')
pause

% VERTICAL POSITION RESPONSE
clc
disp('Hit any key to see the Vertical Position Response...')
pause
plot([t0 T],[s0(2) S(2,:)])
hold on
plot([t0 t1],[0 0],':')
hold off
title('Vertical Position Response')
xlabel('Time (Seconds)')
ylabel('Vertical Position (Meters)')
pause

% ANGLE RESPONSE
clc
disp('Hit any key to see the Angle Response...')
pause
plot([t0 T],[s0(3) S(3,:)]/deg)
hold on
plot([t0 t1],[0 0],':')
hold off
title('Truck Angle Response')
xlabel('Time (Seconds)')
ylabel('Truck Angle (Degrees)')
pause
clear

