function trukplot(s,u,f)
% TRUKPLOT Draws truck.
%   This function is referred to in Chapter 5.
%
% TRUKPLOT(X,U)
%   X - Current state of truck.
%   U - Steering angle.
% Plots truck.
%
% TRUKPLOT(X,U,'save')
% Plots truck on existing plot.
%
% The state X is = [horizontal position;
%                   vertical position;
%                   angle of trucks body];
%
% Angles are in radians.
%
% SEE ALSO: trukplot, truksim, trukcon1, trukcon2

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% CONSTANTS
L = 5;     % Truck length
W = 3;     % Truck width

% STATE
pos = s(1)+sqrt(-1)*s(2);
phi = s(3)-pi/2;

% PLOTTING
% ========

% AXIS (IF NECESSARY)
if nargin < 3
  hold off
  clg
  axis([0 100 -100 0]);
  plot(50,0,'*')
  grid
end

% TRUCK
[sr,sc] = size(s);
hold on
truck = [0 0 -L -L 0]+i*[-W/2 W/2 W/2 -W/2 -W/2];
plot(pos+truck*exp(i*phi))
wheel = [1 -1]*exp(-i*u)-L;
plot(pos+wheel*exp(i*phi));
hold off
