function ds=trukmod(s,u)
% TRUKMOD Dynamical model of truck.
%   This function is referred to in Chapter 5.
%
% EXTRUCK(X,U)
%   X - Current state of pendulum.
%   U - Steering angle.
% Returns the derivative of state dX.
%
% The state X is = [horizontal position;
%                   vertical position;
%                   angle of trucks body];
%
% Angles are in radians.
%
% SEE ALSO: trukplot, truksim, trukcon1, trukcon2

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% CONSTANTS
L = 1;   % Length of truck. (Distance between wheels.)
v = 1;   % Velocity of truck.

% STATES
pos = s(1) + sqrt(-1)*s(2);
angle = s(3);

% DERIVATIVES
dpos = v*cos(u)*exp(j*(angle-pi/2));
dangle = v*sin(u)/L;

ds = [real(dpos); imag(dpos); dangle];
