% Stage 5 for Truck Demonstration

% Copyright (c) 1993 by PWS Publishing Company

set([f1,info_win],'vis','off');
set(info_str,'string','');

set(f2,'name','Horizontal Position Response','pos',[167,250,305,205]./scrn);
set(f3,'name','Vertical Position Response','pos',[10,10,305,205]./scrn);
set(f4,'name','Truck Angle Response','pos',[325,10,305,205]./scrn);

figure(f2);
plot([t0 T],[s0(1) S(1,:)]);
hold on
plot([t0 t1],[0 0],':')
xlabel('Time (Seconds)')
ylabel('Horizontal Position (Meters)')
grid

figure(f3);
plot([t0 T],[s0(2) S(2,:)])
hold on
plot([t0 t1],[0 0],':')
xlabel('Time (Seconds)')
ylabel('Vertical Position (Meters)')
grid

figure(f4);
plot([t0 T],[s0(3) S(3,:)]/deg)
hold on
plot([t0 t1],[0 0],':')
xlabel('Time (Seconds)')
ylabel('Truck Angle (Degrees)')
grid

left=(scrnsz(3)-480)/2;
botm=(scrnsz(4)-80)/2;
set(info_win,'pos',[left,botm,480,80]);
set(b(1),'string','Quit','callback',...
         'close([info_win,f1,f2,f3,f4,f5]);set(demo_win,''vis'',''on'');clear',...
         'vis','on','pos',[73,5,90,20]);
set(b(2),'string','Controller 1','callback','trkdemod',...
         'pos',[196,5,90,20],'vis','on');
set(b(3),'string','Controller 2','callback','trkdemog','vis','on',...
         'pos',[319,5,90,20]);
         
str=['The Truck can have a horizontal position ranging from 0 to 100.  This range is ',...
'covered here with five fuzzy sets.  Ranges for the truck angle and steering angle ',...
'are divided into seven sets each.  Controller 1 backs the truck successfully, but ',...
'the truck is not well centered at the dock.  To improve performance, we design ',...
'controller 2 with the middle three horizontal fuzzy sets gathered in the center ',...
'of the horizontal position.  Now the truck turns toward the center more quickly, ',...
'centers well, and approaches the dock at a 90 degree angle as desired.'];

han=strformt(str,[80,480],info_win);
set(info_str(1),'string','Fuzzy Sets for Two Controllers',...
                'pos',[110,55,260,20]);
set(info_str(2),'pos',[110,30,260,20]);                
set(info_win,'vis','on');
