function plotfs2(s,t,x,y)
% PLOTFS2 Sets up axis for fuzzy set plots for the demos.
%
% PLOTFS2(S,'T','X','Y')
%   S - Row vector of support values.
%   T - Title string. (Default = 'FUZZY SET')
%   X - X axis label. (Default = 'Support')
%   Y - Y axis label. (Default = 'Grade')
% Prepares for future plots of fuzzy sets.
%
% EXAMPLE: s = 0:.1:10;
%          g = large(s);
%          plotfs2(s,'Large')
%          plot(s,g)
%          hold off
%
% WARNING: PLOTFS sets up a plot which will accept all new
%   plotting commands until a "hold off" command is issued.
%
% SEE ALSO: plotfsl, plotmax, plotmin

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

if nargin < 2, t = 'FUZZY SET'; end
if nargin < 3, x = 'Support'; end
if nargin < 4, y = 'Grade'; end

%clf reset
%hold on

mins = min(s);
maxs = max(s);
border = (maxs-mins)*0.02;
minb = mins-border;
maxb = maxs+border;

set(gca,'ylimmode','manual')
set(gca,'ylim',[-0.05,1.05])
set(gca,'xlimmode','manual')
set(gca,'xlim',[minb maxb]);
set(gca,'box','on')

plot([minb maxb],[0.5 0.5],':')
title(t)
xlabel(x)
ylabel(y)
hold on
