function penplot(x,u,t,fig,flag)
% PENPLOT Plots pendulum and displays info.
%   This function is referred to in Chapter 5.
%
% PENPLOT(X,U,T)
%   X - Current state of pendulum.
%   U - Force being applied to the pendulum base.
%   T - Time.
% Plots pendulum.
%
% The state X is = [base position;
%                   base velocity;
%                   pendulum angle;
%                   pendulum angular velocity]
%
% All angles are in radians.

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% CONSTANTS
L = 1;
bkclr=[0,0,0];

% STATE
pos = x(1);
vel = x(2);
phi = x(3);
cp=0.125*exp(i*[0:0.1:2*pi]);

if (phi > pi/2), phi = pi/2, end
if (phi < -pi/2), phi = -pi/2, end

% PLOT BORDERS
% midx = round(pos/5)*5;
 midx = 0;
 minx = midx-5;
 maxx = midx+5;

% PENDULUM END POINT
 xp=sin(phi);
 yp=cos(phi);

% PLOTTING
% ========

if flag,

  pen_win=[400,200,400,200];
  lft=70; btm=-10;
  uicontrol(fig,'style','text','units','norm','pos',[10+lft,170+btm,60,17]./pen_win,...
            'backgroundcolor',bkclr,'foregroundcolor',[1,1,1],...
            'string','Position:','horizontalalignment','left');
  txt(1)=uicontrol(fig,'style','text','units','norm','pos',[70+lft,170+btm,60,17]./pen_win,...
            'string',sprintf('%7.5f',pos));
  
  uicontrol(fig,'style','text','units','norm','pos',[150+lft,170+btm,60,17]./pen_win,...
            'backgroundcolor',bkclr,'foregroundcolor',[1,1,1],...
            'string','Pos Vel:','horizontalalignment','left');
  txt(2)=uicontrol(fig,'style','text','units','norm','pos',[210+lft,170+btm,60,17]./pen_win,...
            'string',sprintf('%7.5f',vel));
   
  uicontrol(fig,'style','text','units','norm','pos',[10+lft,148+btm,60,17]./pen_win,...
            'backgroundcolor',bkclr,'foregroundcolor',[1,1,1],...
            'string','Angle:','horizontalalignment','left');
  txt(3)=uicontrol(fig,'style','text','units','norm','pos',[70+lft,148+btm,60,17]./pen_win,...
            'string',sprintf('%7.5f',phi));
 
  uicontrol(fig,'style','text','units','norm','pos',[150+lft,148+btm,60,17]./pen_win,...
            'backgroundcolor',bkclr,'foregroundcolor',[1,1,1],...
            'string','Ang Vel:','horizontalalignment','left');
  txt(4)=uicontrol(fig,'style','text','units','norm','pos',[210+lft,148+btm,60,17]./pen_win,...
            'string',sprintf('%7.5f',vel));
  
  uicontrol(fig,'style','text','units','norm','pos',[10+lft,126+btm,60,17]./pen_win,...
            'backgroundcolor',bkclr,'foregroundcolor',[1,1,1],...
            'string','Force:','horizontalalignment','left');
  txt(5)=uicontrol(fig,'style','text','units','norm','pos',[70+lft,126+btm,60,17]./pen_win,...
            'string',sprintf('%7.5f',u));

  uicontrol(fig,'style','text','units','norm','pos',[150+lft,126+btm,60,17]./pen_win,...
            'backgroundcolor',bkclr,'foregroundcolor',[1,1,1],...
            'string','Time:','horizontalalignment','left');
  txt(6)=uicontrol(fig,'style','text','units','norm','pos',[210+lft,126+btm,60,17]./pen_win,...
            'string',sprintf('%7.3f',t));
  set(txt,'backgroundcolor',bkclr,'foregroundcolor',[1,1,1],...
          'horizontalalignment','right');
 
  ax=get(fig,'currentaxes');
  set(ax,'box','off','xtick',[],'ytick',[],'xcolor',[0 0 0],'ycolor',[0 0 0],...
          'xlim',[minx,maxx],'ylim',[0,4],'vis','off',...
          'nextplot','add');

  figure(fig);

% DRAW CART
  ln(1)=patch('xdata',[-1,1,1,-1]+pos,'ydata',[0.5,0.5,0.6,0.6],'facecolor','r',...
              'erase','xor');
  ln(2)=patch('xdata',(real(cp)+pos)+0.5,'ydata',imag(cp)+0.375,'facecolor','b',...
              'erase','xor');
  ln(3)=patch('xdata',(real(cp)+pos)-0.5,'ydata',imag(cp)+0.375,'facecolor','b',...
              'erase','xor');
             
% DRAW PENDULUM
  ln(4)=line('xdata',[[0 xp]*L+pos],'ydata',[[0 yp]*L+.6],...
             'linewidth',4,'color','g','erase','xor');
 
% DRAW AXIS             
  ln(5)=line('xdata',[minx minx],'ydata',[0 .5],'color','r','erase','xor');
  ln(6)=line('xdata',[maxx maxx],'ydata',[0 0.5],'color','r','erase','xor');
  ln(7)=line('xdata',[midx midx],'ydata',[0 0.25],'color','r','erase','xor');
  ln(8)=line('xdata',[minx maxx],'ydata',[0.25 0.25],'color','g','erase','xor');
  plot(0,0.25,'or')
 
  txt(7)=text('pos',[minx-.1,-0.1],'string',sprintf('%g',minx),'erase','xor');
  txt(8)=text('pos',[maxx-.1,-0.1],'string',sprintf('%g',maxx),'erase','xor');
  set(fig,'userdata',[ln,txt]);
else
 han=get(fig,'userdata');
 ln=han(1:8);
 txt=han(9:16);
 
 set(ln(1),'xdata',[-1,1,1,-1]+pos);
 set(ln(2),'xdata',(real(cp)+pos)+0.5);
 set(ln(3),'xdata',(real(cp)+pos)-0.5);
 
 set(ln(4),'xdata',[0 xp]*L+pos,'ydata',[0 yp]*L+.61);

 set(txt(1),'string',sprintf('%7.5f',pos));
 set(txt(2),'string',sprintf('%7.5f',vel));
 set(txt(3),'string',sprintf('%7.5f',phi));
 set(txt(4),'string',sprintf('%7.5f',vel));
 set(txt(5),'string',sprintf('%7.5f',u));
 set(txt(6),'string',sprintf('%7.3f',t));
 
end
