% Stage 4 for Pendulum Demonstration

% Copyright (c) 1993 by PWS Publishing Company

set(info_win,'vis','off');
set(info_str,'string','');

% SIMULATION OF CONTROLLED PENDULUM
% =================================

% SETUP DISPLAY WINDOWS

set([f2,f3,f4,f5,f6,f7],'vis','off');

% INITIAL STATE
x0 = [4; 0; 0*deg; 0*deg];

% TIME
t0 = 0;
t1 = 35;
dt= 0.05;
T = (t0+dt):dt:t1;
steps = length(T);

X = zeros(4,steps);
R = zeros(1,steps);
U = zeros(1,steps);

x = x0;
penplot(x,0,0,f1,0);
set(f1,'name','Controlled Pendulum','vis','on');
drawnow;

for i=1:steps

  % EVALUATE CONTROLLER EVERY 3 TIMESTEPS
  if rem(i,3) == 1
    r = frules(A1,W1,Z1,[x(1); x(2)]); if isnan(r), return, end
    u = frules(A2,W2,Z2,[x(4); x(3)-r]); if isnan(u), return, end
  end

  % UPDATE STATE
  x = x + dt * pendmod(x,u);

  % CHECK FOR COLLISION OF PENDULUM WITH BASE
  if abs(x(3)) > pi/2, x(3) = sign(x(3))*pi/2; end

  % PLOT EVERY 3 TIME STEPS
	 if rem(i,3) == 1
     penplot(x,u,i*dt,f1,0);
	 end

  % SAVE VALUES
  X(:,i) = x;
  R(i) = r; 
  U(i) = u;
  
  % FINISH IF BALANCED AND CENTERED
  if all(abs(x) < 0.01)
    steps = i;
    X = X(:,1:steps);
    R = R(1:steps);
    U = U(1:steps);
    T = T(1:steps);
    t1 = t0+steps*dt;
    break
  end
end

set(info_str(1),'string','View Responses...?');
set(b(3),'string','Responses','callback','pendemof');
set(info_win,'vis','on');

