function [x,y] = numdraw(s1,s2)
% NUMDRAW Allows user to draw a character with the mouse.
%   This function is referred to in Chapter 6.
%
% [X,Y] = NUMDRAW(SX,SY)
%   SX - Horizontal support vector.
%   SY - Vertical support vector.
% Returns:
%   X  - Row vector of horizontal coordinates of points.
%   Y  - Row vector of vertical coordinates of points.
%
% NUMDRAW assumes that both support vectors consist of values
%   ordered by size and equally spaced.

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% USEFUL CONSTANTS
% ================

len1 = length(s1);
max1 = s1(1);
min1 = s1(len1);
len2 = length(s2);
max2 = s2(1);
min2 = s2(len2);

% SETUP DRAWING AREA
% ==================

clg
hold off
axis([0.5 len1+0.5 0.5 len2+0.5]);
hold on
plot([0 1 1 0 0]*(len1)+0.5,[0 0 1 1 0]*(len2)+0.5)
hold on
for i=1:len1
  plot([i i],[0.5 len2+0.5],':');
end
for i=1:len2
  plot([0.5 len1+0.5],[i i],':')
end
title('CREATE DIGIT BY CLICKING IN SQUARE.')
xlabel('* Click HERE when done *')

% GET DRAWN DIGIT FROM USER
% =========================

[x,y] = ginput(1);
if  (x >= 0.5) & (x <= len1+0.5) & (y >= 0.5) & (y <= len2+0.5)
  plot(x,y,'og');
  X = x;
  Y = y;
  while (1)
    x2 = x;
    y2 = y;
    [x,y] = ginput(1);
    if  (x < 0.5) | (x > len1+0.5) | (y < 0.5) | (y > len2+0.5), break, end
    plot(x,y,'og')
    plot([x2 x],[y2 y],'g')
    X = [X x];
    Y = [Y y];
  end
end
clg
hold off
if X == [];
  z = [];
  disp('User did not enter any points.')
  return
end

% NORMALIZE DRAWING
% =================

maxx = max(X);
minx = min(X);
ranx = maxx-minx;
maxy = max(Y);
miny = min(Y);
rany = maxy-miny;

% HANDLE 1's

if ranx == 0
  ranx = len1
elseif (rany/ranx) > 8
  ranx = len1;
end

mult = (len1-1)/ranx;
X = (X-minx)*mult+1;
mult = (len2-1)/rany;
Y = (Y-miny).*((len2-1)/rany)+1;

% FILL IN POINTS
% ==============

b = zeros(len1,len2);
b(round(X(1)),round(Y(1))) = 1;
m1 = diff(X);
m2 = diff(Y);
for i=1:(length(X)-1)
  for j=0.01:0.01:1
    b(round(X(i)+j*m1(i)),round(Y(i)+j*m2(i))) = 1;
  end
end
z = table(1:len1,1:len2)';
delCol = find(b == 0);
z(:,delCol) = [];

% DRAW SUPPORT POINTS
% ===================

axis([0.5 len1+0.5 0.5 len2+0.5]);
hold on
plot([0 1 1 0 0]*(len1)+0.5,[0 0 1 1 0]*(len2)+0.5)
for i=1:len1
  plot([i i],[0.5 len2+0.5],':');
end
for i=1:len2
  plot([0.5 len1+0.5],[i i],':')
end
plot(z(1,:),z(2,:),'*g')
title ('RESIZED CHARACTER')
hold off

% CONVERT POINTS INTO SUPPORT COORDINATES
% =======================================

x = s1(z(1,:));
y = s2(z(2,:));

